/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java;

import com.sun.tools.visualvm.heapviewer.java.Bundle;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.JavaNameRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.MultiRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;

public class StackFrameNodeRenderer
extends MultiRenderer
implements HeapViewerRenderer {
    private final LabelRenderer atRenderer = new LabelRenderer();
    private final JavaNameRenderer methodRenderer;
    private final ProfilerRenderer[] renderers;

    public StackFrameNodeRenderer() {
        this.atRenderer.setText(Bundle.StackFrameNodeRenderer_AtMark());
        this.atRenderer.setMargin(3, 3, 3, 0);
        this.methodRenderer = new JavaNameRenderer();
        this.renderers = new ProfilerRenderer[]{this.atRenderer, this.methodRenderer};
    }

    protected ProfilerRenderer[] valueRenderers() {
        return this.renderers;
    }

    public void setValue(Object value, int row) {
        this.methodRenderer.setValue(value, row);
    }

    @Override
    public String getShortName() {
        String name = this.methodRenderer.toString();
        int nameIdx = name.indexOf(40);
        if (nameIdx == -1) {
            return this.atRenderer + " " + name;
        }
        String method = name.substring(0, nameIdx);
        int dotIdx = method.lastIndexOf(46);
        if (dotIdx == -1) {
            return this.atRenderer + " " + name;
        }
        String cls = method.substring(0, dotIdx);
        dotIdx = cls.lastIndexOf(46);
        return this.atRenderer + " " + method.substring(dotIdx + 1) + name.substring(nameIdx);
    }
}

