/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.common.Profiler;

public final class CommonUtils {
    public static void runInEventDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void runInEventDispatchThreadAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                Profiler.getDefault().notifyException(8, invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                Profiler.getDefault().notifyException(8, interruptedException);
            }
        }
    }
}

