# Firejail profile for patch
# Description: Apply a diff file to an original
# This file is overwritten after every install/update
quiet
# Persistent local customizations
include patch.local
# Persistent global definitions
include globals.local

noblacklist ${DOCUMENTS}

include disable-common.inc
include disable-devel.inc
include disable-interpreters.inc
include disable-passwdmgr.inc
include disable-xdg.inc

include whitelist-var-common.inc

caps.drop all
ipc-namespace
net none
no3d
nodbus
nodvd
nogroups
nonewprivs
noroot
nosound
notv
nou2f
novideo
protocol unix
seccomp
shell none

private-bin patch,red
private-dev
private-lib

memory-deny-write-execute
noexec ${HOME}
noexec /tmp
