/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.swift;

import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.language.base.compile.CompilerVersion;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerUtil;
import org.gradle.language.base.internal.compile.DefaultCompilerVersion;
import org.gradle.language.base.internal.compile.VersionAwareCompiler;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.internal.LinkerSpec;
import org.gradle.nativeplatform.internal.StaticLibraryArchiverSpec;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;
import org.gradle.nativeplatform.toolchain.SwiftcPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.AbstractPlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.DefaultCommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.DefaultMutableCommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.EmptySystemLibraries;
import org.gradle.nativeplatform.toolchain.internal.Stripper;
import org.gradle.nativeplatform.toolchain.internal.SymbolExtractor;
import org.gradle.nativeplatform.toolchain.internal.SymbolExtractorOsConfig;
import org.gradle.nativeplatform.toolchain.internal.SystemLibraries;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.compilespec.SwiftCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.gcc.ArStaticLibraryArchiver;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetadata;
import org.gradle.nativeplatform.toolchain.internal.swift.SwiftCompiler;
import org.gradle.nativeplatform.toolchain.internal.swift.SwiftLinker;
import org.gradle.nativeplatform.toolchain.internal.swift.metadata.SwiftcMetadata;
import org.gradle.nativeplatform.toolchain.internal.tools.CommandLineToolConfigurationInternal;
import org.gradle.nativeplatform.toolchain.internal.tools.CommandLineToolSearchResult;
import org.gradle.nativeplatform.toolchain.internal.tools.ToolSearchPath;
import org.gradle.process.internal.ExecActionFactory;

class SwiftPlatformToolProvider
extends AbstractPlatformToolProvider {
    private final ToolSearchPath toolSearchPath;
    private final SwiftcPlatformToolChain toolRegistry;
    private final ExecActionFactory execActionFactory;
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;
    private final WorkerLeaseService workerLeaseService;
    private final SwiftcMetadata swiftcMetaData;

    SwiftPlatformToolProvider(BuildOperationExecutor buildOperationExecutor, OperatingSystemInternal targetOperatingSystem, ToolSearchPath toolSearchPath, SwiftcPlatformToolChain toolRegistry, ExecActionFactory execActionFactory, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, WorkerLeaseService workerLeaseService, SwiftcMetadata swiftcMetaData) {
        super(buildOperationExecutor, targetOperatingSystem);
        this.toolRegistry = toolRegistry;
        this.toolSearchPath = toolSearchPath;
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.execActionFactory = execActionFactory;
        this.workerLeaseService = workerLeaseService;
        this.swiftcMetaData = swiftcMetaData;
    }

    @Override
    public CommandLineToolSearchResult locateTool(ToolType compilerType) {
        if (compilerType == ToolType.SWIFT_COMPILER || compilerType == ToolType.LINKER) {
            return this.toolSearchPath.locate(compilerType, "swiftc");
        }
        if (compilerType == ToolType.STATIC_LIB_ARCHIVER) {
            return this.toolSearchPath.locate(compilerType, "ar");
        }
        if (compilerType == ToolType.SYMBOL_EXTRACTOR) {
            return this.toolSearchPath.locate(compilerType, SymbolExtractorOsConfig.current().getExecutableName());
        }
        if (compilerType == ToolType.STRIPPER) {
            return this.toolSearchPath.locate(compilerType, "strip");
        }
        throw new IllegalArgumentException();
    }

    @Override
    public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
        if (SwiftCompileSpec.class.isAssignableFrom(spec)) {
            return CompilerUtil.castCompiler(this.createSwiftCompiler());
        }
        return super.newCompiler(spec);
    }

    protected Compiler<LinkerSpec> createLinker() {
        CommandLineToolConfigurationInternal linkerTool = (CommandLineToolConfigurationInternal)this.toolRegistry.getLinker();
        SwiftLinker swiftLinker = new SwiftLinker(this.buildOperationExecutor, this.commandLineTool(ToolType.LINKER, "swiftc"), this.context(linkerTool), this.workerLeaseService);
        return new VersionAwareCompiler((Compiler)swiftLinker, (CompilerVersion)new DefaultCompilerVersion("swiftc", this.swiftcMetaData.getVendor(), this.swiftcMetaData.getVersion()));
    }

    protected Compiler<SwiftCompileSpec> createSwiftCompiler() {
        CommandLineToolConfigurationInternal swiftCompilerTool = (CommandLineToolConfigurationInternal)this.toolRegistry.getSwiftCompiler();
        SwiftCompiler swiftCompiler = new SwiftCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(ToolType.SWIFT_COMPILER, "swiftc"), this.context(swiftCompilerTool), this.getObjectFileExtension(), this.workerLeaseService, this.swiftcMetaData.getVersion());
        return new VersionAwareCompiler((Compiler)swiftCompiler, (CompilerVersion)new DefaultCompilerVersion("swiftc", this.swiftcMetaData.getVendor(), this.swiftcMetaData.getVersion()));
    }

    protected Compiler<StaticLibraryArchiverSpec> createStaticLibraryArchiver() {
        CommandLineToolConfigurationInternal staticLibArchiverTool = (CommandLineToolConfigurationInternal)this.toolRegistry.getStaticLibArchiver();
        return new ArStaticLibraryArchiver(this.buildOperationExecutor, this.commandLineTool(ToolType.STATIC_LIB_ARCHIVER, "ar"), this.context(staticLibArchiverTool), this.workerLeaseService);
    }

    @Override
    protected Compiler<?> createSymbolExtractor() {
        CommandLineToolConfigurationInternal symbolExtractor = (CommandLineToolConfigurationInternal)this.toolRegistry.getSymbolExtractor();
        return new SymbolExtractor(this.buildOperationExecutor, this.commandLineTool(ToolType.SYMBOL_EXTRACTOR, SymbolExtractorOsConfig.current().getExecutableName()), this.context(symbolExtractor), this.workerLeaseService);
    }

    @Override
    protected Compiler<?> createStripper() {
        CommandLineToolConfigurationInternal stripper = (CommandLineToolConfigurationInternal)this.toolRegistry.getStripper();
        return new Stripper(this.buildOperationExecutor, this.commandLineTool(ToolType.STRIPPER, "strip"), this.context(stripper), this.workerLeaseService);
    }

    private CommandLineToolInvocationWorker commandLineTool(ToolType key, String exeName) {
        return new DefaultCommandLineToolInvocationWorker(key.getToolName(), this.toolSearchPath.locate(key, exeName).getTool(), this.execActionFactory);
    }

    private CommandLineToolContext context(CommandLineToolConfigurationInternal toolConfiguration) {
        DefaultMutableCommandLineToolContext baseInvocation = new DefaultMutableCommandLineToolContext();
        baseInvocation.setArgAction(toolConfiguration.getArgAction());
        return baseInvocation;
    }

    @Override
    public SystemLibraries getSystemLibraries(ToolType compilerType) {
        return new EmptySystemLibraries();
    }

    @Override
    public CompilerMetadata getCompilerMetadata(ToolType compilerType) {
        return this.swiftcMetaData;
    }
}

