/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.PluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.ClassPathPluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

public class AlreadyOnClasspathPluginResolver
implements PluginResolver {
    private static final Factory<ClassPath> EMPTY_CLASSPATH_FACTORY = Factories.constant((Object)ClassPath.EMPTY);
    private final PluginResolver delegate;
    private final PluginRegistry corePluginRegistry;
    private final PluginDescriptorLocator pluginDescriptorLocator;
    private final ClassLoaderScope parentLoaderScope;
    private final PluginInspector pluginInspector;

    public AlreadyOnClasspathPluginResolver(PluginResolver delegate, PluginRegistry corePluginRegistry, ClassLoaderScope parentLoaderScope, PluginDescriptorLocator pluginDescriptorLocator, PluginInspector pluginInspector) {
        this.delegate = delegate;
        this.corePluginRegistry = corePluginRegistry;
        this.pluginDescriptorLocator = pluginDescriptorLocator;
        this.parentLoaderScope = parentLoaderScope;
        this.pluginInspector = pluginInspector;
    }

    @Override
    public void resolve(PluginRequestInternal pluginRequest, PluginResolutionResult result) {
        PluginId pluginId = pluginRequest.getId();
        if (this.isCorePlugin(pluginId) || this.isAbsentFromTheClasspath(pluginId)) {
            this.delegate.resolve(pluginRequest, result);
        } else {
            if (pluginRequest.getOriginalRequest().getVersion() != null) {
                throw new InvalidPluginRequestException(pluginRequest, "Plugin request for plugin already on the classpath must not include a version");
            }
            this.resolveAlreadyOnClasspath(pluginId, result);
        }
    }

    private void resolveAlreadyOnClasspath(PluginId pluginId, PluginResolutionResult result) {
        ClassPathPluginResolution pluginResolution = new ClassPathPluginResolution(pluginId, this.parentLoaderScope, EMPTY_CLASSPATH_FACTORY, this.pluginInspector);
        result.found("Already on classpath", pluginResolution);
    }

    private boolean isAbsentFromTheClasspath(PluginId pluginId) {
        return this.pluginDescriptorLocator.findPluginDescriptor(pluginId.toString()) == null;
    }

    private boolean isCorePlugin(PluginId pluginId) {
        return this.corePluginRegistry.lookup(pluginId) != null;
    }
}

