/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.artifacts.repositories.AbstractResolutionAwareArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.AuthenticationSupporter;
import org.gradle.api.model.ObjectFactory;
import org.gradle.authentication.Authentication;
import org.gradle.internal.Cast;
import org.gradle.internal.artifacts.repositories.AuthenticationSupportedInternal;
import org.gradle.internal.authentication.AuthenticationInternal;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.CollectionUtils;

public abstract class AbstractAuthenticationSupportedRepository
extends AbstractResolutionAwareArtifactRepository
implements AuthenticationSupportedInternal {
    private final AuthenticationSupporter delegate;

    AbstractAuthenticationSupportedRepository(Instantiator instantiator, AuthenticationContainer authenticationContainer, ObjectFactory objectFactory) {
        super(objectFactory);
        this.delegate = new AuthenticationSupporter(instantiator, authenticationContainer);
    }

    public PasswordCredentials getCredentials() {
        this.invalidateDescriptor();
        return this.delegate.getCredentials();
    }

    public <T extends Credentials> T getCredentials(Class<T> credentialsType) {
        this.invalidateDescriptor();
        return this.delegate.getCredentials(credentialsType);
    }

    @Nullable
    public Credentials getConfiguredCredentials() {
        return this.delegate.getConfiguredCredentials();
    }

    public void setConfiguredCredentials(Credentials credentials) {
        this.invalidateDescriptor();
        this.delegate.setConfiguredCredentials(credentials);
    }

    public void credentials(Action<? super PasswordCredentials> action) {
        this.invalidateDescriptor();
        this.delegate.credentials(action);
    }

    public <T extends Credentials> void credentials(Class<T> credentialsType, Action<? super T> action) throws IllegalStateException {
        this.invalidateDescriptor();
        this.delegate.credentials(credentialsType, action);
    }

    public void authentication(Action<? super AuthenticationContainer> action) {
        this.invalidateDescriptor();
        this.delegate.authentication(action);
    }

    public AuthenticationContainer getAuthentication() {
        this.invalidateDescriptor();
        return this.delegate.getAuthentication();
    }

    public Collection<Authentication> getConfiguredAuthentication() {
        return this.delegate.getConfiguredAuthentication();
    }

    List<String> getAuthenticationSchemes() {
        return CollectionUtils.collect(this.getConfiguredAuthentication(), (Transformer)new Transformer<String, Authentication>(){

            public String transform(Authentication authentication) {
                return ((AuthenticationInternal)Cast.cast(AuthenticationInternal.class, (Object)authentication)).getType().getSimpleName();
            }
        });
    }
}

