/*
 * Decompiled with CFR 0.152.
 */
package org.testng.mustache;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Stack;
import org.testng.mustache.Value;

public class Model {
    private Map<String, Object> m_model;
    private Stack<SubModel> m_subModels = new Stack();

    public Model(Map<String, Object> map) {
        this.m_model = map;
    }

    public void push(String string, Object object) {
        SubModel subModel = new SubModel();
        subModel.variable = string;
        subModel.subModel = object;
        this.m_subModels.push(subModel);
    }

    public Value resolveValue(String string) {
        if (!this.m_subModels.isEmpty()) {
            for (SubModel subModel : this.m_subModels) {
                Value value = this.resolveOnClass(subModel.subModel, string);
                if (value == null) continue;
                return value;
            }
        }
        return new Value(this.m_model.get(string));
    }

    private Value resolveOnClass(Object object, String string) {
        Class<?> clazz = object.getClass();
        try {
            Field field = clazz.getField(string);
            return new Value(field.get(object));
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
            return null;
        }
    }

    public Object getTopSubModel() {
        return this.m_subModels.peek().variable;
    }

    public void popSubModel() {
        this.m_subModels.pop();
    }

    public String resolveValueToString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Value value = this.resolveValue(string);
        if (value.get() != null) {
            return value.get().toString();
        }
        return "";
    }

    public String toString() {
        return "[Model " + this.m_model + " subModel:" + this.m_subModels + "]";
    }

    private static class SubModel {
        String variable;
        Object subModel;

        private SubModel() {
        }
    }
}

