/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.CU;
import javajs.util.P3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class EfvetReader
extends PolygonFileReader {
    private int[] vertexMap;

    EfvetReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2PFR(surfaceGenerator, bufferedReader);
        this.jvxlFileHeaderBuffer.append("efvet file format\nvertices and triangles only\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
        this.hasColorData = true;
    }

    @Override
    void getSurfaceData() throws Exception {
        this.getHeader();
        this.getVertices();
        this.getTriangles();
        Logger.info("efvet file contains " + this.nVertices + " vertices and " + this.nTriangles + " triangles");
    }

    private void getHeader() throws Exception {
        this.skipTo("<efvet", null);
        while (this.rd().length() > 0 && this.line.indexOf(">") < 0) {
            this.jvxlFileHeaderBuffer.append("# " + this.line + "\n");
        }
        Logger.info(this.jvxlFileHeaderBuffer.toString());
    }

    private void getVertices() throws Exception {
        P3 p3 = new P3();
        float f = 0.0f;
        this.skipTo("<vertices", "count");
        this.jvxlData.vertexCount = this.nVertices = this.parseInt();
        this.vertexMap = new int[this.nVertices + 1];
        this.jvxlData.vertexColors = null;
        if (this.params.fileIndex == 0) {
            this.jvxlData.vertexColors = new int[this.nVertices];
            this.jvxlData.nVertexColors = 0;
        }
        float[] fArray = new float[this.jvxlData.vertexColors == null ? 3 : 9];
        this.skipTo("property=", null);
        this.line = this.line.replace('\"', ' ');
        String[] stringArray = this.getTokens();
        int n = this.params.fileIndex;
        if (n > 0 && n < stringArray.length) {
            Logger.info("property " + stringArray[n]);
        } else {
            Logger.info(this.line);
        }
        int n2 = 0;
        while (n2 < this.nVertices) {
            this.skipTo("<vertex", "image");
            this.parseFloatArray(fArray, null, ">");
            p3.set(fArray[0], fArray[1], fArray[2]);
            this.skipTo(null, "property");
            int n3 = 0;
            while (n3 < n) {
                f = this.parseFloat();
                ++n3;
            }
            if (this.isAnisotropic) {
                this.setVertexAnisotropy(p3);
            }
            if ((n3 = (this.vertexMap[n2 + 1] = this.addVC(p3, f, n2, true))) >= 0 && this.jvxlData.vertexColors != null) {
                this.jvxlData.vertexColors[n3] = CU.colorTriadToFFRGB(fArray[6], fArray[7], fArray[8]);
                ++this.jvxlData.nVertexColors;
            }
            ++n2;
        }
    }

    private void getTriangles() throws Exception {
        this.skipTo("<triangle_array", "count");
        this.nTriangles = this.parseInt();
        int n = 0;
        while (n < this.nTriangles) {
            this.skipTo("<triangle", "vertex");
            int n2 = this.getInt();
            int n3 = this.getInt();
            int n4 = this.getInt();
            if (n2 >= 0 && n3 >= 0 && n4 >= 0) {
                this.addTriangleCheck(n2, n3, n4, 7, 0, false, 0);
            }
            ++n;
        }
    }

    private int getInt() {
        return this.vertexMap[this.parseInt()];
    }
}

