/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.Map;
import javajs.api.Interface;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.T3;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.modelset.Atom;
import org.jmol.quantum.QS;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.quantum.SlaterData;
import org.jmol.quantum.mo.DataAdder;
import org.jmol.util.Logger;

public class MOCalculation
extends QuantumCalculation {
    public static final double ROOT3 = 1.7320507764816284;
    private static final double CUT = -50.0;
    private double[] CX;
    private double[] CY;
    private double[] CZ;
    private double[] DXY;
    private double[] DXZ;
    private double[] DYZ;
    public double[] EX;
    public double[] EY;
    public double[] EZ;
    private String calculationType;
    private Lst<int[]> shells;
    public float[][] gaussians;
    private SlaterData[] slaters;
    private float[] moCoefficients;
    private int moCoeff;
    public int gaussianPtr;
    public static final int NORM_NONE = 0;
    public static final int NORM_STANDARD = 1;
    public static final int NORM_NWCHEM = 2;
    public static final int NORM_NBO = 3;
    public int normType = 0;
    private int[][] dfCoefMaps;
    private float[] linearCombination;
    private float[][] coefs;
    private double moFactor = 1.0;
    public boolean havePoints;
    boolean testing = true;
    private int[] highLEnabled;
    double sum = -1.0;
    public int nGaussians;
    private boolean doShowShellType;
    private String warned;
    DataAdder[] dataAdders = new DataAdder[20];
    int[] dataAdderOK = new int[20];
    public double[] coeffs;
    private int[] map;
    private int lastGaussianPtr = -1;
    private static final String[][] shellOrder = new String[][]{{"S"}, {"X", "Y", "Z"}, {"S", "X", "Y", "Z"}, {"d0/z2", "d1+/xz", "d1-/yz", "d2+/x2-y2", "d2-/xy"}, {"XX", "YY", "ZZ", "XY", "XZ", "YZ"}, {"f0/2z3-3x2z-3y2z", "f1+/4xz2-x3-xy2", "f1-/4yz2-x2y-y3", "f2+/x2z-y2z", "f2-/xyz", "f3+/x3-3xy2", "f3-/3x2y-y3"}, {"XXX", "YYY", "ZZZ", "XYY", "XXY", "XXZ", "XZZ", "YZZ", "YYZ", "XYZ"}};
    private boolean isSquaredLinear;

    public boolean setupCalculation(Map<String, Object> map, boolean bl, VolumeData volumeData, BS bS, T3[] t3Array, Atom[] atomArray, int n, int[][] nArray, float[] fArray, float[] fArray2, boolean bl2, float[][] fArray3, T3[] t3Array2) {
        boolean bl3;
        String string = (String)map.get("calculationType");
        Lst lst = (Lst)map.get("shells");
        float[][] fArray4 = (float[][])map.get("gaussians");
        Object object = map.get("slaters");
        this.highLEnabled = (int[])map.get("highLEnabled");
        this.havePoints = t3Array2 != null;
        this.calculationType = string;
        this.firstAtomOffset = n;
        this.shells = lst;
        this.gaussians = fArray4;
        this.dfCoefMaps = nArray == null ? QS.getNewDfCoefMap() : nArray;
        this.coeffs = new double[this.dfCoefMaps[this.dfCoefMaps.length - 1].length];
        this.slaters = (SlaterData[])object;
        this.moCoefficients = fArray;
        this.linearCombination = fArray2;
        this.isSquaredLinear = bl2;
        this.coefs = fArray3;
        boolean bl4 = bl3 = bl || map.get("isNormalized") != Boolean.TRUE;
        if (bl3) {
            this.setNormalization(map.get("nboType"));
        }
        this.countsXYZ = volumeData.getVoxelCounts();
        this.initialize(this.countsXYZ[0], this.countsXYZ[1], this.countsXYZ[2], t3Array2);
        this.voxelData = volumeData.getVoxelData();
        this.voxelDataTemp = bl2 ? new float[this.nX][this.nY][this.nZ] : this.voxelData;
        this.setupCoordinates(volumeData.getOriginFloat(), volumeData.getVolumetricVectorLengths(), bS, t3Array, atomArray, t3Array2, false);
        this.doDebug = Logger.debugging;
        return !bS.isEmpty() && (object != null || this.checkCalculationType());
    }

    private void setNormalization(Object object) {
        String string = "standard";
        this.normType = 1;
        if (object != null) {
            this.normType = 3;
            string = "NBO-AO";
        } else if (this.calculationType != null && this.calculationType.indexOf("NWCHEM") >= 0) {
            this.normType = 2;
            string = "NWCHEM";
            Logger.info("Normalization of contractions (NWCHEM)");
        }
        Logger.info("Normalizing AOs: " + string + " slaters:" + (this.slaters != null));
    }

    @Override
    public void initialize(int n, int n2, int n3, T3[] t3Array) {
        this.initialize0(n, n2, n3, t3Array);
        this.CX = new double[this.nX];
        this.CY = new double[this.nY];
        this.CZ = new double[this.nZ];
        this.DXY = new double[this.nX];
        this.DXZ = new double[this.nX];
        this.DYZ = new double[this.nY];
        this.EX = new double[this.nX];
        this.EY = new double[this.nY];
        this.EZ = new double[this.nZ];
    }

    @Override
    public void createCube() {
        this.setXYZBohr(this.points);
        this.processPoints();
        if (!this.isSquaredLinear && (this.doDebug || this.testing)) {
            this.calculateElectronDensity();
        }
    }

    @Override
    public void processPoints() {
        if (this.linearCombination == null) {
            this.process();
        } else {
            int n;
            if (this.sum < 0.0) {
                this.sum = 0.0;
                n = 0;
                while (n < this.linearCombination.length) {
                    this.sum += (double)(this.linearCombination[n] * this.linearCombination[n]);
                    n += 2;
                }
                this.sum = Math.sqrt(this.sum);
            }
            if (this.sum == 0.0) {
                return;
            }
            n = 0;
            while (n < this.linearCombination.length) {
                this.moFactor = (double)this.linearCombination[n] / this.sum;
                if (this.moFactor != 0.0) {
                    this.moCoefficients = this.coefs[(int)this.linearCombination[n + 1] - 1];
                    this.process();
                    if (this.isSquaredLinear) {
                        this.addValuesSquared(1.0f);
                    }
                }
                n += 2;
            }
        }
    }

    @Override
    public void process() {
        this.atomIndex = this.firstAtomOffset - 1;
        this.moCoeff = 0;
        if (this.slaters == null) {
            int n = this.shells.size();
            int n2 = 0;
            while (n2 < n) {
                this.processShell(n2);
                ++n2;
            }
            return;
        }
        int n = 0;
        while (n < this.slaters.length) {
            if (!this.processSlater(n)) break;
            ++n;
        }
    }

    private boolean checkCalculationType() {
        if (this.calculationType == null) {
            Logger.warn("calculation type not identified -- continuing");
            return true;
        }
        if (this.calculationType.indexOf("+") >= 0 || this.calculationType.indexOf("*") >= 0) {
            Logger.warn("polarization/diffuse wavefunctions have not been tested fully: " + this.calculationType + " -- continuing");
        }
        if (this.calculationType.indexOf("?") >= 0) {
            Logger.warn("unknown calculation type may not render correctly -- continuing");
        } else if (this.points == null) {
            Logger.info("calculation type: " + this.calculationType + " OK.");
        }
        return true;
    }

    private void processShell(int n) {
        int n2 = this.atomIndex;
        int[] nArray = (int[])this.shells.get(n);
        this.atomIndex = nArray[0] - 1 + this.firstAtomOffset;
        int n3 = nArray[1];
        this.gaussianPtr = nArray[2] - 1;
        this.nGaussians = nArray[3];
        this.doShowShellType = this.doDebug;
        if (this.atomIndex != n2 && (this.thisAtom = this.qmAtoms[this.atomIndex]) != null) {
            this.thisAtom.setXYZ(this, true);
        }
        if (!this.setCoeffs(nArray[1], true)) {
            return;
        }
        if (this.havePoints) {
            this.setMinMax(-1);
        }
        switch (n3) {
            case 0: {
                this.addDataS();
                break;
            }
            case 1: {
                this.addDataP();
                break;
            }
            case 2: {
                this.addDataSP();
                break;
            }
            case 3: {
                this.addData5D();
                break;
            }
            case 4: {
                this.addData6D();
                break;
            }
            default: {
                String string;
                if (this.addHighL(n3)) {
                    return;
                }
                if (this.warned == null) {
                    this.warned = "";
                }
                if (this.warned.indexOf(string = "=" + (this.atomIndex + 1) + ": " + QS.getQuantumShellTag(n3)) >= 0) break;
                this.warned = String.valueOf(this.warned) + string;
                Logger.warn(" Unsupported basis type for atomno" + string);
            }
        }
    }

    private boolean addHighL(int n) {
        if (n >= 7 && this.highLEnabled[n] == 0) {
            return false;
        }
        DataAdder dataAdder = this.dataAdders[n];
        switch (this.dataAdderOK[n]) {
            case 0: {
                this.dataAdders[n] = dataAdder = (DataAdder)Interface.getInterface("org.jmol.quantum.mo.DataAdder" + QS.getQuantumShellTag(n));
                int n2 = this.dataAdderOK[n] = dataAdder == null ? -1 : 1;
                if (dataAdder != null) break;
            }
            case -1: {
                return false;
            }
        }
        if (dataAdder.addData(this, this.havePoints)) {
            return true;
        }
        this.dataAdders[n] = null;
        this.dataAdderOK[n] = -1;
        return false;
    }

    private void addValuesSquared(float f) {
        int n = this.nX;
        while (--n >= 0) {
            int n2 = this.nY;
            while (--n2 >= 0) {
                int n3 = this.nZ;
                while (--n3 >= 0) {
                    float f2 = this.voxelDataTemp[n][n2][n3];
                    if (f2 == 0.0f) continue;
                    float[] fArray = this.voxelData[n][n2];
                    int n4 = n3;
                    fArray[n4] = fArray[n4] + f2 * f2 * f;
                    this.voxelDataTemp[n][n2][n3] = 0.0f;
                }
            }
        }
    }

    public double getContractionNormalization(int n, int n2) {
        double d;
        double d2 = n == 3 ? 15 : (n == 2 ? 3 : 1);
        double d3 = d2 * Math.pow(Math.PI, 1.5) / Math.pow(2.0, n);
        double d4 = 0.75 + (double)n / 2.0;
        if (this.nGaussians == 1) {
            d = Math.pow(2.0, -2.0 * d4) * Math.pow(this.gaussians[this.gaussianPtr][n2], 2.0);
        } else {
            d = 0.0;
            int n3 = 0;
            while (n3 < this.nGaussians) {
                double d5 = this.gaussians[this.gaussianPtr + n3][0];
                double d6 = this.gaussians[this.gaussianPtr + n3][n2];
                double d7 = Math.pow(d5, d4);
                int n4 = 0;
                while (n4 < this.nGaussians) {
                    double d8 = this.gaussians[this.gaussianPtr + n4][0];
                    double d9 = this.gaussians[this.gaussianPtr + n4][n2];
                    double d10 = Math.pow(d8, d4);
                    d += d6 * d7 * d9 * d10 / Math.pow(d5 + d8, 2.0 * d4);
                    ++n4;
                }
                ++n3;
            }
        }
        d = 1.0 / Math.sqrt(d3 * d);
        if (Logger.debuggingHigh) {
            Logger.debug("\t\t\tnormalization for l=" + n + " nGaussians=" + this.nGaussians + " is " + d);
        }
        return d;
    }

    private boolean setCoeffs(int n, boolean bl) {
        boolean bl2 = false;
        this.map = this.dfCoefMaps[n];
        if (bl && this.thisAtom == null) {
            this.moCoeff += this.map.length;
            return false;
        }
        int n2 = 0;
        while (n2 < this.map.length) {
            if (this.map[n2] + this.moCoeff >= this.moCoefficients.length) {
                System.out.println("OHOH");
            }
            bl2 |= (this.coeffs[n2] = (double)this.moCoefficients[this.map[n2] + this.moCoeff++]) != 0.0;
            ++n2;
        }
        if ((bl2 &= this.coeffs[0] != -2.147483648E9) && this.doDebug && bl) {
            this.dumpInfo(n);
        }
        return bl2;
    }

    private void addDataS() {
        double d;
        boolean bl = false;
        switch (this.normType) {
            default: {
                d = 1.0;
                break;
            }
            case 1: {
                d = 0.7127054929733276;
                bl = true;
                break;
            }
            case 2: {
                d = this.getContractionNormalization(0, 1);
                bl = true;
            }
        }
        double d2 = this.coeffs[0];
        int n = 0;
        while (n < this.nGaussians) {
            double d3 = this.gaussians[this.gaussianPtr + n][0];
            double d4 = this.gaussians[this.gaussianPtr + n][1];
            double d5 = d * d2 * d4 * this.moFactor;
            if (bl) {
                d5 *= Math.pow(d3, 0.75);
            }
            int n2 = this.xMax;
            while (--n2 >= this.xMin) {
                this.EX[n2] = d5 * Math.exp((double)(-this.X2[n2]) * d3);
            }
            n2 = this.yMax;
            while (--n2 >= this.yMin) {
                this.EY[n2] = Math.exp((double)(-this.Y2[n2]) * d3);
            }
            n2 = this.zMax;
            while (--n2 >= this.zMin) {
                this.EZ[n2] = Math.exp((double)(-this.Z2[n2]) * d3);
            }
            n2 = this.xMax;
            while (--n2 >= this.xMin) {
                double d6 = this.EX[n2];
                if (this.havePoints) {
                    this.setMinMax(n2);
                }
                int n3 = this.yMax;
                while (--n3 >= this.yMin) {
                    double d7 = d6 * this.EY[n3];
                    float[] fArray = this.voxelDataTemp[n2][this.havePoints ? 0 : n3];
                    int n4 = this.zMax;
                    while (--n4 >= this.zMin) {
                        int n5 = this.havePoints ? 0 : n4;
                        fArray[n5] = (float)((double)fArray[n5] + d7 * this.EZ[n4]);
                    }
                }
            }
            ++n;
        }
    }

    private void addDataP() {
        double d;
        double d2 = this.coeffs[0];
        double d3 = this.coeffs[1];
        double d4 = this.coeffs[2];
        boolean bl = false;
        switch (this.normType) {
            default: {
                d = 1.0;
                break;
            }
            case 1: {
                d = 1.425411f;
                bl = true;
                break;
            }
            case 2: {
                d = this.getContractionNormalization(1, 1);
                bl = true;
            }
        }
        int n = 0;
        while (n < this.nGaussians) {
            double d5;
            double d6 = this.gaussians[this.gaussianPtr + n][0];
            double d7 = d5 = (double)this.gaussians[this.gaussianPtr + n][1];
            if (bl) {
                d7 *= Math.pow(d6, 1.25) * d;
            }
            this.calcSP(d6, 0.0, d7 * d2, d7 * d3, d7 * d4);
            ++n;
        }
    }

    private void addDataSP() {
        double d;
        double d2;
        boolean bl = this.map.length == 3;
        int n = bl ? 0 : 1;
        double d3 = bl ? 0.0 : this.coeffs[0];
        double d4 = this.coeffs[n++];
        double d5 = this.coeffs[n++];
        double d6 = this.coeffs[n++];
        boolean bl2 = false;
        switch (this.normType) {
            default: {
                d2 = 1.0;
                d = 1.0;
                break;
            }
            case 1: {
                d = 0.7127054929733276;
                d2 = 1.425411f;
                bl2 = true;
                break;
            }
            case 2: {
                d = this.getContractionNormalization(0, 1);
                d2 = this.getContractionNormalization(1, 2);
                bl2 = true;
            }
        }
        int n2 = 0;
        while (n2 < this.nGaussians) {
            double d7 = this.gaussians[this.gaussianPtr + n2][0];
            double d8 = this.gaussians[this.gaussianPtr + n2][1];
            double d9 = this.gaussians[this.gaussianPtr + n2][2];
            double d10 = d8;
            double d11 = d9;
            if (bl2) {
                d10 *= Math.pow(d7, 0.75) * d;
                d11 *= Math.pow(d7, 1.25) * d2;
            }
            this.calcSP(d7, d10 * d3, d11 * d4, d11 * d5, d11 * d6);
            ++n2;
        }
    }

    private void setCE(double d, double d2, double d3, double d4, double d5) {
        int n = this.xMax;
        while (--n >= this.xMin) {
            this.CX[n] = d2 + d3 * (double)this.X[n];
            this.EX[n] = Math.exp((double)(-this.X2[n]) * d) * this.moFactor;
        }
        n = this.yMax;
        while (--n >= this.yMin) {
            this.CY[n] = d4 * (double)this.Y[n];
            this.EY[n] = Math.exp((double)(-this.Y2[n]) * d);
        }
        n = this.zMax;
        while (--n >= this.zMin) {
            this.CZ[n] = d5 * (double)this.Z[n];
            this.EZ[n] = Math.exp((double)(-this.Z2[n]) * d);
        }
    }

    public void setE(double[] dArray, double d) {
        int n = this.xMax;
        while (--n >= this.xMin) {
            dArray[n] = Math.exp((double)(-this.X2[n]) * d) * this.moFactor;
        }
        n = this.yMax;
        while (--n >= this.yMin) {
            this.EY[n] = Math.exp((double)(-this.Y2[n]) * d);
        }
        n = this.zMax;
        while (--n >= this.zMin) {
            this.EZ[n] = Math.exp((double)(-this.Z2[n]) * d);
        }
    }

    private void calcSP(double d, double d2, double d3, double d4, double d5) {
        this.setCE(d, d2, d3, d4, d5);
        int n = this.xMax;
        while (--n >= this.xMin) {
            double d6 = this.EX[n];
            double d7 = this.CX[n];
            if (this.havePoints) {
                this.setMinMax(n);
            }
            int n2 = this.yMax;
            while (--n2 >= this.yMin) {
                double d8 = d6 * this.EY[n2];
                double d9 = d7 + this.CY[n2];
                float[] fArray = this.voxelDataTemp[n][this.havePoints ? 0 : n2];
                int n3 = this.zMax;
                while (--n3 >= this.zMin) {
                    int n4 = this.havePoints ? 0 : n3;
                    fArray[n4] = (float)((double)fArray[n4] + (d9 + this.CZ[n3]) * d8 * this.EZ[n3]);
                }
            }
        }
    }

    private void addData6D() {
        double d;
        double d2;
        double d3 = this.coeffs[0];
        double d4 = this.coeffs[1];
        double d5 = this.coeffs[2];
        double d6 = this.coeffs[3];
        double d7 = this.coeffs[4];
        double d8 = this.coeffs[5];
        boolean bl = false;
        switch (this.normType) {
            default: {
                d2 = 1.0;
                d = 0.5773502795520422;
                break;
            }
            case 1: {
                d2 = 2.850822f;
                d = d2 / 1.7320507764816284;
                bl = true;
                break;
            }
            case 2: {
                d2 = d = this.getContractionNormalization(2, 1);
                bl = true;
                break;
            }
            case 3: {
                d2 = 1.7320507764816284;
                d = 1.0;
            }
        }
        int n = 0;
        while (n < this.nGaussians) {
            double d9;
            double d10 = this.gaussians[this.gaussianPtr + n][0];
            double d11 = d9 = (double)this.gaussians[this.gaussianPtr + n][1];
            if (bl) {
                d11 *= Math.pow(d10, 1.75);
            }
            double d12 = d11 * d2 * d6;
            double d13 = d11 * d2 * d7;
            double d14 = d11 * d2 * d8;
            double d15 = d11 * d * d3;
            double d16 = d11 * d * d4;
            double d17 = d11 * d * d5;
            this.setCE(d10, 0.0, d15, d16, d17);
            int n2 = this.xMax;
            while (--n2 >= this.xMin) {
                this.DXY[n2] = d12 * (double)this.X[n2];
                this.DXZ[n2] = d13 * (double)this.X[n2];
            }
            n2 = this.yMax;
            while (--n2 >= this.yMin) {
                this.DYZ[n2] = d14 * (double)this.Y[n2];
            }
            n2 = this.xMax;
            while (--n2 >= this.xMin) {
                double d18 = this.CX[n2] * (double)this.X[n2];
                double d19 = this.DXY[n2];
                double d20 = this.DXZ[n2];
                double d21 = this.EX[n2];
                if (this.havePoints) {
                    this.setMinMax(n2);
                }
                int n3 = this.yMax;
                while (--n3 >= this.yMin) {
                    double d22 = d18 + (this.CY[n3] + d19) * (double)this.Y[n3];
                    double d23 = d20 + this.DYZ[n3];
                    double d24 = d21 * this.EY[n3];
                    float[] fArray = this.voxelDataTemp[n2][this.havePoints ? 0 : n3];
                    int n4 = this.zMax;
                    while (--n4 >= this.zMin) {
                        int n5 = this.havePoints ? 0 : n4;
                        fArray[n5] = (float)((double)fArray[n5] + (d22 + (this.CZ[n4] + d23) * (double)this.Z[n4]) * d24 * this.EZ[n4]);
                    }
                }
            }
            ++n;
        }
    }

    private void addData5D() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        boolean bl = false;
        switch (this.normType) {
            default: {
                d5 = 1.0;
                d4 = 1.0;
                d3 = 1.0;
                d2 = 1.0;
                d = 1.0;
                break;
            }
            case 3: {
                d4 = 1.0;
                d2 = 1.0;
                d = 3.464101552963257;
                d3 = 1.7320507764816284;
                d5 = 2.0;
                break;
            }
            case 1: {
                d = Math.pow(66.05114251919257, 0.25);
                d2 = d / 1.7320507764816284;
                d3 = 0.8660253882408142;
                d5 = 1.0;
                d4 = 1.0;
                bl = true;
                break;
            }
            case 2: {
                d2 = this.getContractionNormalization(2, 1);
                d = d2 * 1.7320507764816284;
                d3 = 0.8660253882408142;
                d4 = -1.0;
                d5 = 1.0;
                bl = true;
            }
        }
        double d6 = this.coeffs[0];
        double d7 = this.coeffs[1];
        double d8 = this.coeffs[2];
        double d9 = this.coeffs[3];
        double d10 = this.coeffs[4];
        int n = 0;
        while (n < this.nGaussians) {
            double d11;
            double d12 = this.gaussians[this.gaussianPtr + n][0];
            double d13 = d11 = (double)this.gaussians[this.gaussianPtr + n][1];
            if (bl) {
                d13 *= Math.pow(d12, 1.75);
            }
            double d14 = d13 * d6;
            double d15 = d4 * d13 * d7;
            double d16 = d13 * d8;
            double d17 = d13 * d9;
            double d18 = d13 * d10;
            this.setE(this.EX, d12);
            int n2 = this.xMax;
            while (--n2 >= this.xMin) {
                double d19 = this.X[n2];
                double d20 = this.EX[n2];
                double d21 = d2 * d19 * d19;
                if (this.havePoints) {
                    this.setMinMax(n2);
                }
                int n3 = this.yMax;
                while (--n3 >= this.yMin) {
                    double d22 = this.Y[n3];
                    double d23 = d20 * this.EY[n3];
                    double d24 = d2 * d22 * d22;
                    double d25 = d * d19 * d22;
                    float[] fArray = this.voxelDataTemp[n2][this.havePoints ? 0 : n3];
                    int n4 = this.zMax;
                    while (--n4 >= this.zMin) {
                        double d26 = this.Z[n4];
                        double d27 = d2 * d26 * d26;
                        double d28 = d * d19 * d26;
                        double d29 = d * d22 * d26;
                        int n5 = this.havePoints ? 0 : n4;
                        fArray[n5] = (float)((double)fArray[n5] + (d14 * d5 * (d27 - 0.5 * (d21 + d24)) + d15 * d28 + d16 * d29 + d17 * d3 * (d21 - d24) + d18 * d25) * d23 * this.EZ[n4]);
                    }
                }
            }
            ++n;
        }
    }

    private boolean processSlater(int n) {
        double d;
        int n2 = this.atomIndex;
        SlaterData slaterData = this.slaters[n];
        this.atomIndex = slaterData.atomNo - 1;
        double d2 = -slaterData.zeta;
        this.thisAtom = this.qmAtoms[this.atomIndex];
        if (this.thisAtom == null) {
            if (d2 <= 0.0) {
                ++this.moCoeff;
            }
            return true;
        }
        if (d2 > 0.0) {
            d2 = -d2;
            --this.moCoeff;
        }
        if (this.moCoeff >= this.moCoefficients.length) {
            return false;
        }
        if ((d = slaterData.coef * (double)this.moCoefficients[this.moCoeff++]) == 0.0) {
            this.atomIndex = -1;
            return true;
        }
        d *= this.moFactor;
        if (this.atomIndex != n2) {
            this.thisAtom.setXYZ(this, true);
        }
        int n3 = slaterData.x;
        int n4 = slaterData.y;
        int n5 = slaterData.z;
        int n6 = slaterData.r;
        if (n3 == -2) {
            int n7 = this.xMax;
            while (--n7 >= this.xMin) {
                double d3 = this.X2[n7];
                if (this.havePoints) {
                    this.setMinMax(n7);
                }
                int n8 = this.yMax;
                while (--n8 >= this.yMin) {
                    double d4 = this.Y2[n8];
                    double d5 = d3 + d4;
                    float[] fArray = this.voxelDataTemp[n7][this.havePoints ? 0 : n8];
                    int n9 = this.zMax;
                    while (--n9 >= this.zMin) {
                        double d6 = this.Z2[n9];
                        double d7 = d5 + d6;
                        double d8 = Math.sqrt(d7);
                        double d9 = d2 * d8;
                        if (d9 < -50.0) continue;
                        double d10 = d * Math.exp(d9) * (3.0 * d6 - d7);
                        switch (n6) {
                            case 3: {
                                d10 *= d8;
                            }
                            case 2: {
                                d10 *= d7;
                                break;
                            }
                            case 1: {
                                d10 *= d8;
                            }
                        }
                        int n10 = this.havePoints ? 0 : n9;
                        fArray[n10] = (float)((double)fArray[n10] + d10);
                    }
                }
            }
        } else if (n4 == -2) {
            int n11 = this.xMax;
            while (--n11 >= this.xMin) {
                double d11 = this.X2[n11];
                if (this.havePoints) {
                    this.setMinMax(n11);
                }
                int n12 = this.yMax;
                while (--n12 >= this.yMin) {
                    double d12 = this.Y2[n12];
                    double d13 = d11 + d12;
                    double d14 = d * (d11 - d12);
                    float[] fArray = this.voxelDataTemp[n11][this.havePoints ? 0 : n12];
                    int n13 = this.zMax;
                    while (--n13 >= this.zMin) {
                        double d15 = this.Z2[n13];
                        double d16 = d13 + d15;
                        double d17 = Math.sqrt(d16);
                        double d18 = d2 * d17;
                        if (d18 < -50.0) continue;
                        double d19 = d14 * Math.exp(d18);
                        switch (n6) {
                            case 3: {
                                d19 *= d17;
                            }
                            case 2: {
                                d19 *= d16;
                                break;
                            }
                            case 1: {
                                d19 *= d17;
                            }
                        }
                        int n14 = this.havePoints ? 0 : n13;
                        fArray[n14] = (float)((double)fArray[n14] + d19);
                    }
                }
            }
        } else {
            int n15 = this.xMax;
            while (--n15 >= this.xMin) {
                double d20 = this.X2[n15];
                double d21 = d;
                switch (n3) {
                    case 3: {
                        d21 *= (double)this.X[n15];
                    }
                    case 2: {
                        d21 *= d20;
                        break;
                    }
                    case 1: {
                        d21 *= (double)this.X[n15];
                    }
                }
                if (this.havePoints) {
                    this.setMinMax(n15);
                }
                int n16 = this.yMax;
                while (--n16 >= this.yMin) {
                    double d22 = this.Y2[n16];
                    double d23 = d20 + d22;
                    double d24 = d21;
                    switch (n4) {
                        case 3: {
                            d24 *= (double)this.Y[n16];
                        }
                        case 2: {
                            d24 *= d22;
                            break;
                        }
                        case 1: {
                            d24 *= (double)this.Y[n16];
                        }
                    }
                    float[] fArray = this.voxelDataTemp[n15][this.havePoints ? 0 : n16];
                    int n17 = this.zMax;
                    while (--n17 >= this.zMin) {
                        double d25 = this.Z2[n17];
                        double d26 = d23 + d25;
                        double d27 = Math.sqrt(d26);
                        double d28 = d2 * d27;
                        if (d28 < -50.0) continue;
                        double d29 = d24 * Math.exp(d28);
                        switch (n5) {
                            case 3: {
                                d29 *= (double)this.Z[n17];
                            }
                            case 2: {
                                d29 *= d25;
                                break;
                            }
                            case 1: {
                                d29 *= (double)this.Z[n17];
                            }
                        }
                        switch (n6) {
                            case 3: {
                                d29 *= d27;
                            }
                            case 2: {
                                d29 *= d26;
                                break;
                            }
                            case 1: {
                                d29 *= d27;
                            }
                        }
                        int n18 = this.havePoints ? 0 : n17;
                        fArray[n18] = (float)((double)fArray[n18] + d29);
                    }
                }
            }
        }
        return true;
    }

    private void dumpInfo(int n) {
        double d;
        if (this.doShowShellType) {
            Logger.debug("\n\t\t\tprocessShell: " + n + " type=" + QS.getQuantumShellTag(n) + " nGaussians=" + this.nGaussians + " atom=" + this.atomIndex);
            this.doShowShellType = false;
        }
        if (Logger.isActiveLevel(6) && this.gaussianPtr != this.lastGaussianPtr) {
            this.lastGaussianPtr = this.gaussianPtr;
            int n2 = 0;
            while (n2 < this.nGaussians) {
                double d2 = this.gaussians[this.gaussianPtr + n2][0];
                d = this.gaussians[this.gaussianPtr + n2][1];
                Logger.debug("\t\t\tGaussian " + (n2 + 1) + " alpha=" + d2 + " c=" + d);
                ++n2;
            }
        }
        String[] stringArray = MOCalculation.getShellOrder(n);
        int n3 = 0;
        while (n3 < this.map.length) {
            int n4 = this.map[n3] + this.moCoeff - this.map.length + n3 + 1;
            d = this.coeffs[n3];
            Logger.debug("MO coeff " + (stringArray == null ? "?" : stringArray[n3]) + " " + n4 + "\t" + d + "\t" + this.thisAtom.atom);
            ++n3;
        }
    }

    private static final String[] getShellOrder(int n) {
        return n < 0 || n >= shellOrder.length ? null : shellOrder[n];
    }

    public void calculateElectronDensity() {
        if (this.points != null) {
            return;
        }
        this.integration = 0.0f;
        int n = this.nX;
        while (--n >= 0) {
            int n2 = this.nY;
            while (--n2 >= 0) {
                int n3 = this.nZ;
                while (--n3 >= 0) {
                    float f = this.voxelData[n][n2][n3];
                    this.integration += f * f;
                }
            }
        }
        float f = this.stepBohr[0] * this.stepBohr[1] * this.stepBohr[2];
        this.integration *= f;
        Logger.info("Integrated density = " + this.integration);
    }
}

