/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Map;
import javajs.util.PT;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.SimpleUnitCell;

class SymmetryInfo {
    boolean coordinatesAreFractional;
    boolean isMultiCell;
    String sgName;
    SymmetryOperation[] symmetryOperations;
    String infoStr;
    int[] cellRange;
    String latticeType = "P";
    public String intlTableNo;

    SymmetryInfo() {
    }

    float[] setSymmetryInfo(Map<String, Object> map, float[] fArray) {
        this.cellRange = (int[])map.get("unitCellRange");
        this.sgName = (String)map.get("spaceGroup");
        if (this.sgName == null || this.sgName == "") {
            this.sgName = "spacegroup unspecified";
        }
        this.infoStr = "Spacegroup: " + this.sgName;
        this.latticeType = (String)map.get("latticeType");
        if (this.latticeType == null) {
            this.latticeType = "P";
        }
        this.intlTableNo = (String)map.get("intlTableNo");
        int n = map.containsKey("symmetryCount") ? (Integer)map.get("symmetryCount") : 0;
        this.symmetryOperations = (SymmetryOperation[])map.remove("symmetryOps");
        if (this.symmetryOperations != null) {
            String string = "";
            String string2 = "\nNumber of symmetry operations: " + (n == 0 ? 1 : n) + "\nSymmetry Operations:";
            int n2 = 0;
            while (n2 < n) {
                SymmetryOperation symmetryOperation = this.symmetryOperations[n2];
                string2 = String.valueOf(string2) + "\n" + symmetryOperation.fixMagneticXYZ(symmetryOperation, symmetryOperation.xyz, true);
                if (symmetryOperation.isCenteringOp) {
                    string = String.valueOf(string) + " (" + PT.rep(PT.replaceAllCharacters(symmetryOperation.xyz, "xyz", "0"), "0+", "") + ")";
                }
                ++n2;
            }
            if (string.length() > 0) {
                this.infoStr = String.valueOf(this.infoStr) + "\nCentering: " + string;
            }
            this.infoStr = String.valueOf(this.infoStr) + string2;
            this.infoStr = String.valueOf(this.infoStr) + "\n";
        }
        if (fArray == null) {
            fArray = (float[])map.get("unitCellParams");
        }
        if (!SimpleUnitCell.isValid(fArray)) {
            return null;
        }
        this.coordinatesAreFractional = map.containsKey("coordinatesAreFractional") ? (Boolean)map.get("coordinatesAreFractional") : false;
        this.isMultiCell = this.coordinatesAreFractional && this.symmetryOperations != null;
        return fArray;
    }
}

