/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;

public class DownloadIncompleteMembersAction
extends AbstractRelationEditorAction {
    private static final long serialVersionUID = 1L;

    public DownloadIncompleteMembersAction(IRelationEditorActionAccess editorAccess, String actionMapKey) {
        super(editorAccess, actionMapKey, IRelationEditorUpdateOn.MEMBER_TABLE_CHANGE);
        Shortcut sc = Shortcut.registerShortcut("relationeditor:downloadincomplete", I18n.tr("Relation Editor: Download Members", new Object[0]), 36, 5004);
        sc.setAccelerator(this);
        this.putValue("ShortDescription", PlatformManager.getPlatform().makeTooltip(I18n.tr("Download all incomplete members", new Object[0]), sc));
        new ImageProvider("dialogs/relation", "downloadincomplete").getResource().attachImageIcon(this, true);
        this.putValue("Name", I18n.tr("Download members", new Object[0]));
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        MainApplication.worker.submit(new DownloadRelationMemberTask(this.getEditor().getRelation(), this.getMemberTableModel().getIncompleteMemberPrimitives(), this.getLayer(), (Dialog)((Object)this.getEditor())));
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getMemberTableModel().hasIncompleteMembers() && this.canDownload());
    }
}

