/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import java.util.Optional;
import javax.swing.JComponent;
import org.protege.editor.core.ProtegeProperties;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.workspace.WorkspaceViewsTab;
import org.protege.editor.core.util.HandlerRegistration;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLEntityDisplayProvider;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.selection.SelectionDriver;
import org.protege.editor.owl.model.selection.SelectionPlane;
import org.protege.editor.owl.model.selection.SelectionPlaneImpl;
import org.protege.editor.owl.ui.view.AbstractOWLSelectionViewComponent;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class OWLWorkspaceViewsTab
extends WorkspaceViewsTab
implements SelectionPlane {
    private Optional<JComponent> lastEntityDisplayCandidate = Optional.empty();
    private OWLEntityDisplayProvider provider = new OWLEntityDisplayProvider(){

        @Override
        public boolean canDisplay(OWLEntity owlEntity) {
            return OWLWorkspaceViewsTab.this.canDisplay(owlEntity);
        }

        @Override
        public JComponent getDisplayComponent() {
            return (JComponent)((Object)OWLWorkspaceViewsTab.this.lastEntityDisplayCandidate.orElse(OWLWorkspaceViewsTab.this));
        }
    };
    private SelectionPlane selectionPlaneDelegate;

    private boolean canDisplay(OWLEntity owlEntity) {
        String entityCat = new NavFinder().getNav(owlEntity);
        for (View view : this.getViewsPane().getViews()) {
            ViewComponent vc = view.getViewComponent();
            if (vc != null) {
                AbstractOWLSelectionViewComponent owlEntityViewComponent;
                if (!(vc instanceof AbstractOWLSelectionViewComponent) || !(vc instanceof SelectionDriver) || !(owlEntityViewComponent = (AbstractOWLSelectionViewComponent)vc).canShowEntity(owlEntity)) continue;
                this.lastEntityDisplayCandidate = Optional.of(view);
                return true;
            }
            ViewComponentPlugin plugin = this.getWorkspace().getViewManager().getViewComponentPlugin(view.getId());
            if (plugin == null) continue;
            for (String nav : plugin.getNavigates()) {
                if (!entityCat.equals(nav)) continue;
                this.lastEntityDisplayCandidate = Optional.of(view);
                return true;
            }
        }
        return false;
    }

    public void initialise() {
        super.initialise();
        this.selectionPlaneDelegate = new SelectionPlaneImpl(this.getOWLEditorKit().getOWLWorkspace().getOWLSelectionModel());
        this.getOWLEditorKit().getWorkspace().registerOWLEntityDisplayProvider(this.provider);
    }

    public void dispose() {
        this.getOWLEditorKit().getWorkspace().unregisterOWLEntityDisplayProvider(this.provider);
        super.dispose();
    }

    @Override
    public HandlerRegistration registerSelectionDriver(SelectionDriver driver) {
        return this.selectionPlaneDelegate.registerSelectionDriver(driver);
    }

    @Override
    public void transmitSelection(SelectionDriver driver, OWLObject selection) {
        this.selectionPlaneDelegate.transmitSelection(driver, selection);
    }

    public OWLModelManager getOWLModelManager() {
        return (OWLModelManager)this.getWorkspace().getEditorKit().getModelManager();
    }

    public OWLEditorKit getOWLEditorKit() {
        return (OWLEditorKit)this.getWorkspace().getEditorKit();
    }

    class NavFinder
    implements OWLEntityVisitor {
        private String nav;

        NavFinder() {
        }

        public String getNav(OWLEntity owlEntity) {
            this.nav = null;
            owlEntity.accept((OWLEntityVisitor)this);
            return this.nav;
        }

        public void visit(OWLClass owlClass) {
            this.nav = ProtegeProperties.getInstance().getProperty("org.protege.classcategory");
        }

        public void visit(OWLObjectProperty owlObjectProperty) {
            this.nav = ProtegeProperties.getInstance().getProperty("org.protege.objectpropertycategory");
        }

        public void visit(OWLDataProperty owlDataProperty) {
            this.nav = ProtegeProperties.getInstance().getProperty("org.protege.datapropertycategory");
        }

        public void visit(OWLAnnotationProperty owlAnnotationProperty) {
            this.nav = ProtegeProperties.getInstance().getProperty("org.protege.annotationpropertycategory");
        }

        public void visit(OWLNamedIndividual owlIndividual) {
            this.nav = ProtegeProperties.getInstance().getProperty("org.protege.individualcategory");
        }

        public void visit(OWLDatatype owlDatatype) {
            this.nav = ProtegeProperties.getInstance().getProperty("org.protege.datatypecategory");
        }
    }
}

