/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.AbstractArtifact;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public final class DefaultArtifact
extends AbstractArtifact {
    private Date publicationDate;
    private ArtifactRevisionId arid;
    private URL url;
    private boolean isMetadata = false;

    public static Artifact newIvyArtifact(ModuleRevisionId moduleRevisionId, Date date) {
        return new DefaultArtifact(moduleRevisionId, date, "ivy", "ivy", "xml", 0);
    }

    public static Artifact newPomArtifact(ModuleRevisionId moduleRevisionId, Date date) {
        return new DefaultArtifact(moduleRevisionId, date, moduleRevisionId.getName(), "pom", "pom", 0);
    }

    public DefaultArtifact(ModuleRevisionId moduleRevisionId, Date date, String string, String string2, String string3) {
        this(moduleRevisionId, date, string, string2, string3, null, null);
    }

    public DefaultArtifact(ModuleRevisionId moduleRevisionId, Date date, String string, String string2, String string3, byte by) {
        this(moduleRevisionId, date, string, string2, string3, null, null);
        this.isMetadata = true;
    }

    public DefaultArtifact(ModuleRevisionId moduleRevisionId, Date date, String string, String string2, String string3, Map map2) {
        this(moduleRevisionId, date, string, string2, string3, null, map2);
    }

    public DefaultArtifact(ModuleRevisionId moduleRevisionId, Date date, String string, String string2, String string3, URL uRL, Map map2) {
        this(ArtifactRevisionId.newInstance(moduleRevisionId, string, string2, string3, map2), date, uRL, false);
    }

    public DefaultArtifact(ArtifactRevisionId artifactRevisionId, Date date, URL uRL, boolean bl) {
        if (artifactRevisionId == null) {
            throw new NullPointerException("null arid not allowed");
        }
        if (date == null) {
            date = new Date();
        }
        this.publicationDate = date;
        this.arid = artifactRevisionId;
        this.url = uRL;
        this.isMetadata = bl;
    }

    @Override
    public final ModuleRevisionId getModuleRevisionId() {
        return this.arid.getModuleRevisionId();
    }

    @Override
    public final String getName() {
        return this.arid.getName();
    }

    @Override
    public final Date getPublicationDate() {
        return this.publicationDate;
    }

    @Override
    public final String getType() {
        return this.arid.getType();
    }

    @Override
    public final String getExt() {
        return this.arid.getExt();
    }

    @Override
    public final ArtifactRevisionId getId() {
        return this.arid;
    }

    @Override
    public final URL getUrl() {
        return this.url;
    }

    @Override
    public final boolean isMetadata() {
        return this.isMetadata;
    }
}

