/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.util.Date;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.CacheDownloadOptions;
import org.apache.ivy.core.cache.CacheMetadataOptions;
import org.apache.ivy.core.cache.DownloadListener;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.settings.Validatable;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.resolver.AbstractResolver$1;
import org.apache.ivy.plugins.resolver.AbstractResolver$ResolverParserSettings;
import org.apache.ivy.plugins.resolver.ChainResolver$ResolvedModuleRevisionArtifactInfo;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.util.HasLatestStrategy;
import org.apache.ivy.util.Message;

public abstract class AbstractResolver
implements Validatable,
DependencyResolver,
HasLatestStrategy {
    private String name;
    private ResolverSettings settings;
    private EventManager eventManager = null;
    private LatestStrategy latestStrategy;
    private String latestStrategyName;
    private Namespace namespace;
    private RepositoryCacheManager repositoryCacheManager;
    private String changingMatcherName;
    private String changingPattern;

    public final ResolverSettings getSettings() {
        return this.settings;
    }

    public final ParserSettings getParserSettings() {
        return new AbstractResolver$ResolverParserSettings(this, 0);
    }

    @Override
    public void setSettings(ResolverSettings resolverSettings) {
        this.settings = resolverSettings;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected static void checkInterrupted() {
        IvyContext.getContext().getIvy().checkInterrupted();
    }

    @Override
    public void reportFailure() {
        Message.verbose("no failure report implemented by " + this.name);
    }

    @Override
    public void reportFailure(Artifact artifact) {
        Message.verbose("no failure report implemented by " + this.name);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void dumpSettings() {
        Message.verbose("\t" + this.name + " [" + this.getTypeName() + "]");
        Message.debug("\t\tcache: " + null);
    }

    public String getTypeName() {
        return this.getClass().getName();
    }

    @Override
    public ArtifactOrigin locate(Artifact artifact) {
        DownloadReport downloadReport = this.download(new Artifact[]{artifact}, new DownloadOptions());
        if (downloadReport == null) {
            throw new IllegalStateException("null download report returned by " + this.name + " (" + this.getClass().getName() + ") when trying to download " + artifact);
        }
        ArtifactDownloadReport artifactDownloadReport = downloadReport.getArtifactReport(artifact);
        if (artifactDownloadReport.getDownloadStatus() == DownloadStatus.FAILED) {
            return null;
        }
        return artifactDownloadReport.getArtifactOrigin();
    }

    @Override
    public final LatestStrategy getLatestStrategy() {
        if (this.latestStrategy == null) {
            this.initLatestStrategyFromSettings();
        }
        return this.latestStrategy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initLatestStrategyFromSettings() {
        if (this.settings == null) throw new IllegalStateException("no ivy instance found: impossible to get a latest strategy without ivy instance");
        if (this.latestStrategyName != null && !"default".equals(this.latestStrategyName)) {
            this.latestStrategy = this.settings.getLatestStrategy(this.latestStrategyName);
            if (this.latestStrategy != null) return;
            throw new IllegalStateException("unknown latest strategy '" + this.latestStrategyName + "'");
        }
        this.latestStrategy = this.settings.getDefaultLatestStrategy();
        Message.debug(this.name + ": no latest strategy defined: using default");
    }

    @Override
    public final void setLatestStrategy(LatestStrategy latestStrategy) {
        this.latestStrategy = latestStrategy;
    }

    @Override
    public final String getLatest() {
        if (this.latestStrategyName == null) {
            this.latestStrategyName = "default";
        }
        return this.latestStrategyName;
    }

    public final Namespace getNamespace() {
        if (this.namespace == null) {
            this.initNamespaceFromSettings();
        }
        return this.namespace;
    }

    private void initNamespaceFromSettings() {
        if (this.settings != null) {
            this.namespace = this.settings.getSystemNamespace();
            Message.debug(this.name + ": no namespace defined: using system");
            return;
        }
        Message.verbose(this.name + ": no namespace defined nor ivy instance: using system namespace");
        this.namespace = Namespace.SYSTEM_NAMESPACE;
    }

    protected final ModuleDescriptor toSystem(ModuleDescriptor moduleDescriptor) {
        Namespace namespace = this.getNamespace();
        return DefaultModuleDescriptor.transformInstance(moduleDescriptor, namespace);
    }

    protected final Artifact fromSystem(Artifact artifact) {
        return LogOptions.transform(artifact, this.getNamespace().getFromSystemTransformer());
    }

    protected final Artifact toSystem(Artifact artifact) {
        return LogOptions.transform(artifact, this.getNamespace().getToSystemTransformer());
    }

    protected final MetadataArtifactDownloadReport toSystem(MetadataArtifactDownloadReport metadataArtifactDownloadReport) {
        NamespaceTransformer namespaceTransformer = this.getNamespace().getToSystemTransformer();
        MetadataArtifactDownloadReport metadataArtifactDownloadReport2 = metadataArtifactDownloadReport;
        if (namespaceTransformer.isIdentity()) {
            return metadataArtifactDownloadReport2;
        }
        MetadataArtifactDownloadReport metadataArtifactDownloadReport3 = new MetadataArtifactDownloadReport(LogOptions.transform(metadataArtifactDownloadReport2.getArtifact(), namespaceTransformer));
        metadataArtifactDownloadReport3.setSearched(metadataArtifactDownloadReport2.isSearched());
        metadataArtifactDownloadReport3.setDownloadStatus(metadataArtifactDownloadReport2.getDownloadStatus());
        metadataArtifactDownloadReport3.setDownloadDetails(metadataArtifactDownloadReport2.getDownloadDetails());
        metadataArtifactDownloadReport3.setArtifactOrigin(metadataArtifactDownloadReport2.getArtifactOrigin());
        metadataArtifactDownloadReport3.setDownloadTimeMillis(metadataArtifactDownloadReport2.getDownloadTimeMillis());
        metadataArtifactDownloadReport3.setOriginalLocalFile(metadataArtifactDownloadReport2.getOriginalLocalFile());
        metadataArtifactDownloadReport3.setLocalFile(metadataArtifactDownloadReport2.getLocalFile());
        metadataArtifactDownloadReport3.setSize(metadataArtifactDownloadReport2.getSize());
        return metadataArtifactDownloadReport3;
    }

    protected final ModuleRevisionId toSystem(ModuleRevisionId moduleRevisionId) {
        return this.getNamespace().getToSystemTransformer().transform(moduleRevisionId);
    }

    protected final DependencyDescriptor fromSystem(DependencyDescriptor dependencyDescriptor) {
        NamespaceTransformer namespaceTransformer = this.getNamespace().getFromSystemTransformer();
        return DefaultDependencyDescriptor.transformInstance$7d2b9993(dependencyDescriptor, namespaceTransformer);
    }

    protected final DependencyDescriptor toSystem(DependencyDescriptor dependencyDescriptor) {
        NamespaceTransformer namespaceTransformer = this.getNamespace().getToSystemTransformer();
        return DefaultDependencyDescriptor.transformInstance$7d2b9993(dependencyDescriptor, namespaceTransformer);
    }

    protected final ResolvedModuleRevision findModuleInCache(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        return this.findModuleInCache(dependencyDescriptor, resolveData, false);
    }

    protected final ResolvedModuleRevision findModuleInCache(DependencyDescriptor dependencyDescriptor, ResolveData resolveData, boolean bl) {
        ResolvedModuleRevision resolvedModuleRevision = this.getRepositoryCacheManager().findModuleInCache(dependencyDescriptor, dependencyDescriptor.getDependencyRevisionId(), this.getCacheOptions(resolveData), bl ? null : this.name);
        if (resolvedModuleRevision == null) {
            return null;
        }
        if (resolveData.getReport() != null && resolveData.isBlacklisted(resolveData.getReport().getConfiguration(), resolvedModuleRevision.getId())) {
            Message.verbose("\t" + this.name + ": found revision in cache: " + resolvedModuleRevision.getId() + " for " + dependencyDescriptor + ", but it is blacklisted");
            return null;
        }
        return resolvedModuleRevision;
    }

    public final void setChangingMatcher(String string) {
        this.changingMatcherName = string;
    }

    public final void setChangingPattern(String string) {
        this.changingPattern = string;
    }

    @Override
    public final RepositoryCacheManager getRepositoryCacheManager() {
        if (this.repositoryCacheManager == null) {
            this.initRepositoryCacheManagerFromSettings();
        }
        return this.repositoryCacheManager;
    }

    private void initRepositoryCacheManagerFromSettings() {
        this.repositoryCacheManager = this.settings.getDefaultRepositoryCacheManager();
        if (this.repositoryCacheManager == null) {
            throw new IllegalStateException("no default cache manager defined with current settings");
        }
    }

    public final void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public final EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public final void validate() {
        this.initRepositoryCacheManagerFromSettings();
        this.initNamespaceFromSettings();
        this.initLatestStrategyFromSettings();
    }

    protected final CacheMetadataOptions getCacheOptions(ResolveData resolveData) {
        ResolveData resolveData2 = resolveData;
        ResolveOptions resolveOptions = resolveData.getOptions();
        return (CacheMetadataOptions)new CacheMetadataOptions().setChangingMatcherName(this.changingMatcherName).setChangingPattern(this.changingPattern).setCheckTTL(!resolveData.getOptions().isUseCacheOnly()).setCheckmodified(resolveData.getOptions().isUseCacheOnly() ? Boolean.FALSE : null).setValidate(resolveData2.isValidate()).setNamespace(this.getNamespace()).setUseCacheOnly(resolveData.getOptions().isUseCacheOnly()).setForce(resolveData.getOptions().isRefresh()).setListener(this.getDownloadListener((DownloadOptions)new DownloadOptions().setLog(resolveOptions.getLog())));
    }

    protected final CacheDownloadOptions getCacheDownloadOptions(DownloadOptions downloadOptions) {
        return new CacheDownloadOptions().setListener(this.getDownloadListener(downloadOptions));
    }

    private DownloadListener getDownloadListener(DownloadOptions downloadOptions) {
        return new AbstractResolver$1(this, downloadOptions);
    }

    protected final ResolvedModuleRevision checkLatest(DependencyDescriptor dependencyDescriptor, ResolvedModuleRevision resolvedModuleRevision, ResolveData resolveData) {
        LogOptions.checkNotNull(dependencyDescriptor, "dd");
        LogOptions.checkNotNull(resolveData, "data");
        ResolvedModuleRevision resolvedModuleRevision2 = resolveData.getCurrentResolvedModuleRevision();
        String string = AbstractResolver.describe(resolvedModuleRevision);
        Message.debug("\tchecking " + string + " against " + AbstractResolver.describe(resolvedModuleRevision2));
        if (resolvedModuleRevision2 == null) {
            Message.debug("\tmodule revision kept as first found: " + string);
            this.saveModuleRevisionIfNeeded(dependencyDescriptor, resolvedModuleRevision);
            return resolvedModuleRevision;
        }
        Date date = resolveData.getDate();
        ResolvedModuleRevision resolvedModuleRevision3 = resolvedModuleRevision2;
        ResolvedModuleRevision resolvedModuleRevision4 = resolvedModuleRevision;
        AbstractResolver abstractResolver = this;
        ArtifactInfo[] artifactInfoArray = new ArtifactInfo[]{new ChainResolver$ResolvedModuleRevisionArtifactInfo(resolvedModuleRevision4), new ChainResolver$ResolvedModuleRevisionArtifactInfo(resolvedModuleRevision3)};
        if (abstractResolver.getLatestStrategy().findLatest(artifactInfoArray, date) == artifactInfoArray[0]) {
            Message.debug("\tmodule revision kept as younger: " + string);
            this.saveModuleRevisionIfNeeded(dependencyDescriptor, resolvedModuleRevision);
            return resolvedModuleRevision;
        }
        if (!resolvedModuleRevision.getDescriptor().isDefault() && resolvedModuleRevision2.getDescriptor().isDefault()) {
            Message.debug("\tmodule revision kept as better (not default): " + string);
            this.saveModuleRevisionIfNeeded(dependencyDescriptor, resolvedModuleRevision);
            return resolvedModuleRevision;
        }
        Message.debug("\tmodule revision discarded as older: " + string);
        return resolvedModuleRevision2;
    }

    private void saveModuleRevisionIfNeeded(DependencyDescriptor dependencyDescriptor, ResolvedModuleRevision resolvedModuleRevision) {
        if (resolvedModuleRevision != null && this.settings.getVersionMatcher().isDynamic(dependencyDescriptor.getDependencyRevisionId())) {
            this.getRepositoryCacheManager().saveResolvedRevision(dependencyDescriptor.getDependencyRevisionId(), resolvedModuleRevision.getId().getRevision());
        }
    }

    private static String describe(ResolvedModuleRevision resolvedModuleRevision) {
        if (resolvedModuleRevision == null) {
            return "[none]";
        }
        return resolvedModuleRevision.getId() + (resolvedModuleRevision.getDescriptor().isDefault() ? "[default]" : "") + " from " + resolvedModuleRevision.getResolver().getName();
    }

    static /* synthetic */ EventManager access$100(AbstractResolver abstractResolver) {
        return abstractResolver.eventManager;
    }
}

