/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;

public class MailingList
implements Serializable,
Cloneable,
InputLocationTracker {
    private String name;
    private String subscribe;
    private String unsubscribe;
    private String post;
    private String archive;
    private List<String> otherArchives;
    private Map<Object, InputLocation> locations;

    public void addOtherArchive(String string2) {
        this.getOtherArchives().add(string2);
    }

    public MailingList clone() {
        try {
            MailingList copy2 = (MailingList)super.clone();
            if (this.otherArchives != null) {
                copy2.otherArchives = new ArrayList<String>();
                copy2.otherArchives.addAll(this.otherArchives);
            }
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getArchive() {
        return this.archive;
    }

    @Override
    public InputLocation getLocation(Object key2) {
        return this.locations != null ? this.locations.get(key2) : null;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getOtherArchives() {
        if (this.otherArchives == null) {
            this.otherArchives = new ArrayList<String>();
        }
        return this.otherArchives;
    }

    public String getPost() {
        return this.post;
    }

    public String getSubscribe() {
        return this.subscribe;
    }

    public String getUnsubscribe() {
        return this.unsubscribe;
    }

    public void removeOtherArchive(String string2) {
        this.getOtherArchives().remove(string2);
    }

    public void setArchive(String archive) {
        this.archive = archive;
    }

    @Override
    public void setLocation(Object key2, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key2, location);
        }
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public void setOtherArchives(List<String> otherArchives) {
        this.otherArchives = otherArchives;
    }

    public void setPost(String post) {
        this.post = post;
    }

    public void setSubscribe(String subscribe) {
        this.subscribe = subscribe;
    }

    public void setUnsubscribe(String unsubscribe) {
        this.unsubscribe = unsubscribe;
    }
}

