#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: vector-binary-instances
version: 0.2.5.1
id: vector-binary-instances-0.2.5.1-IQaUNlPskFJ1IdtNmjl3KM
key: vector-binary-instances-0.2.5.1-IQaUNlPskFJ1IdtNmjl3KM
license: BSD-3-Clause
maintainer: dons00@gmail.com, bos@serpentine.com, Ben Gamari <ben@smart-cactus.org>
author: Don Stewart
stability: Experimental
homepage: https://github.com/bos/vector-binary-instances
synopsis: Instances of Data.Binary for vector
description:
    Instances for Binary for the types defined in the vector package,
    making it easy to serialize vectors to and from disk. We use the
    generic interface to vectors, so all vector types are supported.
    Specific instances are provided for unboxed, boxed and storable
    vectors.
    .
    To serialize a vector:
    .
    > *Data.Vector.Binary> let v = Data.Vector.fromList [1..10]
    > *Data.Vector.Binary> v
    > fromList [1,2,3,4,5,6,7,8,9,10] :: Data.Vector.Vector
    > *Data.Vector.Binary> encode v
    > Chunk "\NUL\NUL\NUL\NUL\NUL...\NUL\NUL\NUL\t\NUL\NUL\NUL\NUL\n" Empty
    .
    Which you can in turn compress before writing to disk:
    .
    > compress . encode $ v
    > Chunk "\US\139\b\NUL\NUL\N...\229\240,\254:\NUL\NUL\NUL" Empty
    .
    Try the cereal-vector package if you are looking for Data.Serialize
    instances.
category: Data
abi: 72f7eb942c24373c3f2fc32662f8fd6d
exposed: True
exposed-modules:
    Data.Vector.Binary
import-dirs: /usr/lib/ghc-8.6.1/site-local/vector-binary-instances-0.2.5.1
library-dirs: /usr/lib/ghc-8.6.1/site-local/vector-binary-instances-0.2.5.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.6.1/vector-binary-instances-0.2.5.1
hs-libraries: HSvector-binary-instances-0.2.5.1-IQaUNlPskFJ1IdtNmjl3KM
depends:
    base-4.12.0.0 binary-0.8.6.0 vector-0.12.0.1-BKWaeB2IPwRDyZEP11mv5m
haddock-interfaces: /usr/share/doc/haskell-vector-binary-instances/html/vector-binary-instances.haddock
haddock-html: /usr/share/doc/haskell-vector-binary-instances/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

