/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGrid.PropertySetDescriptor;
import com.zeroc.IceGridGUI.Application.Editable;
import com.zeroc.IceGridGUI.Application.ListTreeNode;
import com.zeroc.IceGridGUI.Application.PropertySet;
import com.zeroc.IceGridGUI.Application.PropertySetParent;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.ApplicationActions;
import com.zeroc.IceGridGUI.TreeNodeBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JPopupMenu;

class PropertySets
extends ListTreeNode
implements PropertySetParent {
    private Map<String, PropertySetDescriptor> _descriptors;
    private static JPopupMenu _popup;

    public static Map<String, PropertySetDescriptor> copyDescriptors(Map<String, PropertySetDescriptor> descriptors) {
        HashMap<String, PropertySetDescriptor> copy = new HashMap<String, PropertySetDescriptor>();
        for (Map.Entry<String, PropertySetDescriptor> p : descriptors.entrySet()) {
            copy.put(p.getKey(), PropertySet.copyDescriptor(p.getValue()));
        }
        return copy;
    }

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        Object descriptor = this.getCoordinator().getClipboard();
        if (descriptor != null) {
            actions[14] = descriptor instanceof PropertySetDescriptor;
        }
        actions[3] = true;
        return actions;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(3));
        }
        actions.setTarget(this);
        return _popup;
    }

    @Override
    public void newPropertySet() {
        PropertySetDescriptor descriptor = new PropertySetDescriptor(new String[0], new LinkedList());
        this.newPropertySet(descriptor);
    }

    @Override
    public void paste() {
        Object descriptor = this.getCoordinator().getClipboard();
        PropertySetDescriptor d = PropertySet.copyDescriptor((PropertySetDescriptor)descriptor);
        this.newPropertySet(d);
    }

    PropertySets(TreeNode parent, Map<String, PropertySetDescriptor> desc) throws UpdateFailedException {
        super(false, parent, "Property Sets");
        this._descriptors = desc;
        for (Map.Entry<String, PropertySetDescriptor> p : this._descriptors.entrySet()) {
            String id = p.getKey();
            this.insertChild(new PropertySet(false, this, id, id, p.getValue()), false);
        }
    }

    void update(Map<String, PropertySetDescriptor> updates, String[] removePropertySets) throws UpdateFailedException {
        this.removeChildren(removePropertySets);
        ArrayList<PropertySet> newChildren = new ArrayList<PropertySet>();
        for (Map.Entry<String, PropertySetDescriptor> p : updates.entrySet()) {
            String id = p.getKey();
            PropertySetDescriptor psd = p.getValue();
            PropertySet child = (PropertySet)this.findChild(id);
            if (child == null) {
                newChildren.add(new PropertySet(false, this, id, id, psd));
                continue;
            }
            child.rebuild(psd);
        }
        this.insertChildren(newChildren, true);
    }

    Map<String, PropertySetDescriptor> getUpdates() {
        HashMap<String, PropertySetDescriptor> updates = new HashMap<String, PropertySetDescriptor>();
        for (TreeNodeBase p : this._children) {
            PropertySet ps = (PropertySet)p;
            if (!ps.getEditable().isNew() && !ps.getEditable().isModified()) continue;
            updates.put(ps.getId(), (PropertySetDescriptor)ps.getDescriptor());
        }
        return updates;
    }

    void commit() {
        this._editable.commit();
        for (TreeNodeBase p : this._children) {
            PropertySet ps = (PropertySet)p;
            ps.commit();
        }
    }

    @Override
    Object getDescriptor() {
        return this._descriptors;
    }

    @Override
    public void tryAdd(String id, PropertySetDescriptor descriptor) throws UpdateFailedException {
        this.insertChild(new PropertySet(true, this, id, id, descriptor), true);
        this._descriptors.put(id, descriptor);
    }

    @Override
    public void tryRename(String oldId, String oldId2, String newId) throws UpdateFailedException {
        PropertySet oldChild = (PropertySet)this.findChild(oldId);
        assert (oldChild != null);
        this.removeChild(oldChild);
        PropertySetDescriptor descriptor = (PropertySetDescriptor)oldChild.getDescriptor();
        try {
            this.insertChild(new PropertySet(true, this, newId, newId, descriptor), true);
        }
        catch (UpdateFailedException ex) {
            block5: {
                try {
                    this.insertChild(oldChild, true);
                }
                catch (UpdateFailedException ufe) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            throw ex;
        }
        this._editable.removeElement(oldId, oldChild.getEditable(), PropertySet.class);
        this._descriptors.remove(oldId);
        this._descriptors.put(newId, descriptor);
    }

    @Override
    public void insertPropertySet(PropertySet nps, boolean fireEvent) throws UpdateFailedException {
        this.insertChild(nps, fireEvent);
    }

    @Override
    public void removePropertySet(PropertySet nps) {
        this.removeChild(nps);
    }

    @Override
    public void removeDescriptor(String id) {
        this._descriptors.remove(id);
    }

    @Override
    public Editable getEditable() {
        return super.getEditable();
    }

    private void newPropertySet(PropertySetDescriptor descriptor) {
        PropertySet propertySet;
        block2: {
            String id = this.makeNewChildId("PropertySet");
            propertySet = new PropertySet(this, id, descriptor);
            try {
                this.insertChild(propertySet, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(propertySet);
    }
}

