/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.zeroc.Ice.LocalException;
import com.zeroc.IceGridGUI.Coordinator;
import com.zeroc.IceGridGUI.LiveDeployment.MetricsFieldContext;
import com.zeroc.IceGridGUI.LiveDeployment.MetricsViewEditor;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceMX.Metrics;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.TransferMode;
import javafx.util.StringConverter;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class GraphView
extends JFrame
implements MetricsFieldContext,
Coordinator.IGraphView {
    private final Coordinator _coordinator;
    private Future<?> _refreshFuture;
    private static final int _minRefreshPeriod = 1;
    private static final int _maxRefreshPeriod = 3600;
    private static final int _defaultRefreshPeriod = 5;
    private int _refreshPeriod = 5;
    private int _minSamples = 2;
    private int _maxSamples = 300;
    private int _defaultSamples;
    private int _samples = this._defaultSamples = 120;
    private String[] _dateFormats = new String[]{"HH:mm:ss", "mm:ss"};
    private String _dateFormat = this._dateFormats[0];
    private final TimeFormatter _timeFormater = new TimeFormatter(this._dateFormat);
    private LineChart<Number, Number> _chart;
    private NumberAxis _xAxis;
    private NumberAxis _yAxis;
    private static final String[] _columnNames = new String[]{"Show", "Component", "Metrics View Name", "Metrics Name", "Metrics Id", "Metrics Field", "Scale", "Last", "Average", "Minimum", "Maximum", "Color"};
    private final Map<MetricsViewEditor.MetricsViewInfo, Map<String, Map<String, Map<String, MetricsRow>>>> _series = new HashMap<MetricsViewEditor.MetricsViewInfo, Map<String, Map<String, Map<String, MetricsRow>>>>();
    private static final String[] DefaultColors = new String[]{"#FF0000", "#00FF00", "#00FFFF", "#FFA07A", "#FFC0CB", "#FFD700", "#CD5C5C", "#32CD32", "#AFEEEE", "#FF4500", "#FF69B4", "#BDB76B", "#8B0000", "#9ACD32", "#00BFFF", "#4B0082"};
    private final JTable _legendTable;
    private final LegendTableModel _legendModel = new LegendTableModel();
    private JSplitPane _splitPane;
    private final Map<String, String> _styles = new HashMap<String, String>();
    private final Double[] _scales = new Double[]{1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};
    private static final int ScaleColumnNumber = 6;
    private final Semaphore _sem = new Semaphore(0);
    private final ExecutorService _queue = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "GraphView-Thread");
        t.setDaemon(true);
        return t;
    });
    private final Preferences _preferences;
    private static final DataFormat LocalObjectMimeType = new DataFormat(new String[]{"application/x-java-jvm-local-objectref"});

    public GraphView(Coordinator coordinator, String title) {
        this._coordinator = coordinator;
        this.setTitle(title);
        this._preferences = Coordinator.getPreferences().node("LiveDeployment");
        Platform.setImplicitExit((boolean)false);
        this.setIconImage(Utils.getIcon("/icons/16x16/metrics_graph.png").getImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GraphView.this.close();
            }
        });
        AbstractAction preferences = new AbstractAction("Preferences"){

            @Override
            public void actionPerformed(ActionEvent event) {
                JTextField title = new JTextField(GraphView.this.getTitle());
                DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref,2dlu,pref:grow", "pref"));
                builder.append("Title:", (Component)title);
                JPanel titlePanel = builder.getPanel();
                SpinnerNumberModel refreshPeriod = new SpinnerNumberModel(GraphView.this.getRefreshPeriod(), 1, 3600, 1);
                SpinnerNumberModel samples = new SpinnerNumberModel(GraphView.this._samples, GraphView.this._minSamples, GraphView.this._maxSamples, 1);
                DefaultFormBuilder builder2 = new DefaultFormBuilder(new FormLayout("pref,2dlu,pref:grow", "pref"));
                builder2.rowGroupingEnabled(true);
                JSpinner spinner = new JSpinner(refreshPeriod);
                builder2.append("Sample interval:", (Component)spinner);
                builder2.append("", (Component)new JLabel("<html><p>Sample interval in seconds; must be between 1<br/>and 3600 seconds.</p></html>"));
                JPanel refreshPanel = builder2.getPanel();
                JComboBox<String> dateFormats = new JComboBox<String>(GraphView.this._dateFormats);
                dateFormats.setSelectedItem(GraphView.this.getDateFormat());
                DefaultFormBuilder builder3 = new DefaultFormBuilder(new FormLayout("pref,2dlu,pref:grow", "pref"));
                builder3.append("Samples displayed:", (Component)new JSpinner(samples));
                builder3.append("", (Component)new JLabel("<html><p>The number of samples displayed on a graph;<br/>must be between 2 and 300.</p></html>"));
                builder3.append("Time format:", dateFormats);
                JPanel xAxisPanel = builder3.getPanel();
                FormLayout layout = new FormLayout("fill:pref:grow", "pref");
                DefaultFormBuilder builder4 = new DefaultFormBuilder(layout);
                builder4.border((Border)Borders.DIALOG);
                builder4.append((Component)titlePanel);
                builder4.nextLine();
                builder4.append((Component)refreshPanel);
                builder4.nextLine();
                builder4.append((Component)xAxisPanel);
                if (JOptionPane.showConfirmDialog(GraphView.this, builder4.getPanel(), "Metrics Graph Preferences", 2, -1) != 0) {
                    return;
                }
                GraphView.this.setTitle(title.getText());
                GraphView.this.setRefreshPeriod(refreshPeriod.getNumber().intValue());
                GraphView.this.setMaximumSamples(samples.getNumber().intValue());
                GraphView.this.setDateFormat((String)dateFormats.getSelectedItem());
            }
        };
        this._legendTable = new JTable(this._legendModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                return ((GraphView)GraphView.this)._legendModel.getRows((int[])new int[]{this.rowAtPoint((Point)e.getPoint())})[0].cell.getField().getColumnToolTip();
            }
        };
        int fontSize = this._legendTable.getFont().getSize();
        int minRowHeight = fontSize + fontSize / 3;
        if (this._legendTable.getRowHeight() < minRowHeight) {
            this._legendTable.setRowHeight(minRowHeight);
        }
        final AbstractAction delete = new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent event) {
                MetricsRow[] rows;
                int[] selectedRows = GraphView.this._legendTable.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    selectedRows[i] = GraphView.this._legendTable.convertRowIndexToModel(selectedRows[i]);
                }
                for (MetricsRow row : rows = GraphView.this._legendModel.removeRows(selectedRows)) {
                    Map j = (Map)GraphView.this._series.get(row.info);
                    Map k = (Map)j.get(row.cell.getField().getMetricsName());
                    Map l = (Map)k.get(row.cell.getId());
                    l.remove(row.cell.getField().getFieldName());
                    if (l.size() != 0) continue;
                    k.remove(row.cell.getId());
                    if (k.size() != 0) continue;
                    j.remove(row.cell.getField().getMetricsName());
                    if (j.size() != 0) continue;
                    GraphView.this._series.remove(row.info);
                    if (GraphView.this._series.size() != 0) continue;
                    GraphView.this.stopRefresh();
                }
                GraphView.this.enqueueJFX(() -> {
                    for (MetricsRow row : rows) {
                        for (int i = 0; i < row.series.size(); ++i) {
                            XYChart.Series series = (XYChart.Series)row.series.get(i);
                            String seriesClass = GraphView.this.getSeriesClass((XYChart.Series<Number, Number>)series);
                            if (seriesClass != null) {
                                GraphView.this._styles.remove(seriesClass);
                            }
                            try {
                                series.getData().clear();
                                continue;
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        };
        delete.setEnabled(false);
        delete.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        this._legendTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    delete.setEnabled(GraphView.this._legendTable.getSelectedRows().length > 0);
                }
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(preferences);
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic(69);
        editMenu.add(delete);
        menuBar.add(editMenu);
        this.setJMenuBar(menuBar);
        this._legendTable.setDefaultRenderer(Double.class, new MetricsViewEditor.FormatedNumberRenderer("#0.000"));
        JComboBox<Double> scales = new JComboBox<Double>(this._scales);
        scales.setRenderer(new DecimalRenderer(scales.getRenderer()));
        this._legendTable.getColumnModel().getColumn(6).setCellEditor(new DefaultCellEditor(scales));
        this._legendTable.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this._legendTable.setDefaultEditor(Color.class, new ColorEditor());
        this._legendTable.setAutoCreateRowSorter(true);
        JFXPanel fxPanel = new JFXPanel();
        fxPanel.setMinimumSize(new Dimension(0, 200));
        fxPanel.setPreferredSize(new Dimension(800, 400));
        this._splitPane = new JSplitPane(0);
        this._splitPane.setTopComponent((Component)fxPanel);
        JScrollPane scrollPane = new JScrollPane(this._legendTable);
        scrollPane.setTransferHandler(new TransferHandler());
        scrollPane.setMinimumSize(new Dimension(0, 50));
        scrollPane.setPreferredSize(new Dimension(800, 200));
        this._splitPane.setBottomComponent(scrollPane);
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("fill:pref:grow", "fill:pref:grow, pref"));
        builder.append((Component)this._splitPane);
        builder.nextLine();
        JPanel panel = builder.getPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        class ToolBar
        extends JToolBar {
            public ToolBar() {
                this.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
                this.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
                this.setFloatable(false);
                this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
                JButton button = new JButton(delete);
                button.setText(null);
                button.setIcon(Utils.getIcon("/icons/24x24/delete.png"));
                this.add(button);
            }
        }
        this.getContentPane().add((Component)new ToolBar(), "First");
        this.getContentPane().add((Component)panel, "Center");
        this.setPreferredSize(new Dimension(800, 600));
        this.enqueueJFX(() -> {
            this._xAxis = new NumberAxis();
            this._yAxis = new NumberAxis();
            this._chart = new LineChart((Axis)this._xAxis, (Axis)this._yAxis);
            this._chart.setCreateSymbols(false);
            this._xAxis.setLabel("Time (" + this.getDateFormat() + ")");
            this._xAxis.setTickLabelFormatter((StringConverter)this._timeFormater);
            this._xAxis.setForceZeroInRange(false);
            this._chart.setAnimated(true);
            this._chart.setLegendVisible(false);
            final Scene scene = new Scene(this._chart);
            scene.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent event) {
                    Object object;
                    Dragboard db = event.getDragboard();
                    if (event.getGestureSource() != scene && db.hasContent(LocalObjectMimeType) && (object = db.getContent(LocalObjectMimeType)) instanceof MetricsViewEditor.MetricsViewTransferableData) {
                        event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                    }
                    event.consume();
                }
            });
            scene.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent event) {
                    Object object;
                    boolean success = false;
                    Dragboard db = event.getDragboard();
                    if (event.getGestureSource() != scene && db.hasContent(LocalObjectMimeType) && (object = db.getContent(LocalObjectMimeType)) instanceof MetricsViewEditor.MetricsViewTransferableData) {
                        GraphView.this.addSeries((MetricsViewEditor.MetricsViewTransferableData)object);
                        success = true;
                    }
                    event.setDropCompleted(success);
                    event.consume();
                }
            });
            fxPanel.setScene(scene);
        });
        this.pack();
        if (!this.loadPreferences()) {
            this._splitPane.setDividerLocation(400);
        }
        this.setVisible(true);
        if (this.showInfo()) {
            JCheckBox checkbox = new JCheckBox("Do not show this message again.");
            String message = "Drop metrics cells to add them to the graph.";
            JOptionPane.showConfirmDialog(this, new Object[]{message, checkbox}, "Information", -1, 1);
            if (checkbox.isSelected()) {
                this._preferences.node("GraphView").putBoolean("showInfo", false);
            }
        }
    }

    private boolean showInfo() {
        try {
            if (!this._preferences.nodeExists("GraphView")) {
                return true;
            }
        }
        catch (BackingStoreException ex) {
            return true;
        }
        return this._preferences.node("GraphView").getBoolean("showInfo", true);
    }

    private void storePreferences() {
        Preferences preferences = this._preferences.node("GraphView");
        Utils.storeWindowBounds(this, preferences);
        for (int i = _columnNames.length - 1; i >= 0; --i) {
            preferences.putInt("colPos" + Integer.toString(i), this._legendTable.convertColumnIndexToModel(i));
            preferences.putInt("colWidth" + Integer.toString(i), this._legendTable.getColumnModel().getColumn(i).getWidth());
        }
        preferences.putInt("splitLocation", this._splitPane.getDividerLocation());
        preferences.putInt("sampleInterval", this.getRefreshPeriod());
        preferences.putInt("maximumSamples", this.getMaximumSamples());
        preferences.put("dateFormat", this.getDateFormat());
    }

    private boolean loadPreferences() {
        Preferences preferences = Utils.restoreWindowBounds(this, this._preferences, "GraphView", this._coordinator.getMainFrame());
        if (preferences == null) {
            return false;
        }
        this._splitPane.setDividerLocation(preferences.getInt("splitLocation", 600));
        for (int i = _columnNames.length - 1; i >= 0; --i) {
            int columnWidth;
            int pos = this._legendTable.convertColumnIndexToView(preferences.getInt("columnPos" + Integer.toString(i), i));
            if (i != pos) {
                this._legendTable.getColumnModel().moveColumn(pos, i);
            }
            if ((columnWidth = preferences.getInt("colWidth" + Integer.toString(i), -1)) == -1) continue;
            this._legendTable.getColumnModel().getColumn(i).setPreferredWidth(columnWidth);
        }
        int refreshPeriod = preferences.getInt("refreshPeriod", 5);
        if (refreshPeriod < 1) {
            refreshPeriod = 1;
        } else if (refreshPeriod > 3600) {
            refreshPeriod = 3600;
        }
        this.setRefreshPeriod(refreshPeriod);
        int samples = preferences.getInt("maximumSamples", this._defaultSamples);
        if (samples < this._minSamples) {
            samples = this._minSamples;
        } else if (samples > this._maxSamples) {
            samples = this._maxSamples;
        }
        this.setMaximumSamples(samples);
        this.setDateFormat(preferences.get("dateFormat", this.getDateFormat()));
        return true;
    }

    @Override
    public void close() {
        this.storePreferences();
        this.stopRefresh();
        this.setVisible(false);
        this._coordinator.removeGraphView(this);
    }

    @Override
    public void addSeries(MetricsViewEditor.MetricsViewTransferableData data) {
        this.enqueueJFX(() -> {
            Map<String, Map<String, MetricsRow>> rows;
            Map<String, Map<String, Map<String, MetricsRow>>> metrics = this._series.get(data.info);
            if (metrics == null) {
                metrics = new HashMap<String, Map<String, Map<String, MetricsRow>>>();
                this._series.put(data.info, metrics);
            }
            if ((rows = metrics.get(data.name)) == null) {
                rows = new HashMap<String, Map<String, MetricsRow>>();
                metrics.put(data.name, rows);
            }
            for (Map.Entry<String, List<MetricsViewEditor.MetricsCell>> i : data.rows.entrySet()) {
                String rowId = i.getKey();
                Map<String, MetricsRow> columns = rows.get(rowId);
                if (columns == null) {
                    columns = new HashMap<String, MetricsRow>();
                    rows.put(rowId, columns);
                }
                for (MetricsViewEditor.MetricsCell j : i.getValue()) {
                    if (columns.get(j.getField().getFieldName()) != null) continue;
                    String color = DefaultColors[this._chart.getData().size() % DefaultColors.length];
                    final MetricsRow row = new MetricsRow(data.info, j, color, (XYChart.Series<Number, Number>)new XYChart.Series());
                    XYChart.Series<Number, Number> series = row.series.peek();
                    this._chart.getData().add(series);
                    String styleClass = this.getSeriesClass(series);
                    this.addStyle(series, styleClass, color);
                    this.setNodesStyle(styleClass);
                    columns.put(j.getField().getFieldName(), row);
                    j.getField().setContext(this);
                    Node n = this._chart.lookup(".chart-series-line." + styleClass);
                    if (n != null) {
                        n.setOnMousePressed((EventHandler)new EventHandler<javafx.scene.input.MouseEvent>(){

                            public void handle(javafx.scene.input.MouseEvent e) {
                                if (e.getEventType() == javafx.scene.input.MouseEvent.MOUSE_PRESSED && e.getButton() == MouseButton.PRIMARY) {
                                    GraphView.this.enqueueSwing(() -> {
                                        int i = GraphView.this._legendModel.getRowIndex(row);
                                        if (i != -1) {
                                            i = GraphView.this._legendTable.convertRowIndexToView(i);
                                            GraphView.this._legendTable.setRowSelectionInterval(i, i);
                                        }
                                    });
                                }
                            }
                        });
                    }
                    this.enqueueSwing(() -> this._legendModel.addRow(row));
                }
            }
            if (this._chart.getData().size() > 0) {
                this.startRefresh();
            }
        });
    }

    void addSeries(final MetricsRow row) {
        XYChart.Series series = new XYChart.Series();
        row.series.push((XYChart.Series<Number, Number>)series);
        this._chart.getData().add((Object)series);
        String styleClass = this.getSeriesClass((XYChart.Series<Number, Number>)series);
        this.addStyle((XYChart.Series<Number, Number>)series, styleClass, row.color);
        this.setNodesStyle(styleClass);
        row.cell.resetField();
        Node n = this._chart.lookup(".chart-series-line." + styleClass);
        if (n != null) {
            n.setOnMousePressed((EventHandler)new EventHandler<javafx.scene.input.MouseEvent>(){

                public void handle(javafx.scene.input.MouseEvent e) {
                    if (e.getEventType() == javafx.scene.input.MouseEvent.MOUSE_PRESSED && e.getButton() == MouseButton.PRIMARY) {
                        GraphView.this.enqueueSwing(() -> {
                            int i = GraphView.this._legendModel.getRowIndex(row);
                            if (i != -1) {
                                i = GraphView.this._legendTable.convertRowIndexToView(i);
                                GraphView.this._legendTable.setRowSelectionInterval(i, i);
                            }
                        });
                    }
                }
            });
        }
    }

    private void addData(MetricsViewEditor.MetricsViewInfo info, Map<String, Metrics[]> data, long timestamp) {
        this.enqueueJFX(() -> {
            Map<String, Map<String, Map<String, MetricsRow>>> series = this._series.get(info);
            if (series == null) {
                return;
            }
            for (Map.Entry<String, Map<String, Map<String, MetricsRow>>> i : series.entrySet()) {
                Metrics[] metricsSeq = null;
                if (data != null) {
                    metricsSeq = (Metrics[])data.get(i.getKey());
                }
                for (Map.Entry<String, Map<String, MetricsRow>> j : i.getValue().entrySet()) {
                    Metrics metrics = null;
                    if (metricsSeq != null) {
                        for (Metrics m : metricsSeq) {
                            if (!m.id.equals(j.getKey())) continue;
                            metrics = m;
                            break;
                        }
                    }
                    for (Map.Entry entry : j.getValue().entrySet()) {
                        MetricsRow row = (MetricsRow)entry.getValue();
                        if (metrics == null) {
                            if (!row.disabled) {
                                row.series.push((XYChart.Series<Number, Number>)new XYChart.Series());
                                row.disabled = true;
                            }
                            row.series.peek().getData().add((Object)new XYChart.Data((Object)0, (Object)0));
                        } else {
                            try {
                                Number value;
                                if (row.disabled) {
                                    this.addSeries(row);
                                    row.disabled = false;
                                }
                                if ((value = row.cell.getValue(metrics, timestamp)) == null) continue;
                                row.series.peek().getData().add((Object)new XYChart.Data((Object)timestamp, (Object)value));
                            }
                            catch (RuntimeException ex) {
                                ex.printStackTrace();
                            }
                        }
                        this.adjustSize(row);
                    }
                }
            }
            this.enqueueSwing(() -> this._legendModel.fireTableChanged(new TableModelEvent(this._legendModel, 0, this._legendModel.getRowCount() - 1, -1, 0)));
        });
    }

    int seriesSize(MetricsRow row) {
        int size = 0;
        for (int i = 0; i < row.series.size(); ++i) {
            size += ((XYChart.Series)row.series.get(i)).getData().size();
        }
        return size;
    }

    void adjustSize(MetricsRow row) {
        int samples = this.seriesSize(row);
        int n = this.getMaximumSamples();
        while (samples > n) {
            for (int i = 0; i < row.series.size(); ++i) {
                XYChart.Series series = (XYChart.Series)row.series.get(i);
                while (series.getData().size() > 0 && samples > n) {
                    try {
                        series.getData().remove(0);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    --samples;
                    if (series.getData().size() != 0 || row.series.size() <= 1) continue;
                    row.series.remove(series);
                    --i;
                }
            }
        }
    }

    private synchronized void startRefresh() {
        if (this._refreshFuture == null) {
            this._refreshFuture = this._coordinator.getScheduledExecutor().scheduleAtFixedRate(() -> {
                HashSet<MetricsViewEditor.MetricsViewInfo> metrics = null;
                GraphView graphView = this;
                synchronized (graphView) {
                    metrics = new HashSet<MetricsViewEditor.MetricsViewInfo>(this._series.keySet());
                }
                for (MetricsViewEditor.MetricsViewInfo m : metrics) {
                    try {
                        m.admin.getMetricsViewAsync(m.view).whenComplete((result, ex) -> {
                            if (ex == null) {
                                this.addData(m, result.returnValue, result.timestamp);
                            } else {
                                this.addData(m, null, 0L);
                            }
                        });
                    }
                    catch (LocalException e) {
                        this.addData(m, null, 0L);
                    }
                }
            }, 0L, this._refreshPeriod, TimeUnit.SECONDS);
        }
    }

    private synchronized void stopRefresh() {
        if (this._refreshFuture != null) {
            this._refreshFuture.cancel(false);
            this._refreshFuture = null;
        }
    }

    @Override
    public synchronized int getRefreshPeriod() {
        return this._refreshPeriod;
    }

    synchronized void setRefreshPeriod(int refreshPeriod) {
        if (refreshPeriod == this._refreshPeriod) {
            return;
        }
        this._refreshPeriod = refreshPeriod;
        if (this._refreshFuture != null) {
            this._refreshFuture.cancel(false);
            this._refreshFuture = null;
            this.startRefresh();
        }
    }

    synchronized String getDateFormat() {
        return this._dateFormat;
    }

    synchronized void setDateFormat(String dateFormat) {
        this._dateFormat = dateFormat;
        this._timeFormater.setDateFormat(dateFormat);
        this.enqueueJFX(() -> this._xAxis.setLabel("Time (" + this.getDateFormat() + ")"));
    }

    private synchronized void setMaximumSamples(int samples) {
        if (samples == this._samples) {
            return;
        }
        if (samples < this._samples) {
            this._samples = samples;
            this.enqueueJFX(() -> {
                MetricsRow[] rows;
                for (MetricsRow row : rows = this._legendModel.getRows()) {
                    this.adjustSize(row);
                }
            });
        } else {
            this._samples = samples;
        }
    }

    private synchronized int getMaximumSamples() {
        return this._samples;
    }

    void updateScaleFactor(XYChart.Series<Number, Number> series, double s1, double s2) {
        this.enqueueJFX(() -> {
            for (XYChart.Data i : series.getData()) {
                i.setYValue((Object)(((Number)i.getYValue()).doubleValue() * s2 / s1));
            }
        });
    }

    void updateSeriesColor(XYChart.Series<Number, Number> series, String color) {
        this.enqueueJFX(() -> {
            String styleClass = this.getSeriesClass(series);
            if (styleClass != null) {
                this.addStyle(series, styleClass, color);
                this.setNodesStyle(styleClass);
            }
        });
    }

    public String getSeriesClass(XYChart.Series<Number, Number> series) {
        if (series == null || series.getNode() == null || series.getNode().getStyleClass() == null) {
            return null;
        }
        String value = null;
        for (String styleClass : series.getNode().getStyleClass()) {
            if (!styleClass.startsWith("series")) continue;
            value = styleClass;
            break;
        }
        return value;
    }

    private void setNodesStyle(String seriesClass) {
        String style = this._styles.get(seriesClass);
        for (Node n : this._chart.lookupAll("." + seriesClass)) {
            n.setStyle(style);
            n.setEffect(null);
        }
    }

    private void setNodesVisible(String seriesClass, boolean visible) {
        for (Node n : this._chart.lookupAll("." + seriesClass)) {
            n.setVisible(visible);
        }
    }

    private void addStyle(XYChart.Series<Number, Number> series, String seriesClass, String color) {
        StringBuilder sb = new StringBuilder();
        sb.append("-fx-stroke: ");
        sb.append(color);
        sb.append("; ");
        sb.append("-fx-background-color: ");
        sb.append(color);
        sb.append(", white;");
        sb.append("-fx-stroke-width: 3;");
        this._styles.put(seriesClass, sb.toString());
    }

    private void enqueueJFX(Runnable runnable) {
        this._queue.submit(() -> {
            Platform.runLater(() -> {
                try {
                    runnable.run();
                }
                finally {
                    this._sem.release();
                }
            });
            this._sem.acquireUninterruptibly();
        });
    }

    private void enqueueSwing(Runnable runnable) {
        this._queue.submit(() -> {
            SwingUtilities.invokeLater(() -> {
                try {
                    runnable.run();
                }
                finally {
                    this._sem.release();
                }
            });
            this._sem.acquireUninterruptibly();
        });
    }

    static class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Color newColor = (Color)color;
            this.setBackground(newColor);
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }

    public class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        Color _currentColor;
        JButton _button = new JButton();
        JColorChooser _colorChooser;
        JDialog _dialog;
        protected static final String EDIT = "edit";

        public ColorEditor() {
            AbstractColorChooserPanel[] panels;
            this._button.setActionCommand(EDIT);
            this._button.addActionListener(this);
            this._button.setBorderPainted(false);
            this._colorChooser = new JColorChooser();
            for (AbstractColorChooserPanel panel : panels = this._colorChooser.getChooserPanels()) {
                if (panel.getClass().getName().equals("javax.swing.colorchooser.DefaultSwatchChooserPanel")) continue;
                this._colorChooser.removeChooserPanel(panel);
            }
            this._dialog = JColorChooser.createDialog(this._button, "Select the metrics color", true, this._colorChooser, this, null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                this._button.setBackground(this._currentColor);
                this._colorChooser.setColor(this._currentColor);
                this._dialog.setVisible(true);
                this.fireEditingStopped();
            } else {
                this._currentColor = this._colorChooser.getColor();
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this._currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this._currentColor = (Color)value;
            return this._button;
        }
    }

    static class DecimalRenderer
    extends DefaultListCellRenderer {
        private ListCellRenderer _renderer;
        private static final DecimalFormat _format = new DecimalFormat("#,###,###,##0.0########");

        public DecimalRenderer(ListCellRenderer renderer) {
            this._renderer = renderer;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this._renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (c instanceof JLabel) {
                ((JLabel)c).setText(_format.format(value));
            } else {
                c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(_format.format(value));
            }
            return c;
        }
    }

    class LegendTableModel
    extends AbstractTableModel {
        private Map<Integer, MetricsRow> _rows = new HashMap<Integer, MetricsRow>();

        LegendTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return _columnNames[col];
        }

        @Override
        public int getRowCount() {
            return this._rows.size();
        }

        @Override
        public int getColumnCount() {
            return _columnNames.length;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return String.class;
                }
                case 6: {
                    return Double.class;
                }
                case 7: {
                    return Double.class;
                }
                case 8: {
                    return Double.class;
                }
                case 9: {
                    return Double.class;
                }
                case 10: {
                    return Double.class;
                }
                case 11: {
                    return Color.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex > this._rows.size() || columnIndex > _columnNames.length) {
                return null;
            }
            MetricsRow row = this._rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return row.visible;
                }
                case 1: {
                    return row.info.component;
                }
                case 2: {
                    return row.info.view;
                }
                case 3: {
                    return row.cell.getField().getMetricsName();
                }
                case 4: {
                    return row.cell.getId();
                }
                case 5: {
                    return row.cell.getField().getColumnName();
                }
                case 6: {
                    return row.cell.getScaleFactor();
                }
                case 7: {
                    return row.cell.getLast();
                }
                case 8: {
                    return row.cell.getAverage();
                }
                case 9: {
                    return row.cell.getMin();
                }
                case 10: {
                    return row.cell.getMax();
                }
                case 11: {
                    return new Color(Integer.parseInt(row.color.substring(1), 16));
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col < _columnNames.length && (_columnNames[col].equals("Show") || _columnNames[col].equals("Scale") || _columnNames[col].equals("Color"));
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (this.isCellEditable(rowIndex, columnIndex)) {
                MetricsRow row = this._rows.get(rowIndex);
                if (_columnNames[columnIndex].equals("Show")) {
                    row.visible = (Boolean)value;
                    GraphView.this.enqueueJFX(() -> {
                        for (int i = 0; i < row.series.size(); ++i) {
                            GraphView.this.setNodesVisible(GraphView.this.getSeriesClass((XYChart.Series<Number, Number>)((XYChart.Series)row.series.get(i))), row.visible);
                        }
                    });
                } else if (_columnNames[columnIndex].equals("Scale")) {
                    double s1 = (Double)this.getValueAt(rowIndex, columnIndex);
                    double s2 = (Double)value;
                    for (int i = 0; i < row.series.size(); ++i) {
                        GraphView.this.updateScaleFactor((XYChart.Series<Number, Number>)((XYChart.Series)row.series.get(i)), s1, s2);
                    }
                    row.cell.setScaleFactor((Double)value);
                } else if (_columnNames[columnIndex].equals("Color")) {
                    Color color = (Color)value;
                    row.color = "#" + String.format("%02X", color.getRed()) + String.format("%02X", color.getGreen()) + String.format("%02X", color.getBlue());
                    for (int i = 0; i < row.series.size(); ++i) {
                        GraphView.this.updateSeriesColor((XYChart.Series<Number, Number>)((XYChart.Series)row.series.get(i)), row.color);
                    }
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        public void addRow(MetricsRow row) {
            int i = this._rows.size();
            this._rows.put(i, row);
            this.fireTableRowsInserted(i, i);
        }

        public MetricsRow[] removeRows(int[] rowIndexes) {
            MetricsRow[] deletedRows = new MetricsRow[rowIndexes.length];
            for (int i = 0; i < rowIndexes.length; ++i) {
                deletedRows[i] = this._rows.remove(rowIndexes[i]);
            }
            HashMap<Integer, MetricsRow> rows = new HashMap<Integer, MetricsRow>();
            for (Map.Entry<Integer, MetricsRow> e : this._rows.entrySet()) {
                rows.put(rows.size(), e.getValue());
            }
            this._rows = rows;
            this.fireTableDataChanged();
            return deletedRows;
        }

        public MetricsRow[] getRows(int[] rowIndexes) {
            MetricsRow[] rows = new MetricsRow[rowIndexes.length];
            for (int i = 0; i < rowIndexes.length; ++i) {
                rows[i] = this._rows.get(rowIndexes[i]);
            }
            return rows;
        }

        public MetricsRow[] getRows() {
            return this._rows.values().toArray(new MetricsRow[this._rows.size()]);
        }

        public int getRowIndex(MetricsRow row) {
            int index = -1;
            for (Map.Entry<Integer, MetricsRow> entry : this._rows.entrySet()) {
                if (row != entry.getValue()) continue;
                index = entry.getKey();
                break;
            }
            return index;
        }
    }

    class MetricsRow {
        boolean visible = true;
        boolean disabled = false;
        MetricsViewEditor.MetricsViewInfo info;
        MetricsViewEditor.MetricsCell cell;
        String color;
        Stack<XYChart.Series<Number, Number>> series = new Stack();

        public MetricsRow(MetricsViewEditor.MetricsViewInfo info, MetricsViewEditor.MetricsCell cell, String color, XYChart.Series<Number, Number> series) {
            this.info = info;
            this.cell = cell;
            this.color = color;
            this.series.push(series);
        }
    }

    class TransferHandler
    extends javax.swing.TransferHandler {
        TransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            boolean supported = false;
            for (DataFlavor f : support.getDataFlavors()) {
                if (!f.equals(MetricsViewEditor.MetricsViewTransferableData.dataFlavor())) continue;
                supported = true;
                break;
            }
            return supported;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            Transferable t = support.getTransferable();
            for (DataFlavor flavor : support.getDataFlavors()) {
                try {
                    if (!flavor.equals(MetricsViewEditor.MetricsViewTransferableData.dataFlavor())) continue;
                    GraphView.this.addSeries((MetricsViewEditor.MetricsViewTransferableData)t.getTransferData(flavor));
                    break;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    class TimeFormatter
    extends StringConverter<Number> {
        private DateFormat _dateFormat;

        TimeFormatter(String format) {
            this.setDateFormat(format);
            this._dateFormat.setTimeZone(TimeZone.getDefault());
        }

        public synchronized String toString(Number timestamp) {
            Date date = new Date(timestamp.longValue());
            if (date.getTime() < 1000L) {
                return "";
            }
            return this._dateFormat.format(date);
        }

        public synchronized Number fromString(String time) {
            try {
                long t = this._dateFormat.parse(time).getTime();
                return t;
            }
            catch (ParseException e) {
                return 0;
            }
        }

        public synchronized void setDateFormat(String format) {
            this._dateFormat = new SimpleDateFormat(format);
        }
    }
}

