/*
 * Decompiled with CFR 0.152.
 */
package gps.connection;

import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Semaphore;
import gps.connection.DecoderStateFactory;
import gps.connection.DecoderStateInterface;
import gps.connection.GPSPort;

public final class GPSrxtx {
    private static GPSPort defaultGpsPort;
    private GPSPort gpsPort;
    private DecoderStateInterface state = DecoderStateFactory.getInstance(0);
    private final BT747Semaphore writeOngoing = JavaLibBridge.getSemaphoreInstance(1);
    private final BT747Semaphore getResponseOngoing = JavaLibBridge.getSemaphoreInstance(1);
    private StringBuffer virtualInput = null;
    private String debugCon = null;
    private boolean isGpsDebug = false;
    private final 1 buffer$4f38c4ab = new 1(this, 0);

    public GPSrxtx() {
        this(defaultGpsPort);
    }

    private GPSrxtx(GPSPort gPSPort) {
        if (gPSPort == null) {
            Generic.debug("GPSrxtPort instance is null - review initialisation");
        }
        this.gpsPort = gPSPort;
        this.updatePortDebug();
    }

    public final void newState(int n) {
        DecoderStateInterface decoderStateInterface = DecoderStateFactory.getInstance(n);
        GPSrxtx gPSrxtx = this;
        if (!decoderStateInterface.equals(gPSrxtx.state)) {
            gPSrxtx.state.exitState$450a8104();
            gPSrxtx.state = decoderStateInterface;
            gPSrxtx.state.enterState$450a8104();
        }
    }

    public final Object getState() {
        return this.state;
    }

    public static final void setDefaultGpsPortInstance(GPSPort gPSPort) {
        defaultGpsPort = gPSPort;
    }

    public static final boolean hasDefaultPortInstance() {
        return defaultGpsPort != null;
    }

    public final GPSPort getGpsPort() {
        return this.gpsPort;
    }

    public final void setDefaults(int n, int n2) {
        this.gpsPort.setPort(n);
        this.gpsPort.setSpeed(n2);
    }

    private final int myOpenPort() {
        if (this.gpsPort == null) {
            this.gpsPort = defaultGpsPort;
        }
        return this.gpsPort.openPort();
    }

    public final void setBluetoothAndOpen() {
        this.gpsPort.setBlueTooth();
        this.myOpenPort();
    }

    public final void setUSBAndOpen() {
        this.gpsPort.setUSB();
        this.myOpenPort();
    }

    public final void closePort() {
        this.gpsPort.closePort();
    }

    public final void openPort() {
        this.gpsPort.closePort();
        this.myOpenPort();
    }

    public final int setPortAndOpen(int n) {
        this.gpsPort.setPort(n);
        return this.myOpenPort();
    }

    public final int setFreeTextPortAndOpen(String string) {
        int n;
        if (this.gpsPort != null) {
            Generic.debug("Class" + this.gpsPort.getClass().getName());
            this.gpsPort.setFreeTextPort(string);
            n = this.myOpenPort();
            Generic.debug("Port opened");
        } else {
            Generic.debug("Must set gpsPort handler");
            n = -1;
        }
        return n;
    }

    public final String getFreeTextPort() {
        return this.gpsPort.getFreeTextPort();
    }

    public final int getPort() {
        return this.gpsPort.getPort();
    }

    public final int getSpeed() {
        return this.gpsPort.getSpeed();
    }

    public final void setBaudRate(int n) {
        this.gpsPort.setSpeed(n);
    }

    public final boolean isConnected() {
        return this.gpsPort != null && this.gpsPort.isConnected();
    }

    public final void write(String string) {
        this.writeOngoing.down();
        if (Generic.isDebug()) {
            String string2 = ">" + string + "<";
            this.gpsPort.writeDebug(string2);
        }
        this.gpsPort.write(string);
        this.writeOngoing.up();
    }

    public final void write(byte[] object) {
        this.writeOngoing.down();
        this.gpsPort.write((byte[])object);
        if (Generic.isDebug()) {
            object = ">" + ((byte[])object).length + " bytes sent";
            if (Generic.getDebugLevel() > 1) {
                Generic.debug((String)object);
            }
            this.gpsPort.writeDebug((String)object);
        }
        this.writeOngoing.up();
    }

    public final Object getResponse() {
        this.getResponseOngoing.down();
        this.buffer$4f38c4ab.resetReadStrategy();
        if (defaultGpsPort.debugActive()) {
            defaultGpsPort.writeDebug("\r\nR:" + Generic.getTimeStamp() + ":");
        }
        Object object = this.state.getResponse(this);
        this.getResponseOngoing.up();
        return object;
    }

    public final void setDebugConn(boolean bl, String string) {
        this.debugCon = string + "/gpsRawDebug.txt";
        this.isGpsDebug = bl;
        this.updatePortDebug();
    }

    private final void updatePortDebug() {
        if (this.gpsPort != null) {
            this.gpsPort.setDebugFileName(this.debugCon);
            if (this.isGpsDebug) {
                this.gpsPort.startDebug();
                return;
            }
            this.gpsPort.endDebug();
        }
    }

    public final boolean isDebugConn() {
        return this.isGpsDebug;
    }

    public final boolean isReadBufferEmpty() {
        return this.buffer$4f38c4ab.isReadBufferEmpty();
    }

    public final char getReadBufferChar() {
        return this.buffer$4f38c4ab.getReadBufferChar();
    }

    public final byte getReadBufferByte() {
        return this.buffer$4f38c4ab.getReadBufferByte();
    }

    static /* synthetic */ StringBuffer access$100(GPSrxtx gPSrxtx) {
        return null;
    }

    static /* synthetic */ StringBuffer access$102$4233aeda(GPSrxtx gPSrxtx) {
        gPSrxtx.virtualInput = null;
        return null;
    }

    static final class 1 {
        private final byte[] read_buf = new byte[4352];
        private int read_buf_p = 0;
        private int bytesRead = 0;
        private boolean readAgain;
        private /* synthetic */ GPSrxtx this$0;

        private 1(GPSrxtx gPSrxtx) {
            this.this$0 = gPSrxtx;
        }

        protected final void resetReadStrategy() {
            this.readAgain = true;
        }

        protected final boolean isReadBufferEmpty() {
            if (this.read_buf_p >= this.bytesRead) {
                this.refillBuffer();
                if (this.bytesRead > 100 || this.readAgain) {
                    this.readAgain = false;
                }
            }
            return this.read_buf_p >= this.bytesRead;
        }

        protected final char getReadBufferChar() {
            return (char)this.read_buf[this.read_buf_p++];
        }

        protected final byte getReadBufferByte() {
            return this.read_buf[this.read_buf_p++];
        }

        private boolean refillBuffer() {
            boolean bl = true;
            this.read_buf_p = 0;
            this.bytesRead = 0;
            if (this.this$0.isConnected()) {
                Object object;
                if (GPSrxtx.access$100(this.this$0) != null) {
                    object = GPSrxtx.access$100(this.this$0).toString().getBytes();
                    int n = ((byte[])object).length;
                    if (n > 4352) {
                        n = 4352;
                    }
                    this.bytesRead = n;
                    while (--n >= 0) {
                        this.read_buf[n] = object[n];
                    }
                    Generic.debug("Virtual:" + GPSrxtx.access$100(this.this$0).toString());
                    GPSrxtx.access$102$4233aeda(this.this$0);
                } else {
                    try {
                        int n = this.this$0.gpsPort.readCheck();
                        if (n > 4352) {
                            n = 4352;
                        }
                        if (n > 0) {
                            this.bytesRead = this.this$0.gpsPort.readBytes(this.read_buf, 0, n);
                        }
                    }
                    catch (Exception exception) {
                        this.bytesRead = 0;
                    }
                }
                if (this.bytesRead == 0) {
                    bl = false;
                } else if (this.this$0.gpsPort.debugActive()) {
                    object = "(" + Generic.getTimeStamp() + ")";
                    this.this$0.gpsPort.writeDebug(((String)object).getBytes(), 0, ((String)object).length());
                    this.this$0.gpsPort.writeDebug(this.read_buf, 0, this.bytesRead);
                }
            }
            return bl;
        }

        /* synthetic */ 1(GPSrxtx gPSrxtx, byte by) {
            this(gPSrxtx);
        }
    }
}

