/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.ArrayList;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.util.GUtil;

public class EnumFromCharSequenceNotationParser<T extends Enum<T>>
implements NotationConverter<CharSequence, T> {
    private final Class<? extends T> type;

    public EnumFromCharSequenceNotationParser(Class<? extends T> enumType) {
        assert (enumType.isEnum()) : "resultingType must be enum";
        this.type = enumType;
    }

    public void convert(CharSequence notation, NotationConvertResult<? super T> result) throws TypeConversionException {
        try {
            result.converted((Object)GUtil.toEnum(this.type, (Object)notation));
        }
        catch (IllegalArgumentException e) {
            throw new TypeConversionException(e.getMessage(), (Throwable)e);
        }
    }

    public void describe(DiagnosticsVisitor visitor) {
        Enum[] enumConstants;
        ArrayList<String> values = new ArrayList<String>();
        for (Enum enumConstant : enumConstants = (Enum[])this.type.getEnumConstants()) {
            values.add(enumConstant.name());
        }
        visitor.candidate(String.format("One of the following values: %s", GUtil.toString(values)));
        visitor.values(values);
    }
}

