/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;

public class Providers {
    public static final String NULL_TRANSFORMER_RESULT = "Transformer for this provider returned a null value.";
    public static final String NULL_VALUE = "No value has been specified for this provider.";
    private static final Provider<Object> NULL_PROVIDER = new AbstractMinimalProvider<Object>(){

        public Object get() {
            throw new IllegalStateException(Providers.NULL_VALUE);
        }

        @Override
        @Nullable
        public Class<Object> getType() {
            return null;
        }

        public Object getOrNull() {
            return null;
        }

        @Override
        public Object getOrElse(Object defaultValue) {
            return defaultValue;
        }

        @Override
        public <S> ProviderInternal<S> map(Transformer<? extends S, ? super Object> transformer) {
            return (ProviderInternal)Cast.uncheckedCast((Object)this);
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public ProviderInternal<Object> withFinalValue() {
            return this;
        }

        @Override
        public String toString() {
            return "undefined";
        }
    };
    public static final Provider<Boolean> TRUE = Providers.of(true);
    public static final Provider<Boolean> FALSE = Providers.of(false);

    public static <T> ProviderInternal<T> notDefined() {
        return (ProviderInternal)Cast.uncheckedCast(NULL_PROVIDER);
    }

    public static <T> ProviderInternal<T> of(T value) {
        return new FixedValueProvider<T>(value);
    }

    public static <T> ProviderInternal<T> internal(Provider<T> value) {
        return (ProviderInternal)Cast.uncheckedCast(value);
    }

    private static class MappedFixedValueProvider<S, T>
    extends AbstractMinimalProvider<S> {
        private final Transformer<? extends S, ? super T> transformer;
        private final Provider<T> provider;
        private S value;

        MappedFixedValueProvider(Transformer<? extends S, ? super T> transformer, Provider<T> provider) {
            this.transformer = transformer;
            this.provider = provider;
        }

        @Override
        @Nullable
        public Class<S> getType() {
            if (this.value != null) {
                return (Class)Cast.uncheckedCast(this.value.getClass());
            }
            return null;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        public S get() {
            if (this.value == null) {
                this.value = this.transformer.transform(this.provider.get());
                if (this.value == null) {
                    throw new IllegalStateException(Providers.NULL_TRANSFORMER_RESULT);
                }
            }
            return this.value;
        }

        @Override
        public S getOrElse(S defaultValue) {
            return this.get();
        }

        @Nullable
        public S getOrNull() {
            return this.get();
        }

        @Override
        public <U> ProviderInternal<U> map(Transformer<? extends U, ? super S> transformer) {
            return new MappedFixedValueProvider<U, S>(transformer, this);
        }

        @Override
        public String toString() {
            if (this.value == null) {
                return String.format("transform(not calculated)", new Object[0]);
            }
            return String.format("transform(%s, %s)", this.getType(), this.value);
        }
    }

    private static class FixedValueProvider<T>
    extends AbstractMinimalProvider<T> {
        private final T value;

        FixedValueProvider(T value) {
            this.value = value;
        }

        @Override
        @Nullable
        public Class<T> getType() {
            return (Class)Cast.uncheckedCast(this.value.getClass());
        }

        public T get() {
            return this.value;
        }

        @Override
        public T getOrElse(T defaultValue) {
            return this.value;
        }

        public T getOrNull() {
            return this.value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public ProviderInternal<T> withFinalValue() {
            return this;
        }

        @Override
        public <S> ProviderInternal<S> map(Transformer<? extends S, ? super T> transformer) {
            return new MappedFixedValueProvider<S, T>(transformer, this);
        }

        @Override
        public String toString() {
            return String.format("fixed(%s, %s)", this.getType(), this.value);
        }
    }
}

