/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.util.ConfigureUtil;

public class ArchiveEntry {
    private final Path path;
    private final boolean directory;
    private final long size;
    private final long crc;
    private final ImmutableSet<ArchiveEntry> subEntries;

    private ArchiveEntry(Path path, boolean directory, long size, long crc, ImmutableSet<ArchiveEntry> subEntries) {
        this.directory = directory;
        this.size = size;
        this.crc = crc;
        this.subEntries = subEntries;
        this.path = path;
    }

    public static ArchiveEntry of(Map<String, ?> map) {
        return ((Builder)ConfigureUtil.configureByMap(map, (Object)new Builder())).build();
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public long getSize() {
        return this.size;
    }

    public long getCrc() {
        return this.crc;
    }

    public ImmutableSet<ArchiveEntry> getSubEntries() {
        return this.subEntries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchiveEntry that = (ArchiveEntry)o;
        if (!this.path.equals(that.path)) {
            return false;
        }
        if (this.directory != that.directory) {
            return false;
        }
        if (!this.subEntries.equals(that.subEntries)) {
            return false;
        }
        if (this.subEntries.isEmpty()) {
            if (this.crc != that.crc) {
                return false;
            }
            return this.size == that.size;
        }
        return this.subEntries.equals(that.subEntries);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.directory ? 1 : 0);
        if (this.subEntries.isEmpty()) {
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            result = 31 * result + (int)(this.crc ^ this.crc >>> 32);
        }
        result = 31 * result + this.subEntries.hashCode();
        return result;
    }

    public String toString() {
        return "ArchiveEntry{, path='" + this.path + '\'' + ", directory=" + this.directory + ", size=" + this.size + ", crc=" + this.crc + ", subEntries=" + this.subEntries + '}';
    }

    public static class Builder {
        private String path;
        private boolean directory;
        private long size;
        private long crc;
        private ImmutableSet<ArchiveEntry> subEntries = ImmutableSet.of();
        private List<String> parentPaths = ImmutableList.of();

        public String getPath() {
            return this.path;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public long getSize() {
            return this.size;
        }

        public long getCrc() {
            return this.crc;
        }

        public Collection<ArchiveEntry> getSubEntries() {
            return this.subEntries;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setDirectory(boolean directory) {
            this.directory = directory;
            return this;
        }

        public Builder setSize(long size) {
            this.size = size;
            return this;
        }

        public Builder setCrc(long crc) {
            this.crc = crc;
            return this;
        }

        public Builder setSubEntries(ImmutableSet<ArchiveEntry> subEntries) {
            this.subEntries = subEntries;
            return this;
        }

        public void setParentPaths(List<String> parentPaths) {
            this.parentPaths = parentPaths;
        }

        public ArchiveEntry build() {
            if (this.path == null) {
                throw new IllegalStateException("'path' is required");
            }
            if (this.subEntries == null) {
                throw new IllegalStateException("'subEntries' is required");
            }
            if (this.directory && !this.subEntries.isEmpty()) {
                throw new IllegalStateException("directory entry cannot have sub entries");
            }
            ImmutableList parts = this.parentPaths.isEmpty() ? ImmutableList.of((Object)this.path) : ImmutableList.builder().addAll(this.parentPaths).add((Object)this.path).build();
            return new ArchiveEntry(new Path((ImmutableList<String>)parts), this.directory, this.size, this.crc, this.subEntries);
        }
    }

    public static class Path
    implements Comparable<Path> {
        private final String fullPath;
        private final ImmutableList<String> components;

        public Path(ImmutableList<String> components) {
            this.fullPath = Joiner.on((String)"!/").join(components);
            this.components = components;
        }

        @Override
        public int compareTo(Path o) {
            for (int i = 0; i < Math.max(this.components.size(), o.components.size()); ++i) {
                boolean hasRight;
                boolean hasLeft = this.components.size() > i;
                boolean bl = hasRight = o.components.size() > i;
                if (!hasLeft && hasRight) {
                    return -1;
                }
                if (hasLeft && !hasRight) {
                    return 1;
                }
                int result = ((String)this.components.get(i)).compareTo((String)o.components.get(i));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Path path = (Path)o;
            return this.fullPath.equals(path.fullPath);
        }

        public int hashCode() {
            return this.fullPath.hashCode();
        }

        public String toString() {
            return this.fullPath;
        }
    }
}

