/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.javadoc.internal;

import java.io.File;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.javadoc.internal.JavadocSpec;
import org.gradle.external.javadoc.internal.JavadocExecHandleBuilder;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.process.internal.ExecException;
import org.gradle.util.GFileUtils;

public class JavadocGenerator
implements Compiler<JavadocSpec> {
    private static final Logger LOG = Logging.getLogger(JavadocGenerator.class);
    private final ExecActionFactory execActionFactory;

    public JavadocGenerator(ExecActionFactory execActionFactory) {
        this.execActionFactory = execActionFactory;
    }

    public WorkResult execute(JavadocSpec spec) {
        JavadocExecHandleBuilder javadocExecHandleBuilder = new JavadocExecHandleBuilder(this.execActionFactory);
        javadocExecHandleBuilder.setExecutable(spec.getExecutable());
        javadocExecHandleBuilder.execDirectory(spec.getWorkingDir()).options(spec.getOptions()).optionsFile(spec.getOptionsFile());
        ExecAction execAction = javadocExecHandleBuilder.getExecHandle();
        if (spec.isIgnoreFailures()) {
            execAction.setIgnoreExitValue(true);
        }
        try {
            execAction.execute();
        }
        catch (ExecException e) {
            LOG.info("Problems generating Javadoc.\n  Command line issued: " + execAction.getCommandLine() + "\n  Generated Javadoc options file has following contents:\n------\n{}------", (Object)GFileUtils.readFileQuietly((File)spec.getOptionsFile()));
            throw new GradleException(String.format("Javadoc generation failed. Generated Javadoc options file (useful for troubleshooting): '%s'", spec.getOptionsFile()), (Throwable)e);
        }
        return WorkResults.didWork((boolean)true);
    }
}

