/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.ArtifactPublicationServices;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.DefaultPublicationContainer;
import org.gradle.api.publish.internal.DefaultPublishingExtension;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.plugins.PublishingPluginRules;
import org.gradle.internal.model.RuleBasedPluginListener;
import org.gradle.internal.reflect.Instantiator;

public class PublishingPlugin
implements Plugin<Project> {
    public static final String PUBLISH_TASK_GROUP = "publishing";
    public static final String PUBLISH_LIFECYCLE_TASK_NAME = "publish";
    private final Instantiator instantiator;
    private final ArtifactPublicationServices publicationServices;
    private final ProjectPublicationRegistry projectPublicationRegistry;
    private final FeaturePreviews featurePreviews;
    private final DocumentationRegistry documentationRegistry;
    private CollectionCallbackActionDecorator collectionCallbackActionDecorator;

    @Inject
    public PublishingPlugin(ArtifactPublicationServices publicationServices, Instantiator instantiator, ProjectPublicationRegistry projectPublicationRegistry, FeaturePreviews featurePreviews, DocumentationRegistry documentationRegistry, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
        this.publicationServices = publicationServices;
        this.instantiator = instantiator;
        this.projectPublicationRegistry = projectPublicationRegistry;
        this.featurePreviews = featurePreviews;
        this.documentationRegistry = documentationRegistry;
        this.collectionCallbackActionDecorator = collectionCallbackActionDecorator;
    }

    public void apply(final Project project) {
        RepositoryHandler repositories = this.publicationServices.createRepositoryHandler();
        PublicationContainer publications = (PublicationContainer)this.instantiator.newInstance(DefaultPublicationContainer.class, new Object[]{this.instantiator, this.collectionCallbackActionDecorator});
        PublishingExtension extension = (PublishingExtension)project.getExtensions().create(PublishingExtension.class, PUBLISH_TASK_GROUP, DefaultPublishingExtension.class, new Object[]{repositories, publications});
        project.getTasks().register(PUBLISH_LIFECYCLE_TASK_NAME, (Action)new Action<Task>(){

            public void execute(Task task) {
                task.setDescription("Publishes all publications produced by this project.");
                task.setGroup(PublishingPlugin.PUBLISH_TASK_GROUP);
            }
        });
        extension.getPublications().all((Action)new Action<Publication>(){

            public void execute(Publication publication) {
                PublicationInternal internalPublication = (PublicationInternal)publication;
                ProjectInternal projectInternal = (ProjectInternal)project;
                PublishingPlugin.this.projectPublicationRegistry.registerPublication(projectInternal, (ProjectPublication)internalPublication);
            }
        });
        this.bridgeToSoftwareModelIfNeeded((ProjectInternal)project);
    }

    private void bridgeToSoftwareModelIfNeeded(ProjectInternal project) {
        project.addRuleBasedPluginListener(new RuleBasedPluginListener(){

            public void prepareForRuleBasedPlugins(Project project) {
                project.getPluginManager().apply(PublishingPluginRules.class);
            }
        });
    }
}

