/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.List;
import java.util.Set;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.internal.Describables;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ForcingDependencyMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;

class DependencyState {
    private final ComponentSelector requested;
    private final DependencyMetadata dependency;
    private final List<ComponentSelectionDescriptorInternal> ruleDescriptors;
    private final ComponentSelectorConverter componentSelectorConverter;
    private ModuleIdentifier moduleIdentifier;
    public ModuleVersionResolveException failure;

    DependencyState(DependencyMetadata dependency, ComponentSelectorConverter componentSelectorConverter) {
        this(dependency, dependency.getSelector(), null, componentSelectorConverter);
    }

    private DependencyState(DependencyMetadata dependency, ComponentSelector requested, List<ComponentSelectionDescriptorInternal> ruleDescriptors, ComponentSelectorConverter componentSelectorConverter) {
        this.dependency = dependency;
        this.requested = requested;
        this.ruleDescriptors = ruleDescriptors;
        this.componentSelectorConverter = componentSelectorConverter;
    }

    public ComponentSelector getRequested() {
        return this.requested;
    }

    public DependencyMetadata getDependency() {
        return this.dependency;
    }

    public ModuleIdentifier getModuleIdentifier() {
        if (this.moduleIdentifier == null) {
            this.moduleIdentifier = this.componentSelectorConverter.getModule(this.dependency.getSelector());
        }
        return this.moduleIdentifier;
    }

    public DependencyState withTarget(ComponentSelector target, List<ComponentSelectionDescriptorInternal> ruleDescriptors) {
        DependencyMetadata targeted = this.dependency.withTarget(target);
        return new DependencyState(targeted, this.requested, ruleDescriptors, this.componentSelectorConverter);
    }

    public List<ComponentSelectionDescriptorInternal> getRuleDescriptors() {
        return this.ruleDescriptors;
    }

    public boolean isForced() {
        if (this.ruleDescriptors != null) {
            for (ComponentSelectionDescriptorInternal ruleDescriptor : this.ruleDescriptors) {
                if (!ruleDescriptor.isEquivalentToForce()) continue;
                return true;
            }
        }
        return this.isDependencyForced();
    }

    private boolean isDependencyForced() {
        return this.dependency instanceof ForcingDependencyMetadata && ((ForcingDependencyMetadata)this.dependency).isForce();
    }

    public boolean isFromLock() {
        return this.dependency instanceof LocalOriginDependencyMetadata && ((LocalOriginDependencyMetadata)this.dependency).isFromLock();
    }

    public void addSelectionReasons(Set<ComponentSelectionDescriptorInternal> reasons) {
        ComponentSelectionDescriptorInternal dependencyDescriptor;
        String reason = this.dependency.getReason();
        ComponentSelectionDescriptorInternal componentSelectionDescriptorInternal = dependencyDescriptor = this.dependency.isConstraint() ? ComponentSelectionReasons.CONSTRAINT : ComponentSelectionReasons.REQUESTED;
        if (reason != null) {
            dependencyDescriptor = dependencyDescriptor.withDescription((Describable)Describables.of((Object)reason));
        }
        reasons.add(dependencyDescriptor);
        if (this.ruleDescriptors != null) {
            reasons.addAll(this.ruleDescriptors);
        }
        if (this.isDependencyForced()) {
            reasons.add(ComponentSelectionReasons.FORCED);
        }
    }
}

