/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.connection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.composite.GradleParticipantBuild;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.connection.ModelResult;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.connection.DefaultFailedModelResult;
import org.gradle.tooling.internal.connection.DefaultModelResult;
import org.gradle.tooling.internal.connection.ParticipantConnector;
import org.gradle.tooling.internal.connection.ToolingClientCompositeUtil;
import org.gradle.tooling.internal.consumer.converters.BuildInvocationsConverter;
import org.gradle.tooling.internal.consumer.converters.ConsumerProvidedBuildInvocations;
import org.gradle.tooling.internal.consumer.converters.FixedBuildIdentifierProvider;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.HasGradleProject;
import org.gradle.tooling.model.HierarchicalElement;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.BuildInvocations;
import org.gradle.tooling.model.gradle.ProjectPublications;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolingClientCompositeModelBuilder<T> {
    private static final GradleVersion USE_CUSTOM_MODEL_ACTION_VERSION = GradleVersion.version("1.12");
    private final ConsumerOperationParameters operationParameters;
    private final ToolingClientCompositeUtil util;
    private final Class<T> modelType;
    private final List<CompositeModelResultsBuilder> builders = Lists.newArrayList();
    private final ProtocolToModelAdapter protocolToModelAdapter = new ProtocolToModelAdapter();

    ToolingClientCompositeModelBuilder(Class<T> modelType, ConsumerOperationParameters operationParameters) {
        this.modelType = modelType;
        this.builders.add(new HierarchicalModelResultsBuilder());
        this.builders.add(new BuildInvocationsModelResultsBuilder());
        this.builders.add(new ProjectPublicationsModelResultBuilder());
        this.builders.add(new PerBuildModelResultsBuilder());
        this.util = new ToolingClientCompositeUtil(operationParameters);
        this.operationParameters = operationParameters;
    }

    public Iterable<ModelResult<T>> get() throws GradleConnectionException, IllegalStateException {
        ArrayList<ModelResult<T>> results = Lists.newArrayList();
        for (GradleParticipantBuild participant : this.operationParameters.getBuilds()) {
            ParticipantConnector participantConnector = this.util.createParticipantConnector(participant);
            try {
                List<ModelResult<T>> participantResults = this.buildResultsForParticipant(participantConnector);
                results.addAll(participantResults);
            }
            catch (GradleConnectionException e) {
                results.add(new DefaultFailedModelResult(participantConnector.toBuildIdentifier(), e));
            }
        }
        return results;
    }

    private List<ModelResult<T>> buildResultsForParticipant(ParticipantConnector participant) throws GradleConnectionException {
        for (CompositeModelResultsBuilder builder : this.builders) {
            if (!builder.canBuild(participant)) continue;
            ArrayList participantResults = Lists.newArrayList();
            builder.addModelResults(participant, participantResults);
            return participantResults;
        }
        throw new GradleConnectionException("Not a supported model type for this participant: " + this.modelType.getCanonicalName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FetchPerProjectModelAction<V>
    implements BuildAction<Map<String, V>> {
        private final Class<V> modelType;

        private FetchPerProjectModelAction(Class<V> modelType) {
            this.modelType = modelType;
        }

        @Override
        public Map<String, V> execute(BuildController controller) {
            HashMap results = new HashMap();
            this.fetchResults(this.modelType, results, controller, controller.getBuildModel().getRootProject());
            return results;
        }

        private void fetchResults(Class<V> modelType, Map<String, V> results, BuildController controller, BasicGradleProject project) {
            results.put(project.getPath(), controller.getModel(project, modelType));
            for (BasicGradleProject basicGradleProject : project.getChildren()) {
                this.fetchResults(modelType, results, controller, basicGradleProject);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BuildInvocationsModelResultsBuilder
    extends CustomActionModelResultsBuilder {
        private BuildInvocationsModelResultsBuilder() {
        }

        @Override
        public boolean canBuild(ParticipantConnector participant) {
            return BuildInvocations.class.isAssignableFrom(ToolingClientCompositeModelBuilder.this.modelType);
        }

        @Override
        public void addModelResults(ParticipantConnector participant, List<ModelResult<T>> modelResults) {
            if (this.canUseCustomModelAction(participant)) {
                this.addResultsUsingModelAction(participant, modelResults);
            } else {
                GradleProject rootProject = this.getProjectModel(participant, GradleProject.class);
                this.constructBuildInvocationsFromGradleProject(participant, rootProject, modelResults);
            }
        }

        private void constructBuildInvocationsFromGradleProject(ParticipantConnector participant, GradleProject project, List<ModelResult<T>> results) {
            ConsumerProvidedBuildInvocations buildInvocations = new BuildInvocationsConverter().convertSingleProject(project);
            Object model = this.transform(participant.toProjectIdentifier(project.getPath()), buildInvocations);
            DefaultModelResult result = this.createModelResult(model);
            results.add(result);
            for (GradleProject gradleProject : project.getChildren()) {
                this.constructBuildInvocationsFromGradleProject(participant, gradleProject, results);
            }
        }

        private T transform(ProjectIdentifier projectIdentifier, Object sourceObject) {
            return new FixedBuildIdentifierProvider(projectIdentifier).applyTo(ToolingClientCompositeModelBuilder.this.protocolToModelAdapter.builder(ToolingClientCompositeModelBuilder.this.modelType)).build(sourceObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectPublicationsModelResultBuilder
    extends CustomActionModelResultsBuilder {
        private ProjectPublicationsModelResultBuilder() {
        }

        @Override
        public boolean canBuild(ParticipantConnector participant) {
            return ProjectPublications.class.isAssignableFrom(ToolingClientCompositeModelBuilder.this.modelType) && this.canUseCustomModelAction(participant);
        }

        @Override
        public void addModelResults(ParticipantConnector participant, List<ModelResult<T>> modelResults) {
            this.addResultsUsingModelAction(participant, modelResults);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class CustomActionModelResultsBuilder
    extends CompositeModelResultsBuilder {
        private CustomActionModelResultsBuilder() {
        }

        protected boolean canUseCustomModelAction(ParticipantConnector participant) {
            BuildEnvironment buildEnvironment = this.getProjectModel(participant, BuildEnvironment.class);
            GradleVersion gradleVersion = GradleVersion.version(buildEnvironment.getGradle().getGradleVersion());
            return gradleVersion.compareTo(USE_CUSTOM_MODEL_ACTION_VERSION) >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addResultsUsingModelAction(ParticipantConnector participant, List<ModelResult<T>> results) {
            ProjectConnection projectConnection = participant.connect();
            try {
                BuildActionExecuter actionExecuter = projectConnection.action(new FetchPerProjectModelAction(ToolingClientCompositeModelBuilder.this.modelType));
                ToolingClientCompositeModelBuilder.this.util.configureRequest(actionExecuter);
                Map actionResults = (Map)actionExecuter.run();
                for (String projectPath : actionResults.keySet()) {
                    DefaultModelResult result = this.createModelResult(actionResults.get(projectPath));
                    results.add(result);
                }
            }
            finally {
                projectConnection.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HierarchicalModelResultsBuilder
    extends CompositeModelResultsBuilder {
        private HierarchicalModelResultsBuilder() {
        }

        @Override
        public boolean canBuild(ParticipantConnector participant) {
            return this.hasProjectHierarchy(ToolingClientCompositeModelBuilder.this.modelType);
        }

        private boolean hasProjectHierarchy(Class<T> modelType) {
            return HierarchicalElement.class.isAssignableFrom(modelType) && (GradleProject.class.isAssignableFrom(modelType) || HasGradleProject.class.isAssignableFrom(modelType));
        }

        @Override
        public void addModelResults(ParticipantConnector participant, List<ModelResult<T>> modelResults) {
            this.addResultsFromHierarchicalModel(participant, modelResults);
        }

        private void addResultsFromHierarchicalModel(ParticipantConnector participant, List<ModelResult<T>> results) {
            Object model = this.getProjectModel(participant, ToolingClientCompositeModelBuilder.this.modelType);
            this.addHierarchicalModel(model, results);
        }

        private void addHierarchicalModel(T model, List<ModelResult<T>> results) {
            DefaultModelResult result = this.createModelResult(model);
            results.add(result);
            for (HierarchicalElement hierarchicalElement : ((HierarchicalElement)model).getChildren()) {
                this.addHierarchicalModel(hierarchicalElement, results);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PerBuildModelResultsBuilder
    extends CompositeModelResultsBuilder {
        private PerBuildModelResultsBuilder() {
        }

        @Override
        public boolean canBuild(ParticipantConnector participant) {
            return true;
        }

        @Override
        public void addModelResults(ParticipantConnector participant, List<ModelResult<T>> modelResults) {
            Object model = this.getProjectModel(participant, ToolingClientCompositeModelBuilder.this.modelType);
            modelResults.add(this.createModelResult(model));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class CompositeModelResultsBuilder {
        private CompositeModelResultsBuilder() {
        }

        public abstract boolean canBuild(ParticipantConnector var1);

        public abstract void addModelResults(ParticipantConnector var1, List<ModelResult<T>> var2);

        protected DefaultModelResult<T> createModelResult(T value) {
            return new DefaultModelResult(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <V> V getProjectModel(ParticipantConnector build, Class<V> modelType) throws GradleConnectionException {
            ProjectConnection connection = build.connect();
            try {
                ModelBuilder<V> modelBuilder = connection.model(modelType);
                ToolingClientCompositeModelBuilder.this.util.configureRequest(modelBuilder);
                V v = modelBuilder.get();
                return v;
            }
            finally {
                connection.close();
            }
        }
    }
}

