--[[
Sample plugin file for highlight 3.13
]]

Description="Add developer.gnome.org reference links to HTML, LeTeX, RTF and ODT output of C++ GTK code"

Categories = {"c++", "gtk", "html", "rtf", "latex", "odt" }

-- optional parameter: syntax description
function syntaxUpdate(desc)

  if desc~="C and C++" then
     return
  end
  
  function getURL(token)
     url='http://developer.gnome.org/gtk3/stable/'..token.. '.html'
     
      if (HL_OUTPUT== HL_FORMAT_HTML or HL_OUTPUT == HL_FORMAT_XHTML) then
        return '<a class="hl" target="new" href="' .. url .. '">'.. token .. '</a>'
      elseif (HL_OUTPUT == HL_FORMAT_LATEX) then
	return '\\href{'..url..'}{'..token..'}'
      elseif (HL_OUTPUT == HL_FORMAT_RTF) then
	return '{{\\field{\\*\\fldinst HYPERLINK "'..url..'" }{\\fldrslt\\ul\\ulc0 '..token..'}}}'
      elseif (HL_OUTPUT == HL_FORMAT_ODT) then
	return '<text:a xlink:type="simple" xlink:href="'..url..'">'..token..'</text:a>'
     end
   end

  function Decorate(token, state)

    if (state ~= HL_STANDARD and state ~= HL_KEYWORD) then
      return
    end

    if string.find(token, "Gtk%u%l")==1 then
      return getURL(token)
    end

  end
end


function themeUpdate(desc)
  if (HL_OUTPUT == HL_FORMAT_HTML or HL_OUTPUT == HL_FORMAT_XHTML) then
    Injections[#Injections+1]="a.hl, a.hl:visited {color:inherit;font-weight:inherit;}"
  elseif (HL_OUTPUT==HL_FORMAT_LATEX) then
    Injections[#Injections+1]="\\usepackage[colorlinks=false, pdfborderstyle={/S/U/W 1}]{hyperref}"
  end
end
--The Plugins array assigns code chunks to themes or language definitions.
--The chunks are interpreted after the theme or lang file were parsed,
--so you can refer to elements of these files

Plugins={

  { Type="lang", Chunk=syntaxUpdate },
  { Type="theme", Chunk=themeUpdate },

}
