/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import com.android.dx.io.instructions.FillArrayDataPayloadDecodedInstruction;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.List;

public final class FillArrayNode
extends InsnNode {
    private final Object data;
    private final int size;
    private ArgType elemType;

    public FillArrayNode(int resReg, FillArrayDataPayloadDecodedInstruction payload) {
        super(InsnType.FILL_ARRAY, 0);
        ArgType elType;
        switch (payload.getElementWidthUnit()) {
            case 1: {
                elType = ArgType.unknown(PrimitiveType.BOOLEAN, PrimitiveType.BYTE);
                break;
            }
            case 2: {
                elType = ArgType.unknown(PrimitiveType.SHORT, PrimitiveType.CHAR);
                break;
            }
            case 4: {
                elType = ArgType.unknown(PrimitiveType.INT, PrimitiveType.FLOAT);
                break;
            }
            case 8: {
                elType = ArgType.unknown(PrimitiveType.LONG, PrimitiveType.DOUBLE);
                break;
            }
            default: {
                throw new JadxRuntimeException("Unknown array element width: " + payload.getElementWidthUnit());
            }
        }
        this.setResult(InsnArg.reg(resReg, ArgType.array(elType)));
        this.data = payload.getData();
        this.size = payload.getSize();
        this.elemType = elType;
    }

    public Object getData() {
        return this.data;
    }

    public int getSize() {
        return this.size;
    }

    public ArgType getElementType() {
        return this.elemType;
    }

    public void mergeElementType(DexNode dex, ArgType foundElemType) {
        ArgType r = ArgType.merge(dex, this.elemType, foundElemType);
        if (r != null) {
            this.elemType = r;
        }
    }

    public List<LiteralArg> getLiteralArgs() {
        ArrayList<LiteralArg> list = new ArrayList<LiteralArg>(this.size);
        Object array = this.data;
        if (array instanceof int[]) {
            for (int b : (int[])array) {
                list.add(InsnArg.lit(b, this.elemType));
            }
        } else if (array instanceof byte[]) {
            for (byte b : (byte[])array) {
                list.add(InsnArg.lit(b, this.elemType));
            }
        } else if (array instanceof short[]) {
            for (short b : (short[])array) {
                list.add(InsnArg.lit(b, this.elemType));
            }
        } else if (array instanceof long[]) {
            for (long b : (long[])array) {
                list.add(InsnArg.lit(b, this.elemType));
            }
        } else {
            throw new JadxRuntimeException("Unknown type: " + this.data.getClass() + ", expected: " + this.elemType);
        }
        return list;
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FillArrayNode) || !super.isSame(obj)) {
            return false;
        }
        FillArrayNode other = (FillArrayNode)obj;
        return this.elemType.equals(other.elemType) && this.data == other.data;
    }
}

