/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.BSUtil;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;

public class XtalSymmetry {
    private AtomSetCollection asc;
    private AtomSetCollectionReader acr;
    public SymmetryInterface symmetry;
    private float[] unitCellParams = new float[6];
    private float[] baseUnitCell;
    private float symmetryRange;
    private boolean doCentroidUnitCell;
    private boolean centroidPacked;
    private float packingError;
    private String filterSymop;
    private boolean applySymmetryToBonds = false;
    private int[] latticeCells;
    private Lst<float[]> trajectoryUnitCells;
    private boolean doNormalize = true;
    private boolean doPackUnitCell = false;
    private SymmetryInterface baseSymmetry;
    private SymmetryInterface sym2;
    private float rminx;
    private float rminy;
    private float rminz;
    private float rmaxx;
    private float rmaxy;
    private float rmaxz;
    private final P3 ptOffset = new P3();
    private P3i minXYZ;
    private P3i maxXYZ;
    private P3 minXYZ0;
    private P3 maxXYZ0;
    private boolean checkAll;
    private int bondCount0;
    private int dtype = 3;
    private V3[] unitCellTranslations;
    private int latticeOp;
    private boolean latticeOnly;
    private int noSymmetryCount;
    private int firstAtom;
    private static final int PARTICLE_NONE = 0;
    private static final int PARTICLE_CHAIN = 1;
    private static final int PARTICLE_SYMOP = 2;
    private P3 ptTemp;
    private M3 mTemp;
    private int nVib;

    public XtalSymmetry set(AtomSetCollectionReader atomSetCollectionReader) {
        this.acr = atomSetCollectionReader;
        this.asc = atomSetCollectionReader.asc;
        this.getSymmetry();
        return this;
    }

    SymmetryInterface getSymmetry() {
        return this.symmetry == null ? (this.symmetry = (Symmetry)this.acr.getInterface("org.jmol.symmetry.Symmetry")) : this.symmetry;
    }

    SymmetryInterface setSymmetry(SymmetryInterface symmetryInterface) {
        this.symmetry = symmetryInterface;
        return this.symmetry;
    }

    private void setSymmetryRange(float f) {
        this.symmetryRange = f;
        this.asc.setInfo("symmetryRange", Float.valueOf(f));
    }

    private void setLatticeCells() {
        this.latticeCells = this.acr.latticeCells;
        boolean bl = this.latticeCells[0] <= 555 && this.latticeCells[1] >= 555 && (this.latticeCells[2] == 0 || this.latticeCells[2] == 1 || this.latticeCells[2] == -1);
        this.doNormalize = this.latticeCells[0] != 0 && (!bl || this.latticeCells[2] == 1);
        this.applySymmetryToBonds = this.acr.applySymmetryToBonds;
        this.doPackUnitCell = this.acr.doPackUnitCell;
        this.doCentroidUnitCell = this.acr.doCentroidUnitCell;
        this.centroidPacked = this.acr.centroidPacked;
        this.filterSymop = this.acr.filterSymop;
    }

    private void setUnitCell(float[] fArray, M3 m3, P3 p3) {
        this.unitCellParams = new float[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            this.unitCellParams[n] = fArray[n];
            ++n;
        }
        this.asc.haveUnitCell = true;
        this.asc.setCurrentModelInfo("unitCellParams", this.unitCellParams);
        if (this.asc.isTrajectory) {
            if (this.trajectoryUnitCells == null) {
                this.trajectoryUnitCells = new Lst();
                this.asc.setInfo("unitCells", this.trajectoryUnitCells);
            }
            this.trajectoryUnitCells.addLast(this.unitCellParams);
        }
        this.asc.setGlobalBoolean(2);
        this.getSymmetry().setUnitCell(this.unitCellParams, false);
        if (p3 != null) {
            this.symmetry.setOffsetPt(p3);
            this.asc.setCurrentModelInfo("unitCellOffset", p3);
        }
        if (m3 != null) {
            this.symmetry.initializeOrientation(m3);
            this.asc.setCurrentModelInfo("matUnitCellOrientation", m3);
        }
    }

    int addSpaceGroupOperation(String string, boolean bl) {
        if (bl) {
            this.setLatticeCells();
        }
        this.symmetry.setSpaceGroup(this.doNormalize);
        return this.symmetry.addSpaceGroupOperation(string, 0);
    }

    public void setLatticeParameter(int n) {
        this.symmetry.setSpaceGroup(this.doNormalize);
        this.symmetry.setLattice(n);
    }

    SymmetryInterface applySymmetryFromReader(SymmetryInterface symmetryInterface) throws Exception {
        this.asc.setCoordinatesAreFractional(this.acr.iHaveFractionalCoordinates);
        this.setUnitCell(this.acr.unitCellParams, this.acr.matUnitCellOrientation, this.acr.unitCellOffset);
        this.setAtomSetSpaceGroupName(this.acr.sgName);
        this.setSymmetryRange(this.acr.symmetryRange);
        if (this.acr.doConvertToFractional || this.acr.fileCoordinatesAreFractional) {
            this.setLatticeCells();
            boolean bl = true;
            if (this.acr.ignoreFileSpaceGroupName || !this.acr.iHaveSymmetryOperators) {
                if (!this.acr.merging || symmetryInterface == null) {
                    symmetryInterface = this.acr.getNewSymmetry();
                }
                bl = symmetryInterface.createSpaceGroup(this.acr.desiredSpaceGroupIndex, this.acr.sgName.indexOf("!") >= 0 ? "P1" : this.acr.sgName, this.acr.unitCellParams, this.acr.modDim);
            } else {
                this.acr.doPreSymmetry();
                symmetryInterface = null;
            }
            this.packingError = this.acr.packingError;
            if (bl) {
                if (symmetryInterface != null) {
                    this.setSpaceGroupFrom(symmetryInterface);
                }
                this.applySymmetryLattice();
                if (symmetryInterface != null && this.filterSymop == null) {
                    this.setAtomSetSpaceGroupName(symmetryInterface.getSpaceGroupName());
                }
            }
        }
        if (this.acr.iHaveFractionalCoordinates && this.acr.merging && symmetryInterface != null) {
            Atom[] atomArray = this.asc.atoms;
            int n = this.asc.getLastAtomSetAtomIndex();
            int n2 = this.asc.ac;
            while (n < n2) {
                symmetryInterface.toCartesian(atomArray[n], true);
                ++n;
            }
            this.asc.setCoordinatesAreFractional(false);
            this.acr.addVibrations = false;
        }
        return this.symmetry;
    }

    public void setSpaceGroupFrom(SymmetryInterface symmetryInterface) {
        this.getSymmetry().setSpaceGroupFrom(symmetryInterface);
    }

    private void setAtomSetSpaceGroupName(String string) {
        this.symmetry.setSpaceGroupName(string);
        this.asc.setCurrentModelInfo("spaceGroup", String.valueOf(string));
    }

    private void applySymmetryLattice() throws Exception {
        int n;
        Object object;
        boolean bl;
        T3[] t3Array;
        if (!this.asc.coordinatesAreFractional || this.symmetry.getSpaceGroup() == null) {
            return;
        }
        this.sym2 = null;
        int n2 = this.latticeCells[0];
        int n3 = this.latticeCells[1];
        int n4 = Math.abs(this.latticeCells[2]);
        int n5 = this.latticeCells[3];
        int n6 = (int)this.symmetry.getUnitCellInfoType(6);
        this.firstAtom = this.asc.getLastAtomSetAtomIndex();
        BS bS = this.asc.bsAtoms;
        if (bS != null) {
            this.updateBSAtoms();
            this.firstAtom = bS.nextSetBit(this.firstAtom);
        }
        this.rminz = Float.MAX_VALUE;
        this.rminy = Float.MAX_VALUE;
        this.rminx = Float.MAX_VALUE;
        this.rmaxz = -3.4028235E38f;
        this.rmaxy = -3.4028235E38f;
        this.rmaxx = -3.4028235E38f;
        P3 p3 = null;
        if (this.acr.latticeType == null) {
            this.acr.latticeType = this.symmetry.getLatticeType();
        }
        if (this.acr.isPrimitive) {
            this.asc.setCurrentModelInfo("isprimitive", Boolean.TRUE);
            if (!"P".equals(this.acr.latticeType) || this.acr.primitiveToCrystal != null) {
                this.asc.setCurrentModelInfo("unitcell_conventional", this.symmetry.getConventionalUnitCell(this.acr.latticeType, this.acr.primitiveToCrystal));
            }
        }
        if (this.acr.latticeType != null) {
            this.asc.setCurrentModelInfo("latticeType", this.acr.latticeType);
            if (this.acr.fillRange instanceof String) {
                t3Array = (T3[])this.acr.fillRange;
                if (t3Array.equals("conventional")) {
                    this.acr.fillRange = this.symmetry.getConventionalUnitCell(this.acr.latticeType, this.acr.primitiveToCrystal);
                } else if (t3Array.equals("primitive")) {
                    this.acr.fillRange = this.symmetry.getUnitCellVectors();
                    this.symmetry.toFromPrimitive(true, this.acr.latticeType.charAt(0), (T3[])this.acr.fillRange, this.acr.primitiveToCrystal);
                } else {
                    this.acr.fillRange = null;
                }
                if (this.acr.fillRange != null) {
                    this.acr.addJmolScript("unitcell " + (String)t3Array);
                }
            }
        }
        if (this.acr.fillRange != null) {
            bS = this.updateBSAtoms();
            this.acr.forcePacked = true;
            this.doPackUnitCell = false;
            this.minXYZ = new P3i();
            this.maxXYZ = P3i.new3(1, 1, 1);
            t3Array = new P3[4];
            int n7 = 0;
            while (n7 < 4) {
                t3Array[n7] = P3.newP(((T3[])this.acr.fillRange)[n7]);
                ++n7;
            }
            this.adjustRangeMinMax(t3Array);
            if (this.sym2 == null) {
                this.sym2 = new Symmetry();
                this.sym2.getUnitCell((T3[])this.acr.fillRange, false, null);
            }
            this.applyAllSymmetry(this.acr.ms, bS);
            p3 = new P3();
            Atom[] atomArray = this.asc.atoms;
            int n8 = this.asc.ac;
            while (--n8 >= this.firstAtom) {
                p3.setT(atomArray[n8]);
                this.symmetry.toCartesian(p3, false);
                this.sym2.toFractional(p3, false);
                if (this.acr.fixJavaFloat) {
                    PT.fixPtFloats(p3, 100000.0f);
                }
                if (this.isWithinCell(this.dtype, p3, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, this.packingError)) continue;
                bS.clear(n8);
            }
            return;
        }
        t3Array = null;
        this.nVib = 0;
        P3 p32 = null;
        P3 p33 = null;
        P3 p34 = null;
        this.baseSymmetry = this.symmetry;
        String string = this.acr.strSupercell;
        T3[] t3Array2 = null;
        boolean bl2 = bl = string != null && string.indexOf(",") >= 0;
        if (bl && (t3Array2 = this.symmetry.getV0abc(string)) != null) {
            this.minXYZ = new P3i();
            this.maxXYZ = P3i.new3(n2, n3, n4);
            SimpleUnitCell.setMinMaxLatticeParameters(n6, this.minXYZ, this.maxXYZ, n5);
            p3 = P3.newP(t3Array2[0]);
            p32 = P3.newP(t3Array2[1]);
            p33 = P3.newP(t3Array2[2]);
            p34 = P3.newP(t3Array2[3]);
            this.adjustRangeMinMax(t3Array2);
        }
        int n9 = this.asc.getLastAtomSetAtomIndex();
        if (bS != null) {
            n9 = bS.nextSetBit(n9);
        }
        if (this.rminx == Float.MAX_VALUE) {
            string = null;
            t3Array2 = null;
        } else {
            boolean bl3;
            this.doPackUnitCell = bl3 = this.doPackUnitCell;
            bS = this.updateBSAtoms();
            this.applyAllSymmetry(this.acr.ms, null);
            this.doPackUnitCell = bl3;
            object = this.asc.atoms;
            n = this.asc.ac;
            int n10 = n9;
            while (n10 < n) {
                this.symmetry.toCartesian(object[n10], true);
                bS.set(n10);
                ++n10;
            }
            this.symmetry = null;
            this.symmetry = this.getSymmetry();
            this.setUnitCell(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, p32.x, p32.y, p32.z, p33.x, p33.y, p33.z, p34.x, p34.y, p34.z}, null, (P3)t3Array);
            this.setAtomSetSpaceGroupName(t3Array2 == null || string == null ? "P1" : "cell=" + string);
            this.symmetry.setSpaceGroup(this.doNormalize);
            this.symmetry.addSpaceGroupOperation("x,y,z", 0);
            if (p3 != null) {
                this.symmetry.toFractional(p3, true);
            }
            n10 = n9;
            while (n10 < n) {
                this.symmetry.toFractional((T3)object[n10], true);
                if (p3 != null) {
                    ((T3)object[n10]).sub(p3);
                }
                ++n10;
            }
            this.asc.haveAnisou = false;
            this.asc.setCurrentModelInfo("matUnitCellOrientation", null);
        }
        this.minXYZ = new P3i();
        this.maxXYZ = P3i.new3(n2, n3, n4);
        SimpleUnitCell.setMinMaxLatticeParameters(n6, this.minXYZ, this.maxXYZ, n5);
        if (t3Array2 == null) {
            this.applyAllSymmetry(this.acr.ms, bS);
            return;
        }
        if (this.acr.forcePacked || this.doPackUnitCell) {
            Atom[] atomArray = this.asc.atoms;
            object = this.updateBSAtoms();
            n = ((BS)object).nextSetBit(n9);
            while (n >= 0) {
                if (!this.isWithinCell(this.dtype, atomArray[n], this.minXYZ.x, this.maxXYZ.x, this.minXYZ.y, this.maxXYZ.y, this.minXYZ.z, this.maxXYZ.z, this.packingError)) {
                    ((BS)object).clear(n);
                }
                n = ((BS)object).nextSetBit(n + 1);
            }
        }
    }

    private BS updateBSAtoms() {
        BS bS = this.asc.bsAtoms;
        if (bS == null) {
            bS = this.asc.bsAtoms = BSUtil.newBitSet2(0, this.asc.ac);
        }
        if (bS.nextSetBit(this.firstAtom) < 0) {
            bS.setBits(this.firstAtom, this.asc.ac);
        }
        return bS;
    }

    private void adjustRangeMinMax(T3[] t3Array) {
        P3 p3 = new P3();
        P3 p32 = new P3();
        P3 p33 = new P3();
        if (this.acr.forcePacked) {
            p3.setT(t3Array[1]);
            p32.setT(t3Array[2]);
            p33.setT(t3Array[3]);
            p3.scale(this.packingError);
            p32.scale(this.packingError);
            p33.scale(this.packingError);
        }
        t3Array[0].scaleAdd2(this.minXYZ.x, t3Array[1], t3Array[0]);
        t3Array[0].scaleAdd2(this.minXYZ.y, t3Array[2], t3Array[0]);
        t3Array[0].scaleAdd2(this.minXYZ.z, t3Array[3], t3Array[0]);
        t3Array[0].sub(p3);
        t3Array[0].sub(p32);
        t3Array[0].sub(p33);
        P3 p34 = P3.newP(t3Array[0]);
        this.symmetry.toFractional(p34, true);
        this.setSymmetryMinMax(p34);
        t3Array[1].scale(this.maxXYZ.x - this.minXYZ.x);
        t3Array[2].scale(this.maxXYZ.y - this.minXYZ.y);
        t3Array[3].scale(this.maxXYZ.z - this.minXYZ.z);
        t3Array[1].scaleAdd2(2.0f, p3, t3Array[1]);
        t3Array[2].scaleAdd2(2.0f, p32, t3Array[2]);
        t3Array[3].scaleAdd2(2.0f, p33, t3Array[3]);
        int n = 0;
        while (n < 3) {
            int n2 = n + 1;
            while (n2 < 4) {
                p34.add2(t3Array[n], t3Array[n2]);
                if (n != 0) {
                    p34.add(t3Array[0]);
                }
                this.symmetry.toFractional(p34, false);
                this.setSymmetryMinMax(p34);
                ++n2;
            }
            ++n;
        }
        this.symmetry.toCartesian(p34, false);
        p34.add(t3Array[1]);
        this.symmetry.toFractional(p34, false);
        this.setSymmetryMinMax(p34);
        this.minXYZ = P3i.new3((int)Math.min(0.0, Math.floor(this.rminx + 0.001f)), (int)Math.min(0.0, Math.floor(this.rminy + 0.001f)), (int)Math.min(0.0, Math.floor(this.rminz + 0.001f)));
        this.maxXYZ = P3i.new3((int)Math.max(1.0, Math.ceil(this.rmaxx - 0.001f)), (int)Math.max(1.0, Math.ceil(this.rmaxy - 0.001f)), (int)Math.max(1.0, Math.ceil(this.rmaxz - 0.001f)));
    }

    private void setSymmetryMinMax(P3 p3) {
        if (this.rminx > p3.x) {
            this.rminx = p3.x;
        }
        if (this.rminy > p3.y) {
            this.rminy = p3.y;
        }
        if (this.rminz > p3.z) {
            this.rminz = p3.z;
        }
        if (this.rmaxx < p3.x) {
            this.rmaxx = p3.x;
        }
        if (this.rmaxy < p3.y) {
            this.rmaxy = p3.y;
        }
        if (this.rmaxz < p3.z) {
            this.rmaxz = p3.z;
        }
    }

    public boolean isWithinCell(int n, P3 p3, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        return p3.x > f - f7 && p3.x < f2 + f7 && (n < 2 || p3.y > f3 - f7 && p3.y < f4 + f7) && (n < 3 || p3.z > f5 - f7 && p3.z < f6 + f7);
    }

    /*
     * Unable to fully structure code
     */
    private void applyAllSymmetry(MSInterface var1_1, BS var2_2) throws Exception {
        if (this.asc.ac == 0 || var2_2 != null && var2_2.isEmpty()) {
            return;
        }
        this.noSymmetryCount = this.asc.baseSymmetryAtomCount > 0 ? this.asc.baseSymmetryAtomCount : (var2_2 == null ? this.asc.getLastAtomSetAtomCount() : this.asc.ac - var2_2.nextSetBit(this.asc.getLastAtomSetAtomIndex()));
        var3_3 = this.noSymmetryCount;
        this.asc.setTensors();
        this.bondCount0 = this.asc.bondCount;
        this.finalizeSymmetry(this.symmetry);
        var4_4 = this.symmetry.getSpaceGroupOperationCount();
        v0 = var5_5 = this.acr.thisBiomolecule == null ? null : new BS();
        if (var5_5 != null) {
            this.asc.checkSpecial = true;
        }
        this.dtype = (int)this.symmetry.getUnitCellInfoType(6);
        SimpleUnitCell.setMinMaxLatticeParameters(this.dtype, this.minXYZ, this.maxXYZ, 0);
        this.latticeOp = this.symmetry.getLatticeOp();
        v1 = this.latticeOnly = this.asc.checkLatticeOnly != false && this.latticeOp >= 0;
        if (this.doCentroidUnitCell) {
            this.asc.setInfo("centroidMinMax", new int[]{this.minXYZ.x, this.minXYZ.y, this.minXYZ.z, this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z, this.centroidPacked != false ? 1 : 0});
        }
        if (this.doCentroidUnitCell || this.doPackUnitCell || this.symmetryRange != 0.0f && this.maxXYZ.x - this.minXYZ.x == 1 && this.maxXYZ.y - this.minXYZ.y == 1 && this.maxXYZ.z - this.minXYZ.z == 1) {
            this.minXYZ0 = P3.new3(this.minXYZ.x, this.minXYZ.y, this.minXYZ.z);
            this.maxXYZ0 = P3.new3(this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z);
            if (var1_1 != null) {
                var1_1.setMinMax0(this.minXYZ0, this.maxXYZ0);
                this.minXYZ.set((int)this.minXYZ0.x, (int)this.minXYZ0.y, (int)this.minXYZ0.z);
                this.maxXYZ.set((int)this.maxXYZ0.x, (int)this.maxXYZ0.y, (int)this.maxXYZ0.z);
            }
            switch (this.dtype) {
                case 3: {
                    this.minXYZ.z = this.minXYZ.z - 1;
                    this.maxXYZ.z = this.maxXYZ.z + 1;
                }
                case 2: {
                    this.minXYZ.y = this.minXYZ.y - 1;
                    this.maxXYZ.y = this.maxXYZ.y + 1;
                }
                case 1: {
                    this.minXYZ.x = this.minXYZ.x - 1;
                    this.maxXYZ.x = this.maxXYZ.x + 1;
                }
            }
        }
        var6_6 = (this.maxXYZ.x - this.minXYZ.x) * (this.maxXYZ.y - this.minXYZ.y) * (this.maxXYZ.z - this.minXYZ.z);
        var7_7 = var3_3 * (this.latticeOnly != false ? 4 : var4_4);
        var8_8 = this.asc.checkSpecial != false || this.acr.thisBiomolecule != null ? var7_7 * var6_6 : (this.symmetryRange > 0.0f ? var7_7 : 1);
        var9_9 = new P3[var8_8];
        var10_10 = this.asc.atoms;
        var11_11 = 0;
        while (var11_11 < var3_3) {
            var10_10[this.firstAtom + var11_11].bsSymmetry = BS.newN(var4_4 * (var6_6 + 1));
            ++var11_11;
        }
        var11_11 = 0;
        var12_12 = new int[var6_6];
        this.unitCellTranslations = new V3[var6_6];
        var13_13 = 0;
        var14_14 = 0;
        var15_15 = Math.abs(this.symmetryRange);
        var16_16 = this.symmetryRange != 0.0f;
        var17_17 = this.symmetryRange < 0.0f;
        v2 = var18_18 = this.symmetryRange > 0.0f;
        if (var16_16) {
            this.rminz = 3.4028235E38f;
            this.rminy = 3.4028235E38f;
            this.rminx = 3.4028235E38f;
            this.rmaxz = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxx = -3.4028235E38f;
        }
        var20_20 = var19_19 = this.symmetry;
        this.checkAll = this.latticeOnly != false || this.asc.atomSetCount == 1 && this.asc.checkSpecial != false && this.latticeOp >= 0;
        var21_21 = null;
        var22_22 = var19_19.getSpaceGroupOperation(0);
        if (this.doPackUnitCell) {
            var21_21 = new P3();
            this.ptOffset.set(0.0f, 0.0f, 0.0f);
        }
        var23_23 = this.bondCount0 > this.asc.bondIndex0 && this.applySymmetryToBonds != false ? new int[var3_3] : null;
        var24_24 = this.acr.lstNCS;
        if (var24_24 != null && ((M4)var24_24.get((int)0)).m33 == 0.0f) {
            var25_25 = var19_19.getSpaceGroupOperationCount();
            var27_27 = var26_26 = var24_24.size();
            while (--var27_27 >= 0) {
                var28_28 = (M4)var24_24.get(var27_27);
                var28_28.m33 = 1.0f;
                var19_19.toFractionalM((M4)var28_28);
            }
            var27_27 = 1;
            while (var27_27 < var25_25) {
                var28_28 = var19_19.getSpaceGroupOperation(var27_27);
                var29_29 = 0;
                while (var29_29 < var26_26) {
                    var30_32 = M4.newM4((M4)var24_24.get(var29_29));
                    var30_32.mul2((M4)var28_28, var30_32);
                    if (this.doNormalize) {
                        SymmetryOperation.setOffset(var30_32, var10_10, this.firstAtom, this.noSymmetryCount);
                    }
                    var24_24.addLast(var30_32);
                    ++var29_29;
                }
                ++var27_27;
            }
        }
        var25_25 = this.minXYZ.x;
        while (var25_25 < this.maxXYZ.x) {
            var26_26 = this.minXYZ.y;
            while (var26_26 < this.maxXYZ.y) {
                var27_27 = this.minXYZ.z;
                while (var27_27 < this.maxXYZ.z) {
                    block37: {
                        this.unitCellTranslations[var13_13] = V3.new3(var25_25, var26_26, var27_27);
                        var12_12[var13_13++] = 555 + var25_25 * 100 + var26_26 * 10 + var27_27;
                        if (var25_25 != 0 || var26_26 != 0 || var27_27 != 0 || var9_9.length == 0) break block37;
                        var11_11 = 0;
                        while (var11_11 < var3_3) {
                            block38: {
                                var28_28 = var10_10[this.firstAtom + var11_11];
                                if (var1_1 != null && (var19_19 = var1_1.getAtomSymmetry((Atom)var28_28, this.symmetry)) != var20_20) {
                                    if (var19_19.getSpaceGroupOperationCount() == 0) {
                                        var20_20 = var19_19;
                                        this.finalizeSymmetry(var20_20);
                                    }
                                    var22_22 = var19_19.getSpaceGroupOperation(0);
                                }
                                var29_31 = P3.newP((T3)var28_28);
                                var22_22.rotTrans(var29_31);
                                var19_19.toCartesian(var29_31, false);
                                if (!this.doPackUnitCell) ** GOTO lbl127
                                var19_19.toUnitCell(var29_31, this.ptOffset);
                                var21_21.setT(var29_31);
                                var19_19.toFractional(var21_21, false);
                                if (this.acr.fixJavaFloat) {
                                    PT.fixPtFloats(var21_21, 100000.0f);
                                }
                                if (var2_2 != null) break block38;
                                var28_28.setT(var21_21);
                                ** GOTO lbl127
                            }
                            if (!(var28_28.distance(var21_21) < 1.0E-4f)) {
                                var2_2.clear(var28_28.index);
                            } else {
                                var2_2.set(var28_28.index);
lbl127:
                                // 3 sources

                                if (var2_2 != null) {
                                    var28_28.bsSymmetry.clearAll();
                                }
                                var28_28.bsSymmetry.set(var13_13 * var4_4);
                                var28_28.bsSymmetry.set(0);
                                if (var16_16) {
                                    this.setSymmetryMinMax(var29_31);
                                }
                                if (var11_11 < var8_8) {
                                    var9_9[var11_11] = var29_31;
                                }
                            }
                            ++var11_11;
                        }
                        if (var17_17) {
                            this.rminx -= var15_15;
                            this.rminy -= var15_15;
                            this.rminz -= var15_15;
                            this.rmaxx += var15_15;
                            this.rmaxy += var15_15;
                            this.rmaxz += var15_15;
                        }
                        var14_14 = var11_11 = this.symmetryAddAtoms(0, 0, 0, 0, var11_11, var13_13 * var4_4, var9_9, var1_1, var5_5, var23_23);
                    }
                    ++var27_27;
                }
                ++var26_26;
            }
            ++var25_25;
        }
        if (var18_18) {
            this.rminx -= var15_15;
            this.rminy -= var15_15;
            this.rminz -= var15_15;
            this.rmaxx += var15_15;
            this.rmaxy += var15_15;
            this.rmaxz += var15_15;
        }
        var13_13 = 0;
        var25_25 = this.minXYZ.x;
        while (var25_25 < this.maxXYZ.x) {
            var26_26 = this.minXYZ.y;
            while (var26_26 < this.maxXYZ.y) {
                var27_27 = this.minXYZ.z;
                while (var27_27 < this.maxXYZ.z) {
                    ++var13_13;
                    if (var25_25 != 0 || var26_26 != 0 || var27_27 != 0) {
                        var11_11 = this.symmetryAddAtoms(var25_25, var26_26, var27_27, var14_14, var11_11, var13_13 * var4_4, var9_9, var1_1, var5_5, var23_23);
                    }
                    ++var27_27;
                }
                ++var26_26;
            }
            ++var25_25;
        }
        if (var13_13 * var3_3 == this.asc.ac - this.firstAtom) {
            this.duplicateAtomProperties(var13_13);
        }
        this.setSymmetryOps();
        this.asc.setCurrentModelInfo("presymmetryAtomIndex", this.firstAtom);
        this.asc.setCurrentModelInfo("presymmetryAtomCount", var3_3);
        this.asc.setCurrentModelInfo("latticeDesignation", var19_19.getLatticeDesignation());
        this.asc.setCurrentModelInfo("unitCellRange", var12_12);
        this.asc.setCurrentModelInfo("unitCellTranslations", this.unitCellTranslations);
        this.baseUnitCell = this.unitCellParams;
        this.unitCellParams = new float[6];
        this.reset();
    }

    private int symmetryAddAtoms(int n, int n2, int n3, int n4, int n5, int n6, P3[] p3Array, MSInterface mSInterface, BS bS, int[] nArray) throws Exception {
        boolean bl;
        boolean bl2 = n4 == 0;
        boolean bl3 = bl = nArray != null;
        if (this.doPackUnitCell) {
            this.ptOffset.set(n, n2, n3);
        }
        float f = this.symmetryRange * this.symmetryRange;
        boolean bl4 = this.symmetryRange < 0.0f;
        boolean bl5 = this.symmetryRange > 0.0f;
        boolean bl6 = bl2 && bl5;
        bl5 &= !bl2;
        int n7 = this.symmetry.getSpaceGroupOperationCount();
        Lst<M4> lst = this.acr.lstNCS;
        int n8 = lst == null ? 0 : lst.size();
        int n9 = n7 + n8;
        n8 /= n7;
        boolean bl7 = n9 == 1 && !this.doPackUnitCell ? false : this.asc.checkSpecial;
        boolean bl8 = bl4 || bl5;
        boolean bl9 = bl7 || bl8;
        boolean bl10 = bS != null;
        boolean bl11 = bl7 || bl6;
        BS bS2 = this.acr.isMolecular ? null : this.asc.bsAtoms;
        SymmetryInterface symmetryInterface = this.symmetry;
        if (bl4) {
            n4 = this.noSymmetryCount;
        }
        int n10 = this.firstAtom + this.noSymmetryCount;
        P3 p3 = new P3();
        String string = null;
        float f2 = bl10 ? 0.01f : 1.0E-4f;
        char c = '\u0000';
        int n11 = bS2 == null ? this.firstAtom : bS2.nextSetBit(this.firstAtom);
        int n12 = 0;
        while (n12 < n9) {
            block36: {
                int n13;
                Object object;
                Atom[] atomArray;
                if (bl2 && n12 == 0 || this.latticeOnly && n12 > 0 && n12 % this.latticeOp != 0 || bS != null && bS.get(n12)) break block36;
                int n14 = this.firstAtom + (bl7 || bS != null ? n5 : (bl5 ? n4 : 0));
                float f3 = n12 >= n7 ? 0.0f : (this.asc.vibScale == 0 ? symmetryInterface.getSpinOp(n12) : (float)this.asc.vibScale);
                int n15 = Math.max(this.firstAtom, bS2 == null ? 0 : bS2.nextSetBit(0));
                boolean bl12 = bl9;
                int n16 = n12 >= n7 ? (n12 - n7) / n8 : n12;
                int n17 = n16 + n6;
                int n18 = n15;
                while (n18 < n10) {
                    block37: {
                        Object object2;
                        P3 p32;
                        block39: {
                            block38: {
                                atomArray = this.asc.atoms[n18];
                                if (atomArray.ignoreSymmetry || bS2 != null && !bS2.get(n18)) break block37;
                                if (mSInterface == null) {
                                    symmetryInterface.newSpaceGroupPoint(n12, (P3)atomArray, p3, n, n2, n3, n12 >= n7 ? (M4)lst.get(n12 - n7) : null);
                                } else {
                                    symmetryInterface = mSInterface.getAtomSymmetry((Atom)atomArray, this.symmetry);
                                    symmetryInterface.newSpaceGroupPoint(n12, (P3)atomArray, p3, n, n2, n3, null);
                                    string = symmetryInterface.getSpaceGroupOperationCode(n12);
                                    if (string != null) {
                                        c = string.charAt(0);
                                        symmetryInterface = mSInterface.getSymmetryFromCode(string);
                                        if (symmetryInterface.getSpaceGroupOperationCount() == 0) {
                                            this.finalizeSymmetry(symmetryInterface);
                                        }
                                    }
                                }
                                if (this.acr.fixJavaFloat) {
                                    PT.fixPtFloats(p3, 100000.0f);
                                }
                                p32 = P3.newP(p3);
                                symmetryInterface.toCartesian(p32, false);
                                if (!this.doPackUnitCell) break block38;
                                symmetryInterface.toUnitCell(p32, this.ptOffset);
                                p3.setT(p32);
                                symmetryInterface.toFractional(p3, false);
                                if (this.acr.fixJavaFloat) {
                                    PT.fixPtFloats(p3, 100000.0f);
                                }
                                if (!this.isWithinCell(this.dtype, p3, this.minXYZ0.x, this.maxXYZ0.x, this.minXYZ0.y, this.maxXYZ0.y, this.minXYZ0.z, this.maxXYZ0.z, this.packingError)) break block37;
                            }
                            if (bl6) {
                                this.setSymmetryMinMax(p32);
                            }
                            object = null;
                            if (!bl12) break block39;
                            if (bl8 && (p32.x < this.rminx || p32.y < this.rminy || p32.z < this.rminz || p32.x > this.rmaxx || p32.y > this.rmaxy || p32.z > this.rmaxz)) break block37;
                            float f4 = Float.MAX_VALUE;
                            int n19 = this.checkAll ? this.asc.ac : n14;
                            object2 = atomArray.atomName;
                            n13 = string == null ? atomArray.altLoc : c;
                            int n20 = n11;
                            while (n20 < n19) {
                                P3 p33;
                                if ((bS2 == null || bS2.get(n20)) && (p33 = p3Array[n20 - this.firstAtom]) != null) {
                                    float f5 = p32.distanceSquared(p33);
                                    if (bl7 && f5 < f2) {
                                        if (bl10) {
                                            bS.set(n12);
                                            break block36;
                                        }
                                        object = this.asc.atoms[n20];
                                        if ((((Atom)object).atomName == null || ((Atom)object).atomName.equals(object2)) && ((Atom)object).altLoc == n13) break;
                                        object = null;
                                    }
                                    if (bl5 && n20 < n4 && f5 < f4) {
                                        f4 = f5;
                                    }
                                }
                                ++n20;
                            }
                            if (bl5 && f4 > f) break block37;
                        }
                        if (bl10) {
                            bl12 = false;
                        }
                        int n21 = atomArray.atomSite;
                        if (object != null) {
                            if (bl) {
                                nArray[n21] = ((Atom)object).index;
                            }
                            ((Atom)object).bsSymmetry.set(n17);
                            ((Atom)object).bsSymmetry.set(n16);
                        } else {
                            if (bl) {
                                nArray[n21] = this.asc.ac;
                            }
                            Atom atom = this.asc.newCloneAtom((Atom)atomArray);
                            atom.setT(p3);
                            if (this.asc.bsAtoms != null) {
                                this.asc.bsAtoms.set(atom.index);
                            }
                            if (f3 != 0.0f && atom.vib != null) {
                                symmetryInterface.getSpaceGroupOperation(n12).rotate(atom.vib);
                                atom.vib.scale(f3);
                            }
                            atom.atomSite = n21;
                            if (string != null) {
                                atom.altLoc = c;
                            }
                            atom.bsSymmetry = BSUtil.newAndSetBit(n17);
                            atom.bsSymmetry.set(n16);
                            if (bl11) {
                                p3Array[n5++] = p32;
                            }
                            if ((object2 = atomArray.tensors) != null) {
                                atom.tensors = null;
                                n13 = ((ArrayList)object2).size();
                                while (--n13 >= 0) {
                                    Tensor tensor = (Tensor)((ArrayList)object2).get(n13);
                                    if (tensor == null) continue;
                                    if (n7 == 1) {
                                        atom.addTensor(tensor.copyTensor(), null, false);
                                        continue;
                                    }
                                    this.addRotatedTensor(atom, tensor, n12, false, symmetryInterface);
                                }
                            }
                        }
                    }
                    ++n18;
                }
                if (bl) {
                    Bond[] bondArray = this.asc.bonds;
                    atomArray = this.asc.atoms;
                    int n22 = this.asc.bondIndex0;
                    while (n22 < this.bondCount0) {
                        object = bondArray[n22];
                        Atom atom = atomArray[((Bond)object).atomIndex1];
                        Atom atom2 = atomArray[((Bond)object).atomIndex2];
                        if (atom != null && atom2 != null) {
                            int n23 = nArray[atom.atomSite];
                            n13 = nArray[atom2.atomSite];
                            if (n23 >= n10 || n13 >= n10) {
                                this.asc.addNewBondWithOrder(n23, n13, ((Bond)object).order);
                            }
                        }
                        ++n22;
                    }
                }
            }
            ++n12;
        }
        return n5;
    }

    private void duplicateAtomProperties(int n) {
        Map map = (Map)this.asc.getAtomSetAuxiliaryInfoValue(-1, "atomProperties");
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                int n2;
                Object object;
                Object object2;
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                if (v instanceof String) {
                    object2 = (String)v;
                    object = new SB();
                    n2 = n;
                    while (--n2 >= 0) {
                        ((SB)object).append((String)object2);
                    }
                    map.put(string, ((SB)object).toString());
                    continue;
                }
                object2 = (float[])v;
                object = new float[((Object)object2).length * n];
                n2 = n;
                while (--n2 >= 0) {
                    System.arraycopy(object2, 0, object, n2 * ((Object)object2).length, ((Object)object2).length);
                }
            }
        }
    }

    private void finalizeSymmetry(SymmetryInterface symmetryInterface) {
        String string = (String)this.asc.getAtomSetAuxiliaryInfoValue(-1, "spaceGroup");
        symmetryInterface.setFinalOperations(string, this.asc.atoms, this.firstAtom, this.noSymmetryCount, this.doNormalize, this.filterSymop);
        if (this.filterSymop != null || string == null || string.equals("unspecified!")) {
            this.setAtomSetSpaceGroupName(symmetryInterface.getSpaceGroupName());
        }
    }

    private void setSymmetryOps() {
        int n = this.symmetry.getSpaceGroupOperationCount();
        if (n > 0) {
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = this.symmetry.getSpaceGroupXyz(n2, this.doNormalize);
                ++n2;
            }
            this.asc.setCurrentModelInfo("symmetryOperations", stringArray);
            this.asc.setCurrentModelInfo("symmetryOps", this.symmetry.getSymmetryOperations());
        }
        this.asc.setCurrentModelInfo("symmetryCount", n);
        this.asc.setCurrentModelInfo("latticeType", this.acr.latticeType == null ? "P" : this.acr.latticeType);
        this.asc.setCurrentModelInfo("intlTableNo", this.symmetry.getIntTableNumber());
        if (this.acr.sgName == null || this.acr.sgName.indexOf("?") >= 0 || this.acr.sgName.indexOf("!") >= 0) {
            this.acr.sgName = this.symmetry.getSpaceGroupName();
            this.setAtomSetSpaceGroupName(this.acr.sgName);
        }
    }

    public T3 getOverallSpan() {
        return this.maxXYZ0 == null ? V3.new3(this.maxXYZ.x - this.minXYZ.x, this.maxXYZ.y - this.minXYZ.y, this.maxXYZ.z - this.minXYZ.z) : V3.newVsub(this.maxXYZ0, this.minXYZ0);
    }

    /*
     * WARNING - void declaration
     */
    public void applySymmetryBio(Map<String, Object> map, boolean bl, String string) {
        void var16_25;
        Object object;
        String string2;
        int n;
        int[] nArray;
        Lst lst = (Lst)map.get("biomts");
        if (lst.size() < 2) {
            return;
        }
        this.acr.lstNCS = null;
        this.setLatticeCells();
        int[] nArray2 = nArray = this.latticeCells != null && this.latticeCells[0] != 0 ? new int[3] : null;
        if (nArray != null) {
            n = 0;
            while (n < 3) {
                nArray[n] = this.latticeCells[n];
                ++n;
            }
        }
        this.latticeCells = null;
        n = string.indexOf("BYCHAIN") >= 0 ? 1 : (string.indexOf("BYSYMOP") >= 0 ? 2 : 0);
        this.doNormalize = false;
        Lst lst2 = (Lst)map.get("chains");
        if (((String)lst2.get(0)).equals(lst2.get(1))) {
            lst2 = null;
        }
        this.symmetry = null;
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        this.addSpaceGroupOperation("x,y,z", false);
        this.acr.sgName = string2 = (String)map.get("name");
        this.setAtomSetSpaceGroupName(this.acr.sgName);
        int n2 = lst.size();
        this.applySymmetryToBonds = bl;
        this.bondCount0 = this.asc.bondCount;
        this.firstAtom = this.asc.getLastAtomSetAtomIndex();
        int n3 = this.asc.ac;
        Hashtable<Integer, BS> hashtable = new Hashtable<Integer, BS>();
        int n4 = 0;
        Atom[] atomArray = this.asc.atoms;
        boolean bl2 = this.bondCount0 > this.asc.bondIndex0 && bl;
        switch (n) {
            case 1: {
                int n5 = n3;
                while (--n5 >= this.firstAtom) {
                    Integer object22 = atomArray[n5].chainID;
                    Object object2 = (BS)hashtable.get(object22);
                    if (object2 == null) {
                        ++n4;
                        object2 = new BS();
                        hashtable.put(object22, (BS)object2);
                    }
                    ((BS)object2).set(n5);
                }
                this.asc.bsAtoms = new BS();
                n5 = 0;
                while (n5 < n4) {
                    this.asc.bsAtoms.set(n3 + n5);
                    Atom bS = new Atom();
                    bS.set(0.0f, 0.0f, 0.0f);
                    bS.radius = 16.0f;
                    this.asc.addAtom(bS);
                    ++n5;
                }
                n5 = 0;
                for (Map.Entry entry : hashtable.entrySet()) {
                    Atom atom = atomArray[n3 + n5++];
                    object = (BS)entry.getValue();
                    int n6 = ((BS)object).nextSetBit(0);
                    while (n6 >= 0) {
                        atom.add(atomArray[n6]);
                        n6 = ((BS)object).nextSetBit(n6 + 1);
                    }
                    atom.scale(1.0f / (float)((BS)object).cardinality());
                    atom.atomName = "Pt" + n5;
                    atom.chainID = (Integer)entry.getKey();
                }
                this.firstAtom = n3;
                n3 += n4;
                bl2 = false;
                break;
            }
            case 2: {
                this.asc.bsAtoms = new BS();
                this.asc.bsAtoms.set(n3);
                Atom atom = atomArray[n3] = new Atom();
                atom.set(0.0f, 0.0f, 0.0f);
                int n7 = n3;
                while (--n7 >= this.firstAtom) {
                    atom.add(atomArray[n7]);
                }
                atom.scale(1.0f / (float)(n3 - this.firstAtom));
                atom.atomName = "Pt";
                atom.radius = 16.0f;
                this.asc.addAtom(atom);
                this.firstAtom = n3++;
                bl2 = false;
            }
        }
        Map map2 = (Map)map.get("asemblyIdAtoms");
        if (string.indexOf("#<") >= 0) {
            n2 = Math.min(n2, PT.parseInt(string.substring(string.indexOf("#<") + 2)) - 1);
            string = PT.rep(string, "#<", "_<");
        }
        int n8 = this.firstAtom;
        while (var16_25 < n3) {
            atomArray[var16_25].bsSymmetry = BSUtil.newAndSetBit(0);
            ++var16_25;
        }
        BS bS = this.asc.bsAtoms;
        int[] nArray3 = bl2 ? new int[this.asc.ac] : null;
        int n9 = lst2 == null ? 1 : 0;
        while (n9 < n2) {
            if (!(string.indexOf("!#") >= 0 ? string.indexOf("!#" + (n9 + 1) + ";") >= 0 : string.indexOf("#") >= 0 && string.indexOf("#" + (n9 + 1) + ";") < 0)) {
                String string3;
                object = (M4)lst.get(n9);
                String string4 = string3 = lst2 == null ? null : (String)lst2.get(n9);
                if (string3 != null && map2 != null) {
                    BS bS2 = new BS();
                    for (Map.Entry entry : map2.entrySet()) {
                        if (string3.indexOf(":" + (String)entry.getKey() + ";") < 0) continue;
                        bS2.or((BS)entry.getValue());
                    }
                    if (this.asc.bsAtoms != null) {
                        bS2.and(this.asc.bsAtoms);
                    }
                    string3 = null;
                }
                int n10 = this.firstAtom;
                while (n10 < n3) {
                    void var16_27;
                    if (!(var16_27 != null && !var16_27.get(n10) || string3 != null && string3.indexOf(":" + this.acr.vwr.getChainIDStr(atomArray[n10].chainID) + ";") < 0)) {
                        try {
                            int n11 = atomArray[n10].atomSite;
                            if (bl2) {
                                nArray3[n11] = this.asc.ac;
                            }
                            Atom atom = this.asc.newCloneAtom(atomArray[n10]);
                            if (this.asc.bsAtoms != null) {
                                this.asc.bsAtoms.set(atom.index);
                            }
                            atom.atomSite = n11;
                            ((M4)object).rotTrans(atom);
                            atom.bsSymmetry = BSUtil.newAndSetBit(n9);
                        }
                        catch (Exception exception) {
                            this.asc.errorMessage = "appendAtomCollection error: " + exception;
                        }
                    }
                    ++n10;
                }
                if (n9 > 0) {
                    this.symmetry.addBioMoleculeOperation((M4)object, false);
                    if (bl2) {
                        n10 = this.asc.bondIndex0;
                        while (n10 < this.bondCount0) {
                            Bond bond = this.asc.bonds[n10];
                            int n12 = nArray3[atomArray[bond.atomIndex1].atomSite];
                            int n13 = nArray3[atomArray[bond.atomIndex2].atomSite];
                            this.asc.addNewBondWithOrder(n12, n13, bond.order);
                            ++n10;
                        }
                    }
                }
            }
            ++n9;
        }
        if (lst2 != null) {
            if (this.asc.bsAtoms == null) {
                this.asc.bsAtoms = BSUtil.newBitSet2(0, this.asc.ac);
            }
            this.asc.bsAtoms.clearBits(this.firstAtom, n3);
        }
        this.noSymmetryCount = n3 - this.firstAtom;
        this.asc.setCurrentModelInfo("presymmetryAtomIndex", this.firstAtom);
        this.asc.setCurrentModelInfo("presymmetryAtomCount", this.noSymmetryCount);
        this.asc.setCurrentModelInfo("biosymmetryCount", n2);
        this.asc.setCurrentModelInfo("biosymmetry", this.symmetry);
        this.finalizeSymmetry(this.symmetry);
        this.setSymmetryOps();
        this.reset();
    }

    private void reset() {
        this.asc.coordinatesAreFractional = false;
        this.asc.setCurrentModelInfo("hasSymmetry", Boolean.TRUE);
        this.asc.setGlobalBoolean(1);
    }

    public Tensor addRotatedTensor(Atom atom, Tensor tensor, int n, boolean bl, SymmetryInterface symmetryInterface) {
        if (this.ptTemp == null) {
            this.ptTemp = new P3();
            this.mTemp = new M3();
        }
        return atom.addTensor(((Tensor)this.acr.getInterface("org.jmol.util.Tensor")).setFromEigenVectors(symmetryInterface.rotateAxes(n, tensor.eigenVectors, this.ptTemp, this.mTemp), tensor.eigenValues, tensor.isIsotropic ? "iso" : tensor.type, tensor.id, tensor), null, bl);
    }

    void setTensors() {
        int n = this.asc.ac;
        int n2 = this.asc.getLastAtomSetAtomIndex();
        while (n2 < n) {
            Atom atom = this.asc.atoms[n2];
            if (atom.anisoBorU != null) {
                atom.addTensor(this.symmetry.getTensor(this.acr.vwr, atom.anisoBorU), null, false);
                if (Float.isNaN(atom.bfactor)) {
                    atom.bfactor = atom.anisoBorU[7] * 100.0f;
                }
                atom.anisoBorU = null;
            }
            ++n2;
        }
    }

    public void setTimeReversal(int n, int n2) {
        this.symmetry.setTimeReversal(n, n2);
    }

    public int setSpinVectors() {
        if (this.nVib > 0 || this.asc.iSet < 0 || !this.acr.vibsFractional) {
            return this.nVib;
        }
        int n = this.asc.getAtomSetAtomIndex(this.asc.iSet);
        SymmetryInterface symmetryInterface = this.getBaseSymmetry();
        int n2 = this.asc.ac;
        while (--n2 >= n) {
            Vibration vibration = (Vibration)this.asc.atoms[n2].vib;
            if (vibration == null) continue;
            if (vibration.modDim > 0) {
                ((JmolModulationSet)((Object)vibration)).setMoment();
            } else {
                vibration = (Vibration)vibration.clone();
                symmetryInterface.toCartesian(vibration, true);
                this.asc.atoms[n2].vib = vibration;
            }
            ++this.nVib;
        }
        return this.nVib;
    }

    public void scaleFractionalVibs() {
        float[] fArray = this.getBaseSymmetry().getUnitCellParams();
        P3 p3 = P3.new3(1.0f / fArray[0], 1.0f / fArray[1], 1.0f / fArray[2]);
        int n = this.asc.getAtomSetAtomIndex(this.asc.iSet);
        int n2 = this.asc.ac;
        while (--n2 >= n) {
            Vibration vibration = (Vibration)this.asc.atoms[n2].vib;
            if (vibration == null) continue;
            vibration.scaleT(p3);
        }
    }

    public SymmetryInterface getBaseSymmetry() {
        return this.baseSymmetry == null ? this.symmetry : this.baseSymmetry;
    }

    public void finalizeUnitCell(P3 p3) {
        if (p3 != null && this.baseUnitCell != null) {
            this.baseUnitCell[22] = Math.max(1, (int)p3.x);
            this.baseUnitCell[23] = Math.max(1, (int)p3.y);
            this.baseUnitCell[24] = Math.max(1, (int)p3.z);
        }
    }
}

