/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.c;

public enum STR {
    NOT(-1, -8355712),
    NONE(0, -1),
    TURN(1, -10452737),
    SHEET(2, -14336),
    HELIX(3, -65408),
    DNA(4, -5373698),
    RNA(5, -196254),
    CARBOHYDRATE(6, -5855494),
    HELIX310(7, -6291328),
    HELIXALPHA(8, -65408),
    HELIXPI(9, -10485632),
    ANNOTATION(-2, 0);

    private int id;
    private int color;

    private STR(int n2, int n3) {
        this.id = n2;
        this.color = n3;
    }

    public int getId() {
        return this.id;
    }

    public int getColor() {
        return this.color;
    }

    public static final STR getProteinStructureType(String string) {
        STR[] sTRArray = STR.values();
        int n = sTRArray.length;
        int n2 = 0;
        while (n2 < n) {
            STR sTR = sTRArray[n2];
            if (string.equalsIgnoreCase(sTR.name())) {
                return sTR.isProtein() ? sTR : NOT;
            }
            ++n2;
        }
        return NOT;
    }

    public String getBioStructureTypeName(boolean bl) {
        return this.id < 0 ? "" : (bl && this.isProtein() ? "protein" : this.name());
    }

    private boolean isProtein() {
        return this.id >= 0 && this.id <= 3 || this.id >= 7;
    }
}

