/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javajs.util.AU;
import javajs.util.BS;
import org.jmol.api.JmolSelectionListener;
import org.jmol.i18n.GT;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BSUtil;
import org.jmol.viewer.Viewer;

public class SelectionManager {
    private Viewer vwr;
    private JmolSelectionListener[] listeners = new JmolSelectionListener[0];
    final BS bsHidden = new BS();
    private final BS bsSelection = new BS();
    final BS bsFixed = new BS();
    public BS bsSubset;
    public BS bsDeleted;
    public Boolean noneSelected;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int UNKNOWN = -1;
    private int empty = 1;
    boolean hideNotSelected;
    private final BS bsTemp = new BS();

    SelectionManager(Viewer viewer) {
        this.vwr = viewer;
    }

    void processDeletedModelAtoms(BS bS) {
        BSUtil.deleteBits(this.bsDeleted, bS);
        BSUtil.deleteBits(this.bsSubset, bS);
        BSUtil.deleteBits(this.bsFixed, bS);
        BSUtil.deleteBits(this.bsHidden, bS);
        BS bS2 = BSUtil.copy(this.bsSelection);
        BSUtil.deleteBits(bS2, bS);
        this.setSelectionSet(bS2, 0);
        this.selectionChanged(false);
    }

    void clear() {
        this.clearSelection(true);
        this.setSelectionSubset(null);
        this.hide(null, null, 0, true);
        this.bsDeleted = null;
        this.setMotionFixedAtoms(null);
    }

    void display(ModelSet modelSet, BS bS, int n, boolean bl) {
        switch (n) {
            default: {
                BS bS2 = this.bsSubset == null ? null : BSUtil.andNot(BSUtil.copy(this.bsHidden), this.bsSubset);
                BS bS3 = modelSet.getModelAtomBitSetIncludingDeleted(-1, false);
                this.bsHidden.or(bS3);
                if (bS2 != null) {
                    this.bsHidden.and(this.bsSubset);
                    this.bsHidden.or(bS2);
                }
            }
            case 1275069441: {
                if (bS == null) break;
                this.bsHidden.andNot(bS);
                break;
            }
            case 1073742119: {
                if (bS == null) break;
                this.bsHidden.or(bS);
            }
        }
        BSUtil.andNot(this.bsHidden, this.bsDeleted);
        modelSet.setBsHidden(this.bsHidden);
        if (!bl) {
            this.vwr.reportSelection(GT.i(GT.$("{0} atoms hidden"), this.bsHidden.cardinality()));
        }
    }

    void hide(ModelSet modelSet, BS bS, int n, boolean bl) {
        BS bS2 = n == 0 || this.bsSubset == null ? null : BSUtil.andNot(BSUtil.copy(this.bsHidden), this.bsSubset);
        SelectionManager.setBitSet(this.bsHidden, bS, n);
        if (bS2 != null) {
            this.bsHidden.or(bS2);
        }
        if (modelSet != null) {
            modelSet.setBsHidden(this.bsHidden);
        }
        if (!bl) {
            this.vwr.reportSelection(GT.i(GT.$("{0} atoms hidden"), this.bsHidden.cardinality()));
        }
    }

    void setSelectionSet(BS bS, int n) {
        SelectionManager.setBitSet(this.bsSelection, bS, n);
        this.empty = -1;
    }

    private static void setBitSet(BS bS, BS bS2, int n) {
        switch (n) {
            default: {
                bS.clearAll();
            }
            case 1275069441: {
                if (bS2 == null) break;
                bS.or(bS2);
                break;
            }
            case 1073742119: {
                if (bS2 == null) break;
                bS.andNot(bS2);
            }
        }
    }

    public BS getHiddenSet() {
        return this.bsHidden;
    }

    boolean getHideNotSelected() {
        return this.hideNotSelected;
    }

    void setHideNotSelected(boolean bl) {
        this.hideNotSelected = bl;
        if (bl) {
            this.selectionChanged(false);
        }
    }

    public boolean isSelected(int n) {
        return n >= 0 && this.bsSelection.get(n);
    }

    void select(BS bS, int n, boolean bl) {
        if (bS == null) {
            this.selectAll(true);
            if (!this.vwr.getBoolean(1612709900)) {
                this.excludeSelectionSet(this.vwr.ms.getAtoms(1612709900, null));
            }
            if (!this.vwr.getBoolean(0x60200006)) {
                this.excludeSelectionSet(this.vwr.ms.getAtoms(0x60200006, null));
            }
        } else {
            this.setSelectionSet(bS, n);
            if (!this.vwr.getBoolean(1612709900)) {
                this.excludeSelectionSet(this.vwr.ms.getAtoms(1612709900, null));
            }
            if (!this.vwr.getBoolean(0x60200006)) {
                this.excludeSelectionSet(this.vwr.ms.getAtoms(0x60200006, null));
            }
        }
        this.selectionChanged(false);
        boolean bl2 = this.vwr.getBoolean(603979880);
        if (!bl2 && bl) {
            return;
        }
        int n2 = this.getSelectionCount();
        if (bl2) {
            this.vwr.getChimeMessenger().reportSelection(n2);
        } else if (!bl) {
            this.vwr.reportSelection(GT.i(GT.$("{0} atoms selected"), n2));
        }
    }

    void selectAll(boolean bl) {
        int n = this.vwr.ms.ac;
        this.empty = n == 0 ? 1 : 0;
        int n2 = n;
        while (--n2 >= 0) {
            this.bsSelection.set(n2);
        }
        BSUtil.andNot(this.bsSelection, this.bsDeleted);
        this.selectionChanged(bl);
    }

    void clearSelection(boolean bl) {
        this.setHideNotSelected(false);
        this.bsSelection.clearAll();
        this.empty = 1;
        this.selectionChanged(bl);
    }

    public boolean isAtomSelected(int n) {
        return ((this.bsSubset == null || this.bsSubset.get(n)) && this.bsDeleted == null || !this.bsDeleted.get(n)) && this.bsSelection.get(n);
    }

    public void setSelectedAtom(int n, boolean bl) {
        if (n < 0) {
            this.selectionChanged(true);
            return;
        }
        if (this.bsSubset != null && !this.bsSubset.get(n) || this.bsDeleted != null && this.bsDeleted.get(n)) {
            return;
        }
        this.bsSelection.setBitTo(n, bl);
        this.empty = bl ? 0 : -1;
    }

    public void setSelectionSubset(BS bS) {
        this.bsSubset = bS;
    }

    boolean isInSelectionSubset(int n) {
        return n < 0 || this.bsSubset == null || this.bsSubset.get(n);
    }

    void invertSelection() {
        BSUtil.invertInPlace(this.bsSelection, this.vwr.ms.ac);
        this.empty = this.bsSelection.length() > 0 ? 0 : 1;
        this.selectionChanged(false);
    }

    private void excludeSelectionSet(BS bS) {
        if (bS == null || this.empty == 1) {
            return;
        }
        this.bsSelection.andNot(bS);
        this.empty = -1;
    }

    public int getSelectionCount() {
        BS bS;
        if (this.empty == 1) {
            return 0;
        }
        this.empty = 1;
        if (this.bsSubset == null) {
            bS = this.bsSelection;
        } else {
            this.bsTemp.clearAll();
            this.bsTemp.or(this.bsSubset);
            this.bsTemp.and(this.bsSelection);
            bS = this.bsTemp;
        }
        int n = bS.cardinality();
        if (n > 0) {
            this.empty = 0;
        }
        return n;
    }

    void addListener(JmolSelectionListener jmolSelectionListener) {
        int n = this.listeners.length;
        while (--n >= 0) {
            if (this.listeners[n] != jmolSelectionListener) continue;
            this.listeners[n] = null;
            break;
        }
        int n2 = n = this.listeners.length;
        while (--n2 >= 0) {
            if (this.listeners[n2] != null) continue;
            this.listeners[n2] = jmolSelectionListener;
            return;
        }
        this.listeners = this.listeners.length == 0 ? new JmolSelectionListener[1] : (JmolSelectionListener[])AU.doubleLength(this.listeners);
        this.listeners[n] = jmolSelectionListener;
    }

    private void selectionChanged(boolean bl) {
        if (this.hideNotSelected) {
            this.hide(this.vwr.ms, BSUtil.copyInvert(this.bsSelection, this.vwr.ms.ac), 0, bl);
        }
        if (bl || this.listeners.length == 0) {
            return;
        }
        int n = this.listeners.length;
        while (--n >= 0) {
            if (this.listeners[n] == null) continue;
            this.listeners[n].selectionChanged(this.bsSelection);
        }
    }

    int deleteAtoms(BS bS) {
        BS bS2 = BSUtil.copy(bS);
        if (this.bsDeleted == null) {
            this.bsDeleted = bS2;
        } else {
            bS2.andNot(this.bsDeleted);
            this.bsDeleted.or(bS);
        }
        this.bsHidden.andNot(this.bsDeleted);
        this.bsSelection.andNot(this.bsDeleted);
        return bS2.cardinality();
    }

    BS getSelectedAtoms() {
        if (this.bsSubset == null) {
            return this.bsSelection;
        }
        BS bS = BSUtil.copy(this.bsSelection);
        bS.and(this.bsSubset);
        return bS;
    }

    BS getSelectedAtomsNoSubset() {
        return BSUtil.copy(this.bsSelection);
    }

    public BS excludeAtoms(BS bS, boolean bl) {
        if (this.bsDeleted != null) {
            bS.andNot(this.bsDeleted);
        }
        if (!bl && this.bsSubset != null) {
            bS = BSUtil.copy(bS);
            bS.and(this.bsSubset);
        }
        return bS;
    }

    void setMotionFixedAtoms(BS bS) {
        this.bsFixed.clearAll();
        if (bS != null) {
            this.bsFixed.or(bS);
        }
    }

    BS getMotionFixedAtoms() {
        return this.bsFixed;
    }
}

