/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.api.EigenInterface;
import javajs.util.V3;

public class Eigen
implements EigenInterface {
    private int n = 3;
    private double[] d;
    private double[] e;
    private double[][] V;

    public Eigen set(int n) {
        this.n = n;
        this.V = new double[n][n];
        this.d = new double[n];
        this.e = new double[n];
        return this;
    }

    @Override
    public Eigen setM(double[][] m) {
        this.set(m.length);
        this.calc(m);
        return this;
    }

    @Override
    public double[] getEigenvalues() {
        return this.d;
    }

    @Override
    public void fillFloatArrays(V3[] eigenVectors, float[] eigenValues) {
        for (int i = 0; i < 3; ++i) {
            if (eigenVectors != null) {
                if (eigenVectors[i] == null) {
                    eigenVectors[i] = new V3();
                }
                eigenVectors[i].set((float)this.V[0][i], (float)this.V[1][i], (float)this.V[2][i]);
            }
            if (eigenValues == null) continue;
            eigenValues[i] = (float)this.d[i];
        }
    }

    @Override
    public float[][] getEigenvectorsFloatTransposed() {
        float[][] f = new float[this.n][this.n];
        int i = this.n;
        while (--i >= 0) {
            int j = this.n;
            while (--j >= 0) {
                f[j][i] = (float)this.V[i][j];
            }
        }
        return f;
    }

    public void calc(double[][] A) {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.V[i][j] = A[i][j];
            }
        }
        this.tred2();
        this.tql2();
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public double[] getImagEigenvalues() {
        return this.e;
    }

    private void tred2() {
        int i;
        int j;
        for (j = 0; j < this.n; ++j) {
            this.d[j] = this.V[this.n - 1][j];
        }
        for (i = this.n - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double h = 0.0;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(this.d[k]);
            }
            if (scale == 0.0) {
                this.e[i] = this.d[i - 1];
                for (int j2 = 0; j2 < i; ++j2) {
                    this.d[j2] = this.V[i - 1][j2];
                    this.V[i][j2] = 0.0;
                    this.V[j2][i] = 0.0;
                }
            } else {
                int j3;
                int j4;
                for (k = 0; k < i; ++k) {
                    int n = k;
                    this.d[n] = this.d[n] / scale;
                    h += this.d[k] * this.d[k];
                }
                double f = this.d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                this.e[i] = scale * g;
                h -= f * g;
                this.d[i - 1] = f - g;
                for (j4 = 0; j4 < i; ++j4) {
                    this.e[j4] = 0.0;
                }
                for (j4 = 0; j4 < i; ++j4) {
                    this.V[j4][i] = f = this.d[j4];
                    g = this.e[j4] + this.V[j4][j4] * f;
                    for (int k2 = j4 + 1; k2 <= i - 1; ++k2) {
                        g += this.V[k2][j4] * this.d[k2];
                        int n = k2;
                        this.e[n] = this.e[n] + this.V[k2][j4] * f;
                    }
                    this.e[j4] = g;
                }
                f = 0.0;
                for (j4 = 0; j4 < i; ++j4) {
                    int n = j4;
                    this.e[n] = this.e[n] / h;
                    f += this.e[j4] * this.d[j4];
                }
                double hh = f / (h + h);
                for (j3 = 0; j3 < i; ++j3) {
                    int n = j3;
                    this.e[n] = this.e[n] - hh * this.d[j3];
                }
                for (j3 = 0; j3 < i; ++j3) {
                    f = this.d[j3];
                    g = this.e[j3];
                    for (int k3 = j3; k3 <= i - 1; ++k3) {
                        double[] dArray = this.V[k3];
                        int n = j3;
                        dArray[n] = dArray[n] - (f * this.e[k3] + g * this.d[k3]);
                    }
                    this.d[j3] = this.V[i - 1][j3];
                    this.V[i][j3] = 0.0;
                }
            }
            this.d[i] = h;
        }
        for (i = 0; i < this.n - 1; ++i) {
            int k;
            this.V[this.n - 1][i] = this.V[i][i];
            this.V[i][i] = 1.0;
            double h = this.d[i + 1];
            if (h != 0.0) {
                for (k = 0; k <= i; ++k) {
                    this.d[k] = this.V[k][i + 1] / h;
                }
                for (int j5 = 0; j5 <= i; ++j5) {
                    int k4;
                    double g = 0.0;
                    for (k4 = 0; k4 <= i; ++k4) {
                        g += this.V[k4][i + 1] * this.V[k4][j5];
                    }
                    for (k4 = 0; k4 <= i; ++k4) {
                        double[] dArray = this.V[k4];
                        int n = j5;
                        dArray[n] = dArray[n] - g * this.d[k4];
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                this.V[k][i + 1] = 0.0;
            }
        }
        for (j = 0; j < this.n; ++j) {
            this.d[j] = this.V[this.n - 1][j];
            this.V[this.n - 1][j] = 0.0;
        }
        this.V[this.n - 1][this.n - 1] = 1.0;
        this.e[0] = 0.0;
    }

    private void tql2() {
        for (int i = 1; i < this.n; ++i) {
            this.e[i - 1] = this.e[i];
        }
        this.e[this.n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < this.n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
            for (m = l; m < this.n && !(Math.abs(this.e[m]) <= eps * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g = this.d[l];
                    double p = (this.d[l + 1] - g) / (2.0 * this.e[l]);
                    double r = Eigen.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    this.d[l] = this.e[l] / (p + r);
                    this.d[l + 1] = this.e[l] * (p + r);
                    double dl1 = this.d[l + 1];
                    double h = g - this.d[l];
                    int i = l + 2;
                    while (i < this.n) {
                        int n = i++;
                        this.d[n] = this.d[n] - h;
                    }
                    f += h;
                    p = this.d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = this.e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this.e[i2];
                        h = c * p;
                        r = Eigen.hypot(p, this.e[i2]);
                        this.e[i2 + 1] = s * r;
                        s = this.e[i2] / r;
                        c = p / r;
                        p = c * this.d[i2] - s * g;
                        this.d[i2 + 1] = h + s * (c * g + s * this.d[i2]);
                        for (int k = 0; k < this.n; ++k) {
                            h = this.V[k][i2 + 1];
                            this.V[k][i2 + 1] = s * this.V[k][i2] + c * h;
                            this.V[k][i2] = c * this.V[k][i2] - s * h;
                        }
                    }
                    p = -s * s2 * c3 * el1 * this.e[l] / dl1;
                    this.e[l] = s * p;
                    this.d[l] = c * p;
                } while (Math.abs(this.e[l]) > eps * tst1);
            }
            this.d[l] = this.d[l] + f;
            this.e[l] = 0.0;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            int j;
            int k = i;
            double p = this.d[i];
            for (j = i + 1; j < this.n; ++j) {
                if (!(this.d[j] < p)) continue;
                k = j;
                p = this.d[j];
            }
            if (k == i) continue;
            this.d[k] = this.d[i];
            this.d[i] = p;
            for (j = 0; j < this.n; ++j) {
                p = this.V[j][i];
                this.V[j][i] = this.V[j][k];
                this.V[j][k] = p;
            }
        }
    }

    private static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }
}

