/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import com.google.common.base.Throwables;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.utils.repl.ReplEscapeType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a*\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0003\"\b\b\u0000\u0010\u0011*\u00020\u0012*\b\u0012\u0004\u0012\u0002H\u00110\u00032\u0006\u0010\u0013\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003*\u00020\u0016H\u0000\u001a\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003*\u00020\u0018H\u0000\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u001a\n\u0010 \u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010!\u001a\u00020\u0001*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"END_LINE", "", "SOURCE_CHARS", "", "XML_PREAMBLE", "XML_REPLACEMENTS", "makeScriptBaseName", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "renderReplStackTrace", "cause", "", "startFromMethodName", "scriptResultFieldName", "lineNo", "", "ensureNotEmpty", "T", "", "error", "listAllUrlsAsFiles", "Ljava/io/File;", "Ljava/lang/ClassLoader;", "listLocalUrlsAsFiles", "Ljava/net/URLClassLoader;", "replAddLineBreak", "replEscapeLineBreaks", "replInputAsXml", "replNormalizeLineBreaks", "replOutputAsXml", "escapeType", "Lorg/jetbrains/kotlin/utils/repl/ReplEscapeType;", "replRemoveLineBreaksInTheEnd", "replUnescapeLineBreaks", "cli-common"})
public final class ReplUtilKt {
    private static final List<String> SOURCE_CHARS = CollectionsKt.listOf("\r", "\n", "#");
    private static final List<String> XML_REPLACEMENTS = CollectionsKt.listOf("#r", "#n", "#diez");
    private static final String END_LINE;

    @NotNull
    public static final String replUnescapeLineBreaks(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        String string = StringUtil.replace($receiver, XML_REPLACEMENTS, SOURCE_CHARS);
        Intrinsics.checkExpressionValueIsNotNull(string, "StringUtil.replace(this,\u2026PLACEMENTS, SOURCE_CHARS)");
        return string;
    }

    @NotNull
    public static final String replEscapeLineBreaks(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        String string = StringUtil.replace($receiver, SOURCE_CHARS, XML_REPLACEMENTS);
        Intrinsics.checkExpressionValueIsNotNull(string, "StringUtil.replace(this,\u2026_CHARS, XML_REPLACEMENTS)");
        return string;
    }

    @NotNull
    public static final String replOutputAsXml(@NotNull String $receiver, @NotNull ReplEscapeType escapeType) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)escapeType, "escapeType");
        String escapedXml = StringUtil.escapeXml(ReplUtilKt.replEscapeLineBreaks($receiver));
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><output type=\"" + (Object)((Object)escapeType) + "\">" + escapedXml + "</output>";
    }

    @NotNull
    public static final String replInputAsXml(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        String escapedXml = StringUtil.escapeXml(ReplUtilKt.replEscapeLineBreaks($receiver));
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><input>" + escapedXml + "</input>";
    }

    @NotNull
    public static final String replAddLineBreak(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        return $receiver + END_LINE;
    }

    @NotNull
    public static final String replRemoveLineBreaksInTheEnd(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        String string = END_LINE;
        String string2 = $receiver;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string3.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull(cArray, "(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        return StringsKt.trimEnd(string2, Arrays.copyOf(cArray2, cArray2.length));
    }

    @NotNull
    public static final String replNormalizeLineBreaks(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        return StringsKt.replace$default($receiver, END_LINE, "\n", false, 4, null);
    }

    @NotNull
    public static final String makeScriptBaseName(@NotNull ReplCodeLine codeLine) {
        Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
        return "Line_" + codeLine.getNo() + (codeLine.getGeneration() > 1 ? "_gen_" + codeLine.getGeneration() : "");
    }

    @NotNull
    public static final String scriptResultFieldName(int lineNo) {
        return "res" + lineNo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderReplStackTrace(@NotNull Throwable cause, @NotNull String startFromMethodName) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(cause, "cause");
        Intrinsics.checkParameterIsNotNull(startFromMethodName, "startFromMethodName");
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
        boolean skip2 = true;
        StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull(stackTraceElementArray, "cause.stackTrace");
        for (StackTraceElement element : ArraysKt.reversed(stackTraceElementArray)) {
            StringBuilder stringBuilder = new StringBuilder();
            StackTraceElement stackTraceElement = element;
            Intrinsics.checkExpressionValueIsNotNull(stackTraceElement, "element");
            if (Intrinsics.areEqual(stringBuilder.append(stackTraceElement.getClassName()).append('.').append(element.getMethodName()).toString(), startFromMethodName)) {
                skip2 = false;
            }
            if (skip2) continue;
            newTrace.add(element);
        }
        List resultingTrace = CollectionsKt.dropLast(CollectionsKt.reversed((Iterable)newTrace), 1);
        Object object = resultingTrace;
        Throwable throwable = cause;
        void v3 = $receiver$iv;
        if (v3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v3;
        StackTraceElement[] stackTraceElementArray2 = thisCollection$iv.toArray(new StackTraceElement[0]);
        if (stackTraceElementArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        StackTraceElement[] stackTraceElementArray3 = stackTraceElementArray2;
        throwable.setStackTrace(stackTraceElementArray3);
        String string = Throwables.getStackTraceAsString(cause);
        Intrinsics.checkExpressionValueIsNotNull(string, "Throwables.getStackTraceAsString(cause)");
        Object object2 = object = string;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trimEnd((CharSequence)object2)).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listAllUrlsAsFiles(@NotNull ClassLoader $receiver) {
        void $receiver$iv;
        List initial$iv;
        Sequence<URLClassLoader> parents2;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Sequence<URLClassLoader> sequence2 = parents2 = SequencesKt.filterIsInstance(SequencesKt.generateSequence($receiver, (Function1)listAllUrlsAsFiles.parents.1.INSTANCE), URLClassLoader.class);
        List accumulator$iv = initial$iv = CollectionsKt.emptyList();
        for (Object element$iv : $receiver$iv) {
            void loader;
            URLClassLoader uRLClassLoader = (URLClassLoader)element$iv;
            List accum = accumulator$iv;
            accumulator$iv = CollectionsKt.plus((Collection)ReplUtilKt.listLocalUrlsAsFiles((URLClassLoader)loader), (Iterable)accum);
        }
        return CollectionsKt.distinct(accumulator$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listLocalUrlsAsFiles(@NotNull URLClassLoader $receiver) {
        void var3_3;
        Object $receiver$iv$iv;
        void $receiver$iv$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        URL[] uRLArray = $receiver.getURLs();
        Intrinsics.checkExpressionValueIsNotNull(uRLArray, "this.urLs");
        Object $receiver$iv = uRLArray;
        URL[] uRLArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void var5_5 = $receiver$iv$iv$iv = $receiver$iv$iv;
        int n = ((void)var5_5).length;
        for (int i = 0; i < n; ++i) {
            String string;
            void element$iv$iv$iv;
            void element$iv$iv;
            void it = element$iv$iv = (element$iv$iv$iv = var5_5[i]);
            String string2 = it.toString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "it.toString()");
            if (StringsKt.removePrefix(string2, (CharSequence)"file:") == null) continue;
            String it$iv$iv = string;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void p1;
            Object item$iv$iv = iterator2.next();
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            File file2 = new File((String)p1);
            collection.add(file2);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final <T> List<T> ensureNotEmpty(@NotNull List<? extends T> $receiver, @NotNull String error) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(error, "error");
        if ($receiver.isEmpty()) {
            throw (Throwable)new IllegalStateException(error);
        }
        return $receiver;
    }

    static {
        LineSeparator lineSeparator = LineSeparator.getSystemLineSeparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)lineSeparator, "LineSeparator.getSystemLineSeparator()");
        String string = lineSeparator.getSeparatorString();
        Intrinsics.checkExpressionValueIsNotNull(string, "LineSeparator.getSystemL\u2026parator().separatorString");
        END_LINE = string;
    }
}

