/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.NamespaceUtil;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class QNameShortFormProvider
implements ShortFormProvider {
    private final NamespaceUtil namespaceUtil = new NamespaceUtil();

    public QNameShortFormProvider() {
        this(new HashMap<String, String>());
    }

    public QNameShortFormProvider(@Nonnull Map<String, String> prefix2NamespaceMap) {
        OWLAPIPreconditions.checkNotNull(prefix2NamespaceMap, "prefix2NamespaceMap cannot be null");
        for (Map.Entry<String, String> e : prefix2NamespaceMap.entrySet()) {
            int lastChar;
            String key = e.getKey();
            if (key.charAt(lastChar = key.length() - 1) == ':') {
                key = key.substring(0, lastChar);
            }
            this.namespaceUtil.setPrefix(e.getValue(), key);
        }
    }

    @Override
    public String getShortForm(@Nonnull OWLEntity entity) {
        OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null");
        String namespace = entity.getIRI().getNamespace();
        String prefix = this.namespaceUtil.getPrefix(namespace);
        return entity.getIRI().prefixedBy(prefix + ':');
    }

    @Override
    public void dispose() {
    }
}

