/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.cli;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.sdedit.cli.IOptions;
import net.sf.sdedit.cli.Option;
import net.sf.sdedit.cli.OptionObject;
import net.sf.sdedit.util.PWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.Parser;
import org.apache.commons.cli.PosixParser;

public class CommandLineBeanFactory<T extends IOptions>
implements InvocationHandler {
    private final Class<T> iface;
    private CommandLine commandLine;
    private Map<String, OptionObject> options;
    private Map<String, String> methodNames;
    private Map<String, OptionGroup> optionGroups;
    private Options opt;

    public CommandLineBeanFactory(Class<T> iface) {
        this.iface = iface;
        this.options = new HashMap<String, OptionObject>();
        this.opt = new Options();
        this.methodNames = new HashMap<String, String>();
        this.optionGroups = new HashMap<String, OptionGroup>();
        try {
            this.initialize();
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException("instrospection of class " + iface.getName() + " failed", e);
        }
    }

    private boolean check(T obj) {
        boolean success = true;
        for (OptionObject opt : this.options.values()) {
            Method method = opt.method();
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                String name = opt.getName();
                System.out.println("Illegal argument for option \"" + name + "\": " + t.getMessage());
                success = false;
            }
        }
        if (!success) {
            System.out.println();
        }
        return success;
    }

    public T parse(String[] args, String parserType) {
        Parser parser = "gnu".equalsIgnoreCase(parserType) ? new GnuParser() : new PosixParser();
        try {
            this.commandLine = parser.parse(this.opt, args);
        }
        catch (ParseException pe) {
            System.out.println(pe.getMessage());
            return null;
        }
        IOptions dataObject = (IOptions)this.iface.cast(Proxy.newProxyInstance(this.iface.getClassLoader(), new Class[]{this.iface}, (InvocationHandler)this));
        if (!this.check(dataObject)) {
            return null;
        }
        return (T)dataObject;
    }

    public T parse(String[] args) {
        return this.parse(args, "posix");
    }

    public void printHelp(String cmd) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmd, this.opt);
    }

    private void initialize() throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(this.iface);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor property = propertyDescriptors[i];
            Method method = property.getReadMethod();
            if (method == null || !method.isAnnotationPresent(Option.class)) continue;
            OptionObject optionObject = new OptionObject(property);
            this.options.put(optionObject.getName(), optionObject);
            this.methodNames.put(method.getName(), optionObject.getName());
            org.apache.commons.cli.Option option = optionObject.getOption();
            option.setRequired(optionObject.isRequired());
            this.opt.addOption(option);
            if (optionObject.getGroup() == null) continue;
            OptionGroup group = this.optionGroups.get(optionObject.getGroup());
            if (group == null) {
                group = new OptionGroup();
                this.optionGroups.put(optionObject.getGroup(), group);
            }
            group.addOption(option);
            if (!optionObject.isRequired()) continue;
            group.setRequired(true);
        }
        for (OptionGroup group : this.optionGroups.values()) {
            this.opt.addOptionGroup(group);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String inh;
        if ("toString".equals(method.getName()) && args == null) {
            PWriter writer = PWriter.create();
            for (Method m : this.iface.getMethods()) {
                ArrayList<Object> val;
                if (!m.isAnnotationPresent(Option.class)) continue;
                try {
                    val = this.invoke(proxy, m, args);
                }
                catch (Throwable t) {
                    val = t.getMessage();
                }
                if (val != null && val.getClass().isArray()) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    int n = Array.getLength(val);
                    for (int i = 0; i < n; ++i) {
                        Object obj = Array.get(val, i);
                        list.add(obj);
                    }
                    val = list;
                }
                writer.println(m.getName() + "=" + val);
            }
            return writer.toString();
        }
        if ("getArgs".equals(method.getName()) && args == null) {
            return this.commandLine.getArgs();
        }
        String name = this.methodNames.get(method.getName());
        OptionObject obj = this.options.get(name);
        Object value = obj.getValue(this.commandLine);
        if (value == null && (inh = obj.inherit()) != null) {
            value = this.invoke(proxy, this.options.get(inh).method(), args);
        }
        return value;
    }
}

