/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.Stylesheet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.WritableValue;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;

public class LabeledImpl
extends Label {
    private final Shuttler shuttler;

    public LabeledImpl(Labeled labeled) {
        this.shuttler = new Shuttler(this, labeled);
    }

    private static void initialize(Shuttler shuttler, LabeledImpl labeledImpl, Labeled labeled) {
        labeledImpl.setText(labeled.getText());
        labeled.textProperty().addListener(shuttler);
        labeledImpl.setGraphic(labeled.getGraphic());
        labeled.graphicProperty().addListener(shuttler);
        List<StyleableProperty> list = StyleableProperties.STYLEABLES_TO_MIRROR;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            WritableValue writableValue;
            StyleableProperty styleableProperty = list.get(i);
            if ("-fx-skin".equals(styleableProperty.getProperty()) || !((writableValue = styleableProperty.getWritableValue(labeled)) instanceof Observable)) continue;
            ((Observable)((Object)writableValue)).addListener(shuttler);
            Stylesheet.Origin origin = StyleableProperty.getOrigin(writableValue);
            styleableProperty.set(labeledImpl, writableValue.getValue(), origin);
        }
    }

    private static class Shuttler
    implements InvalidationListener {
        private final LabeledImpl labeledImpl;
        private final Labeled labeled;

        Shuttler(LabeledImpl labeledImpl, Labeled labeled) {
            this.labeledImpl = labeledImpl;
            this.labeled = labeled;
            LabeledImpl.initialize(this, labeledImpl, labeled);
        }

        @Override
        public void invalidated(Observable observable) {
            WritableValue writableValue;
            StyleableProperty styleableProperty;
            if (observable == this.labeled.textProperty()) {
                this.labeledImpl.setText(this.labeled.getText());
            } else if (observable == this.labeled.graphicProperty()) {
                Stylesheet.Origin origin = StyleableProperty.getOrigin(this.labeled.graphicProperty());
                if (origin == null || origin == Stylesheet.Origin.USER) {
                    this.labeledImpl.setGraphic(this.labeled.getGraphic());
                }
            } else if (observable instanceof WritableValue && (styleableProperty = StyleableProperty.getStyleableProperty(writableValue = (WritableValue)((Object)observable))) != null) {
                Stylesheet.Origin origin = StyleableProperty.getOrigin(writableValue);
                styleableProperty.set(this.labeledImpl, writableValue.getValue(), origin);
            }
        }
    }

    static final class StyleableProperties {
        static final List<StyleableProperty> STYLEABLES_TO_MIRROR;

        StyleableProperties() {
        }

        static {
            List<StyleableProperty> list = Labeled.impl_CSS_STYLEABLES();
            List<StyleableProperty> list2 = Parent.impl_CSS_STYLEABLES();
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(list);
            arrayList.removeAll(list2);
            STYLEABLES_TO_MIRROR = Collections.unmodifiableList(arrayList);
        }
    }
}

