/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Tab;
import com.dickimawbooks.texparserlib.TeXCellAlign;
import com.dickimawbooks.texparserlib.TeXCellAlignList;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.latex.AlignSpan;
import com.dickimawbooks.texparserlib.latex.Begin;
import com.dickimawbooks.texparserlib.latex.Cr;
import com.dickimawbooks.texparserlib.latex.End;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.MultiCell;
import com.dickimawbooks.texparserlib.latex.TabularNewline;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Vector;

public class AlignRow
extends TeXObjectList {
    private TeXObjectList alignSpanList;

    public AlignRow() {
    }

    public AlignRow(int n) {
        super(n);
    }

    public AlignRow(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this();
        this.parse(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList createList() {
        return new AlignRow(this.capacity());
    }

    protected void parse(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        TeXParserListener teXParserListener = teXParser.getListener();
        this.alignSpanList = new TeXObjectList();
        while (true) {
            if ((teXObject = teXObjectList.expandedPopStack(teXParser)) instanceof WhiteSpace) continue;
            if (!(teXObject instanceof AlignSpan)) break;
            if (teXObject instanceof TeXObjectList) {
                this.alignSpanList.addAll((TeXObjectList)teXObject);
                continue;
            }
            this.alignSpanList.add(teXObject);
        }
        teXObjectList.push(teXObject);
        teXObject = null;
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        while (true) {
            Object object;
            Object object2;
            TeXObject teXObject2;
            if ((teXObject2 = teXObjectList.expandedPopStack(teXParser)) instanceof Tab) {
                if (teXObject == null) {
                    this.add(teXParserListener.createGroup());
                    continue;
                }
                this.add(teXObject);
                teXObject = null;
                continue;
            }
            if (teXObject2 instanceof Cr) {
                if (teXObject == null) {
                    this.add(teXParserListener.createGroup());
                } else {
                    this.add(teXObject);
                    teXObject = null;
                }
                this.add(teXObject2 instanceof TabularNewline ? teXObject2 : teXParserListener.getControlSequence("tabularnewline"));
                break;
            }
            if (teXObject2 instanceof Begin) {
                Object object3 = object2 = teXObjectList == teXParser ? teXParser.popNextArg() : teXObjectList.popArg(teXParser);
                if (object2 instanceof Expandable) {
                    Object object4 = object = teXObjectList == teXParser ? ((Expandable)object2).expandfully(teXParser) : ((Expandable)object2).expandfully(teXParser, teXObjectList);
                    if (object != null) {
                        object2 = object;
                    }
                }
                object = object2.toString(teXParser);
                arrayDeque.push((String)object);
                this.add(teXObject2);
                this.add(teXParserListener.createGroup((String)object));
                continue;
            }
            if (teXObject2 instanceof End) {
                Object object5 = object2 = teXObjectList == teXParser ? teXParser.popNextArg() : teXObjectList.popArg(teXParser);
                if (object2 instanceof Expandable) {
                    Object object6 = object = teXObjectList == teXParser ? ((Expandable)object2).expandfully(teXParser) : ((Expandable)object2).expandfully(teXParser, teXObjectList);
                    if (object != null) {
                        object2 = object;
                    }
                }
                object = object2.toString(teXParser);
                if (arrayDeque.size() == 0) {
                    teXObjectList.push(teXParserListener.createGroup((String)object));
                    teXObjectList.push(teXObject2);
                    break;
                }
                arrayDeque.pop();
                this.add(teXObject2);
                this.add(teXParserListener.createGroup((String)object));
                continue;
            }
            if (teXObject2 instanceof MultiCell) {
                object2 = ((MultiCell)teXObject2).expandonce(teXParser, teXObjectList);
                if (teXObject == null) {
                    teXObject = teXParserListener.createGroup();
                }
                if (object2 == null) {
                    ((TeXObjectList)teXObject).add(teXObject2);
                    continue;
                }
                ((Vector)((Object)teXObject)).addAll(object2);
                continue;
            }
            if (teXObject == null) {
                teXObject = teXParserListener.createGroup();
            }
            ((TeXObjectList)teXObject).add(teXObject2);
        }
        if (teXObject != null) {
            this.add(teXObject);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        TeXCellAlignList teXCellAlignList = teXSettings.getAlignmentList();
        if (teXCellAlignList == null) {
            throw new LaTeXSyntaxException(teXParser, "latex.error.no_alignment", new Object[0]);
        }
        this.startRow(teXParser);
        teXSettings.startRow();
        boolean bl = true;
        while (this.size() > 0) {
            TeXObject teXObject;
            Group group;
            TeXObject teXObject2 = this.pop();
            if (teXObject2 instanceof TabularNewline) {
                this.endRow(teXParser);
                bl = false;
                if (teXObjectList == null || teXObjectList == teXParser) {
                    teXObject2.process(teXParser);
                    continue;
                }
                teXObject2.process(teXParser, teXObjectList);
                continue;
            }
            int n = teXSettings.getAlignmentColumn();
            TeXCellAlign teXCellAlign = (TeXCellAlign)teXCellAlignList.get(n);
            teXParser.getSettings().startColumn();
            if (teXObject2 instanceof Group) {
                group = (Group)teXObject2;
            } else {
                group = teXParser.getListener().createGroup();
                group.add(teXObject2);
            }
            int n2 = 0;
            TeXObject teXObject3 = teXObject = group.isEmpty() ? group : group.peekStack();
            if (teXObject instanceof MultiCell) {
                n2 = ((MultiCell)teXObject).getColumnSpan();
            }
            this.processCell(teXParser, teXCellAlign, group);
            for (int i = 1; i < n2; ++i) {
                teXParser.getSettings().startColumn();
            }
        }
        if (bl) {
            this.endRow(teXParser);
        }
    }

    protected void startRow(TeXParser teXParser) throws IOException {
    }

    protected void endRow(TeXParser teXParser) throws IOException {
    }

    protected void processCell(TeXParser teXParser, TeXCellAlign teXCellAlign, Group group) throws IOException {
        group.process(teXParser, this);
    }

    public TeXObjectList getAlignSpanList() {
        return this.alignSpanList;
    }
}

