/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.building;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.settings.building.SettingsProblem;

public class SettingsBuildingException
extends Exception {
    private final List<SettingsProblem> problems = new ArrayList<SettingsProblem>();

    public SettingsBuildingException(List<SettingsProblem> problems) {
        super(SettingsBuildingException.toMessage(problems));
        if (problems != null) {
            this.problems.addAll(problems);
        }
    }

    public List<SettingsProblem> getProblems() {
        return this.problems;
    }

    private static String toMessage(List<SettingsProblem> problems) {
        StringWriter buffer = new StringWriter(1024);
        PrintWriter writer2 = new PrintWriter(buffer);
        writer2.print(problems.size());
        writer2.print(problems.size() == 1 ? " problem was " : " problems were ");
        writer2.print("encountered while building the effective settings");
        writer2.println();
        for (SettingsProblem problem : problems) {
            writer2.print("[");
            writer2.print((Object)problem.getSeverity());
            writer2.print("] ");
            writer2.print(problem.getMessage());
            writer2.print(" @ ");
            writer2.println(problem.getLocation());
        }
        return buffer.toString();
    }
}

