/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import javajs.util.BinaryDocument;
import javajs.util.Rdr;
import junit.framework.TestCase;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.util.JUnitLogger;
import org.jmol.util.Logger;

class TestSmarterJmolAdapterImpl
extends TestCase {
    private File file;
    private boolean gzipped;
    private String typeAllowed;
    private boolean mustForce;
    private static boolean continuing = true;

    public TestSmarterJmolAdapterImpl(File file, boolean bl, String string) {
        super("testFile");
        this.file = file;
        this.gzipped = bl;
        this.mustForce = string.startsWith("=");
        if (this.mustForce) {
            string = string.substring(1);
        }
        this.typeAllowed = string;
    }

    public void runTest() throws Throwable {
        this.testFile();
    }

    public void testFile() throws FileNotFoundException, IOException {
        Object object;
        if (!continuing) {
            return;
        }
        String string = this.file.getCanonicalPath();
        System.out.println(string);
        JUnitLogger.setInformation(this.file.getPath());
        InputStream inputStream = new FileInputStream(this.file);
        if (this.gzipped) {
            inputStream = new GZIPInputStream(inputStream, 512);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        Logger.info(this.file.getPath());
        SmarterJmolAdapter smarterJmolAdapter = new SmarterJmolAdapter();
        String string2 = null;
        boolean bl = true;
        String string3 = smarterJmolAdapter.getFileTypeName(bufferedInputStream);
        System.out.println(string3);
        if (string3 == null) {
            object = Rdr.getBufferedReader(bufferedInputStream, null);
            string3 = smarterJmolAdapter.getFileTypeName(object);
        } else {
            object = new BinaryDocument().setStream(bufferedInputStream, true);
        }
        boolean bl2 = bl = this.typeAllowed.equals(string3) || this.typeAllowed.indexOf(";" + string3 + ";") >= 0;
        if (bl == this.mustForce) {
            continuing = false;
            TestSmarterJmolAdapterImpl.fail((String)("Wrong type for " + this.file.getPath() + ": " + string3 + " instead of " + this.typeAllowed));
        }
        if (this.mustForce) {
            string2 = this.typeAllowed;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("fullPathName", string);
        Object object2 = smarterJmolAdapter.getAtomSetCollectionFromReaderType(this.file.getName(), string2, object, hashtable);
        System.out.println(object2);
        continuing = object2 != null && object2 instanceof AtomSetCollection;
        TestSmarterJmolAdapterImpl.assertNotNull((String)("Nothing read for " + this.file.getPath()), (Object)object2);
        TestSmarterJmolAdapterImpl.assertFalse((String)("Error returned for " + this.file.getPath() + ": " + object2), (boolean)(object2 instanceof String));
        TestSmarterJmolAdapterImpl.assertTrue((String)("Not an AtomSetCollection for " + this.file.getPath()), (boolean)(object2 instanceof AtomSetCollection));
        int n = ((AtomSetCollection)object2).ac;
        continuing &= n > 0;
        TestSmarterJmolAdapterImpl.assertTrue((String)("No atoms loaded for " + this.file.getPath()), (n > 0 ? 1 : 0) != 0);
    }

    public String getName() {
        if (this.file != null) {
            return String.valueOf(super.getName()) + " [" + this.file.getPath() + "]";
        }
        return super.getName();
    }

    protected void setUp() throws Exception {
        super.setUp();
        JUnitLogger.activateLogger();
        JUnitLogger.setInformation(null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        JUnitLogger.setInformation(null);
        this.file = null;
        this.typeAllowed = null;
        this.mustForce = false;
    }
}

