/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.PT;
import org.jmol.c.VDW;
import org.jmol.util.Logger;

public class Elements {
    public static final String[] elementSymbols = new String[]{"Xx", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt"};
    public static final float[] atomicMass = new float[]{0.0f, 1.008f, 4.002f, 6.9675f, 9.012f, 10.8135f, 12.0106f, 14.006f, 15.999f, 18.998f, 20.1797f, 22.989f, 24.307f, 26.981f, 28.084f, 30.973f, 32.059f, 35.4515f, 39.948f, 39.0983f, 40.078f, 44.955f, 47.867f, 50.9415f, 51.9961f, 54.938f, 55.845f, 58.933f, 58.6934f, 63.546f, 65.38f, 69.723f, 72.63f, 74.921f, 78.971f, 79.904f, 83.798f, 85.4678f, 87.62f, 88.905f, 91.224f, 92.906f, 95.95f, 98.91f, 101.07f, 102.905f, 106.42f, 107.8682f, 112.414f, 114.818f, 118.71f, 121.76f, 127.6f, 126.904f, 131.293f, 132.905f, 137.327f, 138.905f, 140.116f, 140.907f, 144.242f, 144.9f, 150.36f, 151.964f, 157.25f, 158.925f, 162.5f, 164.93f, 167.259f, 168.934f, 173.054f, 174.9668f, 178.49f, 180.947f, 183.84f, 186.207f, 190.23f, 192.217f, 195.084f, 196.966f, 200.592f, 204.3835f, 207.2f, 208.98f, 210.0f, 210.0f, 222.0f, 223.0f, 226.03f, 227.03f, 232.0377f, 231.035f, 238.028f, 237.05f, 239.1f, 243.1f, 247.1f, 247.1f, 252.1f, 252.1f, 257.1f, 256.1f, 259.1f, 260.1f, 261.0f, 262.0f, 263.0f, 262.0f, 265.0f, 268.0f};
    public static final int[] isotopeMass;
    public static final int elementNumberMax;
    public static Map<String, Integer> htElementMap;
    public static final String[] elementNames;
    private static final String naturalIsotopes = "1H,12C,14N";
    public static final int firstIsotope = 4;
    private static final int[] altElementNumbers;
    public static final int altElementMax;
    private static final String[] altElementSymbols;
    private static final String[] altElementNames;
    public static final String VdwPROBE = "#VDW radii for PROBE;{_H}.vdw = 1.0;{_H and connected(_C) and not connected(within(smiles,'[a]'))}.vdw = 1.17;{_C}.vdw = 1.75;{_C and connected(3) and connected(_O)}.vdw = 1.65;{_N}.vdw = 1.55;{_O}.vdw = 1.4;{_P}.vdw = 1.8;{_S}.vdw = 1.8;message VDW radii for H, C, N, O, P, and S set according to Word, et al., J. Mol. Biol. (1999) 285, 1711-1733";
    public static final short[] vanderwaalsMars;
    public static final int RAD_COV_IONIC_OB1_100_1 = 0;
    public static final int RAD_COV_BODR_2014_02_22 = 1;
    public static int covalentVersion;
    public static int bondingVersion;
    public static final short[] defaultBondingMars;
    public static final int FORMAL_CHARGE_MIN = -4;
    public static final int FORMAL_CHARGE_MAX = 7;
    private static final short[] cationLookupTable;
    private static final short[] anionLookupTable;
    private static final BS bsCations;
    private static final BS bsAnions;
    private static final float[] hydrophobicities;
    private static float[] electroNegativities;

    static {
        int[] nArray = new int[110];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 7;
        nArray[4] = 9;
        nArray[5] = 11;
        nArray[6] = 12;
        nArray[7] = 14;
        nArray[8] = 16;
        nArray[9] = 19;
        nArray[10] = 20;
        nArray[11] = 23;
        nArray[12] = 24;
        nArray[13] = 27;
        nArray[14] = 28;
        nArray[15] = 31;
        nArray[16] = 32;
        nArray[17] = 35;
        nArray[18] = 40;
        nArray[19] = 39;
        nArray[20] = 40;
        nArray[21] = 45;
        nArray[22] = 48;
        nArray[23] = 51;
        nArray[24] = 52;
        nArray[25] = 55;
        nArray[26] = 56;
        nArray[27] = 59;
        nArray[28] = 59;
        nArray[29] = 64;
        nArray[30] = 65;
        nArray[31] = 70;
        nArray[32] = 73;
        nArray[33] = 75;
        nArray[34] = 79;
        nArray[35] = 80;
        nArray[36] = 84;
        nArray[37] = 85;
        nArray[38] = 88;
        nArray[39] = 89;
        nArray[40] = 91;
        nArray[41] = 93;
        nArray[42] = 96;
        nArray[43] = 98;
        nArray[44] = 101;
        nArray[45] = 103;
        nArray[46] = 106;
        nArray[47] = 108;
        nArray[48] = 112;
        nArray[49] = 115;
        nArray[50] = 119;
        nArray[51] = 122;
        nArray[52] = 128;
        nArray[53] = 127;
        nArray[54] = 131;
        nArray[55] = 133;
        nArray[56] = 137;
        nArray[57] = 139;
        nArray[58] = 140;
        nArray[59] = 141;
        nArray[60] = 144;
        nArray[61] = 145;
        nArray[62] = 150;
        nArray[63] = 152;
        nArray[64] = 157;
        nArray[65] = 159;
        nArray[66] = 163;
        nArray[67] = 165;
        nArray[68] = 167;
        nArray[69] = 169;
        nArray[70] = 173;
        nArray[71] = 175;
        nArray[72] = 179;
        nArray[73] = 181;
        nArray[74] = 184;
        nArray[75] = 186;
        nArray[76] = 190;
        nArray[77] = 192;
        nArray[78] = 195;
        nArray[79] = 197;
        nArray[80] = 201;
        nArray[81] = 204;
        nArray[82] = 207;
        nArray[83] = 209;
        nArray[84] = 209;
        nArray[85] = 210;
        nArray[86] = 222;
        nArray[87] = 223;
        nArray[88] = 226;
        nArray[89] = 227;
        nArray[90] = 232;
        nArray[91] = 231;
        nArray[92] = 238;
        nArray[93] = 237;
        nArray[94] = 244;
        nArray[95] = 243;
        nArray[96] = 247;
        nArray[97] = 247;
        nArray[98] = 251;
        nArray[99] = 252;
        nArray[100] = 257;
        nArray[101] = 258;
        nArray[102] = 259;
        nArray[103] = 260;
        nArray[104] = 261;
        nArray[105] = 262;
        nArray[106] = 263;
        nArray[107] = 262;
        nArray[108] = 265;
        nArray[109] = 268;
        isotopeMass = nArray;
        elementNumberMax = elementSymbols.length;
        elementNames = new String[]{"unknown", "hydrogen", "helium", "lithium", "beryllium", "boron", "carbon", "nitrogen", "oxygen", "fluorine", "neon", "sodium", "magnesium", "aluminum", "silicon", "phosphorus", "sulfur", "chlorine", "argon", "potassium", "calcium", "scandium", "titanium", "vanadium", "chromium", "manganese", "iron", "cobalt", "nickel", "copper", "zinc", "gallium", "germanium", "arsenic", "selenium", "bromine", "krypton", "rubidium", "strontium", "yttrium", "zirconium", "niobium", "molybdenum", "technetium", "ruthenium", "rhodium", "palladium", "silver", "cadmium", "indium", "tin", "antimony", "tellurium", "iodine", "xenon", "cesium", "barium", "lanthanum", "cerium", "praseodymium", "neodymium", "promethium", "samarium", "europium", "gadolinium", "terbium", "dysprosium", "holmium", "erbium", "thulium", "ytterbium", "lutetium", "hafnium", "tantalum", "tungsten", "rhenium", "osmium", "iridium", "platinum", "gold", "mercury", "thallium", "lead", "bismuth", "polonium", "astatine", "radon", "francium", "radium", "actinium", "thorium", "protactinium", "uranium", "neptunium", "plutonium", "americium", "curium", "berkelium", "californium", "einsteinium", "fermium", "mendelevium", "nobelium", "lawrencium", "rutherfordium", "dubnium", "seaborgium", "bohrium", "hassium", "meitnerium"};
        int[] nArray2 = new int[10];
        nArray2[1] = 13;
        nArray2[2] = 16;
        nArray2[3] = 55;
        nArray2[4] = 257;
        nArray2[5] = 385;
        nArray2[6] = 1414;
        nArray2[7] = 1670;
        nArray2[8] = 1798;
        nArray2[9] = 1927;
        altElementNumbers = nArray2;
        altElementMax = altElementNumbers.length;
        altElementSymbols = new String[]{"Xx", "Al", "S", "Cs", "D", "T", "11C", "13C", "14C", "15N"};
        altElementNames = new String[]{"dummy", "aluminium", "sulphur", "caesium", "deuterium", "tritium", "", "", "", ""};
        vanderwaalsMars = new short[]{1000, 1000, 1000, 1000, 1200, 1100, 1100, 1200, 1400, 1400, 2200, 1400, 1820, 1810, 1220, 2200, 1700, 1530, 628, 1900, 2080, 1920, 1548, 1800, 1950, 1700, 1548, 1700, 1850, 1550, 1400, 1600, 1700, 1520, 1348, 1550, 1730, 1470, 1300, 1500, 1540, 1540, 2020, 1540, 2270, 2270, 2200, 2400, 1730, 1730, 1500, 2200, 2050, 1840, 1500, 2100, 2100, 2100, 2200, 2100, 2080, 1800, 1880, 1950, 2000, 1800, 1808, 1800, 1970, 1750, 1748, 1800, 1880, 1880, 2768, 1880, 2750, 2750, 2388, 2800, 1973, 2310, 1948, 2400, 1700, 2300, 1320, 2300, 1700, 2150, 1948, 2150, 1700, 2050, 1060, 2050, 1700, 2050, 1128, 2050, 1700, 2050, 1188, 2050, 1700, 2050, 1948, 2050, 1700, 2000, 1128, 2000, 1630, 2000, 1240, 2000, 1400, 2000, 1148, 2000, 1390, 2100, 1148, 2100, 1870, 1870, 1548, 2100, 1700, 2110, 3996, 2100, 1850, 1850, 828, 2050, 1900, 1900, 900, 1900, 2100, 1830, 1748, 1900, 2020, 2020, 1900, 2020, 1700, 3030, 2648, 2900, 1700, 2490, 2020, 2550, 1700, 2400, 1608, 2400, 1700, 2300, 1420, 2300, 1700, 2150, 1328, 2150, 1700, 2100, 1748, 2100, 1700, 2050, 1800, 2050, 1700, 2050, 1200, 2050, 1700, 2000, 1220, 2000, 1630, 2050, 1440, 2050, 1720, 2100, 1548, 2100, 1580, 2200, 1748, 2200, 1930, 2200, 1448, 2200, 2170, 1930, 1668, 2250, 2200, 2170, 1120, 2200, 2060, 2060, 1260, 2100, 2150, 1980, 1748, 2100, 2160, 2160, 2100, 2160, 1700, 3430, 3008, 3000, 1700, 2680, 2408, 2700, 1700, 2500, 1828, 2500, 1700, 2480, 1860, 2480, 1700, 2470, 1620, 2470, 1700, 2450, 1788, 2450, 1700, 2430, 1760, 2430, 1700, 2420, 1740, 2420, 1700, 2400, 1960, 2400, 1700, 2380, 1688, 2380, 1700, 2370, 1660, 2370, 1700, 2350, 1628, 2350, 1700, 2330, 1608, 2330, 1700, 2320, 1588, 2320, 1700, 2300, 1568, 2300, 1700, 2280, 1540, 2280, 1700, 2270, 1528, 2270, 1700, 2250, 1400, 2250, 1700, 2200, 1220, 2200, 1700, 2100, 1260, 2100, 1700, 2050, 1300, 2050, 1700, 2000, 1580, 2000, 1700, 2000, 1220, 2000, 1720, 2050, 1548, 2050, 1660, 2100, 1448, 2100, 1550, 2050, 1980, 2050, 1960, 1960, 1708, 2200, 2020, 2020, 2160, 2300, 1700, 2070, 1728, 2300, 1700, 1970, 1208, 2000, 1700, 2020, 1120, 2000, 1700, 2200, 2300, 2000, 1700, 3480, 3240, 2000, 1700, 2830, 2568, 2000, 1700, 2000, 2120, 2000, 1700, 2400, 1840, 2400, 1700, 2000, 1600, 2000, 1860, 2300, 1748, 2300, 1700, 2000, 1708, 2000, 1700, 2000, 1668, 2000, 1700, 2000, 1660, 2000, 1700, 2000, 1648, 2000, 1700, 2000, 1640, 2000, 1700, 2000, 1628, 2000, 1700, 2000, 1620, 2000, 1700, 2000, 1608, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1588, 2000, 1700, 2000, 1580, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000};
        covalentVersion = 1;
        bondingVersion = 0;
        short[] sArray = new short[220];
        sArray[2] = 230;
        sArray[3] = 320;
        sArray[4] = 930;
        sArray[5] = 460;
        sArray[6] = 680;
        sArray[7] = 1330;
        sArray[8] = 350;
        sArray[9] = 1020;
        sArray[10] = 830;
        sArray[11] = 850;
        sArray[12] = 680;
        sArray[13] = 750;
        sArray[14] = 680;
        sArray[15] = 710;
        sArray[16] = 680;
        sArray[17] = 630;
        sArray[18] = 640;
        sArray[19] = 640;
        sArray[20] = 1120;
        sArray[21] = 670;
        sArray[22] = 970;
        sArray[23] = 1550;
        sArray[24] = 1100;
        sArray[25] = 1390;
        sArray[26] = 1350;
        sArray[27] = 1260;
        sArray[28] = 1200;
        sArray[29] = 1160;
        sArray[30] = 750;
        sArray[31] = 1110;
        sArray[32] = 1020;
        sArray[33] = 1030;
        sArray[34] = 990;
        sArray[35] = 990;
        sArray[36] = 1570;
        sArray[37] = 960;
        sArray[38] = 1330;
        sArray[39] = 1960;
        sArray[40] = 990;
        sArray[41] = 1710;
        sArray[42] = 1440;
        sArray[43] = 1480;
        sArray[44] = 1470;
        sArray[45] = 1360;
        sArray[46] = 1330;
        sArray[47] = 1340;
        sArray[48] = 1350;
        sArray[49] = 1220;
        sArray[50] = 1350;
        sArray[51] = 1190;
        sArray[52] = 1340;
        sArray[53] = 1160;
        sArray[54] = 1330;
        sArray[55] = 1110;
        sArray[56] = 1500;
        sArray[57] = 1100;
        sArray[58] = 1520;
        sArray[59] = 1120;
        sArray[60] = 1450;
        sArray[61] = 1180;
        sArray[62] = 1220;
        sArray[63] = 1240;
        sArray[64] = 1170;
        sArray[65] = 1210;
        sArray[66] = 1210;
        sArray[67] = 1210;
        sArray[68] = 1220;
        sArray[69] = 1160;
        sArray[70] = 1210;
        sArray[71] = 1140;
        sArray[72] = 1910;
        sArray[73] = 1170;
        sArray[74] = 1470;
        sArray[75] = 2100;
        sArray[76] = 1120;
        sArray[77] = 1850;
        sArray[78] = 1780;
        sArray[79] = 1630;
        sArray[80] = 1560;
        sArray[81] = 1540;
        sArray[82] = 1480;
        sArray[83] = 1470;
        sArray[84] = 1470;
        sArray[85] = 1380;
        sArray[86] = 1350;
        sArray[87] = 1280;
        sArray[88] = 1400;
        sArray[89] = 1250;
        sArray[90] = 1450;
        sArray[91] = 1250;
        sArray[92] = 1500;
        sArray[93] = 1200;
        sArray[94] = 1590;
        sArray[95] = 1280;
        sArray[96] = 1690;
        sArray[97] = 1360;
        sArray[98] = 1630;
        sArray[99] = 1420;
        sArray[100] = 1460;
        sArray[101] = 1400;
        sArray[102] = 1460;
        sArray[103] = 1400;
        sArray[104] = 1470;
        sArray[105] = 1360;
        sArray[106] = 1400;
        sArray[107] = 1330;
        sArray[108] = 1980;
        sArray[109] = 1310;
        sArray[110] = 1670;
        sArray[111] = 2320;
        sArray[112] = 1340;
        sArray[113] = 1960;
        sArray[114] = 1870;
        sArray[115] = 1800;
        sArray[116] = 1830;
        sArray[117] = 1630;
        sArray[118] = 1820;
        sArray[119] = 1760;
        sArray[120] = 1810;
        sArray[121] = 1740;
        sArray[122] = 1800;
        sArray[123] = 1730;
        sArray[124] = 1800;
        sArray[125] = 1720;
        sArray[126] = 1990;
        sArray[127] = 1680;
        sArray[128] = 1790;
        sArray[129] = 1690;
        sArray[130] = 1760;
        sArray[131] = 1680;
        sArray[132] = 1750;
        sArray[133] = 1670;
        sArray[134] = 1740;
        sArray[135] = 1660;
        sArray[136] = 1730;
        sArray[137] = 1650;
        sArray[138] = 1720;
        sArray[139] = 1640;
        sArray[140] = 1940;
        sArray[141] = 1700;
        sArray[142] = 1720;
        sArray[143] = 1620;
        sArray[144] = 1570;
        sArray[145] = 1520;
        sArray[146] = 1430;
        sArray[147] = 1460;
        sArray[148] = 1370;
        sArray[149] = 1370;
        sArray[150] = 1350;
        sArray[151] = 1310;
        sArray[152] = 1370;
        sArray[153] = 1290;
        sArray[154] = 1320;
        sArray[155] = 1220;
        sArray[156] = 1500;
        sArray[157] = 1230;
        sArray[158] = 1500;
        sArray[159] = 1240;
        sArray[160] = 1700;
        sArray[161] = 1330;
        sArray[162] = 1550;
        sArray[163] = 1440;
        sArray[164] = 1540;
        sArray[165] = 1440;
        sArray[166] = 1540;
        sArray[167] = 1510;
        sArray[168] = 1680;
        sArray[169] = 1450;
        sArray[170] = 1700;
        sArray[171] = 1470;
        sArray[172] = 2400;
        sArray[173] = 1420;
        sArray[174] = 2000;
        sArray[175] = 2230;
        sArray[176] = 1900;
        sArray[177] = 2010;
        sArray[178] = 1880;
        sArray[179] = 1860;
        sArray[180] = 1790;
        sArray[181] = 1750;
        sArray[182] = 1610;
        sArray[183] = 1690;
        sArray[184] = 1580;
        sArray[185] = 1700;
        sArray[186] = 1550;
        sArray[187] = 1710;
        sArray[188] = 1530;
        sArray[189] = 1720;
        sArray[190] = 1510;
        sArray[191] = 1660;
        sArray[192] = 1500;
        sArray[193] = 1660;
        sArray[194] = 1500;
        sArray[195] = 1680;
        sArray[196] = 1500;
        sArray[197] = 1680;
        sArray[198] = 1500;
        sArray[199] = 1650;
        sArray[200] = 1500;
        sArray[201] = 1670;
        sArray[202] = 1500;
        sArray[203] = 1730;
        sArray[204] = 1500;
        sArray[205] = 1760;
        sArray[206] = 1500;
        sArray[207] = 1610;
        sArray[208] = 1600;
        sArray[209] = 1570;
        sArray[210] = 1600;
        sArray[211] = 1490;
        sArray[212] = 1600;
        sArray[213] = 1430;
        sArray[214] = 1600;
        sArray[215] = 1410;
        sArray[216] = 1600;
        sArray[217] = 1340;
        sArray[218] = 1600;
        sArray[219] = 1290;
        defaultBondingMars = sArray;
        cationLookupTable = new short[]{53, 680, 69, 440, 70, 350, 85, 350, 87, 230, 104, 160, 117, 680, 119, 160, 121, 130, 133, 220, 138, 90, 155, 80, 165, 1120, 181, 970, 197, 820, 198, 660, 215, 510, 229, 650, 232, 420, 247, 440, 249, 350, 262, 2190, 264, 370, 266, 300, 281, 340, 283, 270, 293, 1540, 309, 1330, 325, 1180, 326, 990, 343, 732, 357, 960, 358, 940, 359, 760, 360, 680, 374, 880, 375, 740, 376, 630, 377, 590, 389, 810, 390, 890, 391, 630, 394, 520, 406, 800, 407, 660, 408, 600, 411, 460, 422, 740, 423, 640, 438, 720, 439, 630, 454, 690, 469, 960, 470, 720, 485, 880, 486, 740, 501, 810, 503, 620, 518, 730, 520, 530, 535, 580, 537, 460, 549, 660, 552, 500, 554, 420, 569, 470, 571, 390, 597, 1470, 614, 1120, 631, 893, 645, 1090, 648, 790, 661, 1000, 664, 740, 665, 690, 677, 930, 680, 700, 682, 620, 699, 979, 712, 670, 727, 680, 742, 800, 744, 650, 757, 1260, 758, 890, 773, 1140, 774, 970, 791, 810, 806, 930, 808, 710, 823, 760, 825, 620, 837, 820, 840, 700, 842, 560, 857, 620, 859, 500, 885, 1670, 901, 1530, 902, 1340, 917, 1390, 919, 1016, 933, 1270, 935, 1034, 936, 920, 951, 1013, 952, 900, 967, 995, 983, 979, 999, 964, 1014, 1090, 1015, 950, 1031, 938, 1047, 923, 1048, 840, 1063, 908, 1079, 894, 1095, 881, 1111, 870, 1126, 930, 1127, 858, 1143, 850, 1160, 780, 1177, 680, 1192, 700, 1194, 620, 1208, 720, 1211, 560, 1224, 880, 1226, 690, 1240, 680, 1254, 800, 1256, 650, 1269, 1370, 1271, 850, 1285, 1270, 1286, 1100, 1301, 1470, 1303, 950, 1318, 1200, 1320, 840, 1333, 980, 1335, 960, 1337, 740, 1354, 670, 1371, 620, 1397, 1800, 1414, 1430, 1431, 1180, 1448, 1020, 1463, 1130, 1464, 980, 1465, 890, 1480, 970, 1482, 800, 1495, 1100, 1496, 950, 1499, 710, 1511, 1080, 1512, 930, 1527, 1070, 1528, 920};
        anionLookupTable = new short[]{19, 1540, 96, 2600, 113, 1710, 130, 1360, 131, 680, 147, 1330, 241, 2120, 258, 1840, 275, 1810, 512, 2720, 529, 2220, 546, 1980, 563, 1960, 800, 2940, 803, 3700, 817, 2450, 834, 2110, 835, 2500, 851, 2200};
        bsCations = new BS();
        bsAnions = new BS();
        int n = 0;
        while (n < anionLookupTable.length) {
            bsAnions.set(anionLookupTable[n] >> 4);
            n += 2;
        }
        n = 0;
        while (n < cationLookupTable.length) {
            bsCations.set(cationLookupTable[n] >> 4);
            n += 2;
        }
        hydrophobicities = new float[]{0.0f, 0.62f, -2.53f, -0.78f, -0.9f, 0.29f, -0.85f, -0.74f, 0.48f, -0.4f, 1.38f, 1.06f, -1.5f, 0.64f, 1.19f, 0.12f, -0.18f, -0.05f, 0.81f, 0.26f, 1.08f};
        if (elementNames.length != elementNumberMax || vanderwaalsMars.length >> 2 != elementNumberMax || defaultBondingMars.length >> 1 != elementNumberMax) {
            Logger.error("ERROR!!! Element table length mismatch:\n elementSymbols.length=" + elementSymbols.length + "\n elementNames.length=" + elementNames.length + "\n vanderwaalsMars.length=" + vanderwaalsMars.length + "\n covalentMars.length=" + defaultBondingMars.length);
        }
        electroNegativities = new float[]{0.0f, 2.2f, 0.0f, 0.97f, 1.47f, 2.01f, 2.5f, 3.07f, 3.5f, 4.1f, 0.0f, 1.01f, 1.23f, 1.47f, 1.74f, 2.06f, 2.44f, 2.83f, 0.0f, 0.91f, 1.04f, 1.2f, 1.32f, 1.45f, 1.56f, 1.6f, 1.64f, 1.7f, 1.75f, 1.75f, 1.66f, 1.82f, 2.02f, 2.2f, 2.48f, 2.74f, 0.0f, 0.89f, 0.99f, 1.11f, 1.22f, 1.23f, 1.3f, 1.36f, 1.42f, 1.45f, 1.35f, 1.42f, 1.46f, 1.49f, 1.72f, 1.82f, 2.01f, 2.21f};
    }

    public static int getNaturalIsotope(int n) {
        return isotopeMass[n & 0x7F];
    }

    public static float getAtomicMass(int n) {
        return n < 1 || n >= atomicMass.length ? 0.0f : atomicMass[n];
    }

    public static final int elementNumberFromSymbol(String string, boolean bl) {
        int n;
        Serializable serializable;
        if (htElementMap == null) {
            Integer n2;
            String string2;
            serializable = new Hashtable();
            n = elementNumberMax;
            while (--n >= 0) {
                string2 = elementSymbols[n];
                n2 = n;
                serializable.put(string2, n2);
                if (string2.length() != 2) continue;
                serializable.put(string2.toUpperCase(), n2);
            }
            n = altElementMax;
            while (--n >= 4) {
                string2 = altElementSymbols[n];
                n2 = altElementNumbers[n];
                serializable.put(string2, n2);
                if (string2.length() != 2) continue;
                serializable.put(string2.toUpperCase(), n2);
            }
            htElementMap = serializable;
        }
        if (string == null) {
            return 0;
        }
        serializable = htElementMap.get(string);
        if (serializable != null) {
            return (Integer)serializable;
        }
        if (PT.isDigit(string.charAt(0))) {
            int n3;
            int n4;
            n = string.length() - 2;
            if (n >= 0 && PT.isDigit(string.charAt(n))) {
                ++n;
            }
            int n5 = n4 = n > 0 ? PT.parseInt(string.substring(0, n)) : 0;
            if (n4 > 0 && (n3 = Elements.elementNumberFromSymbol(string.substring(n), true)) > 0) {
                n4 = Elements.getAtomicAndIsotopeNumber(n3, n4);
                htElementMap.put(string.toUpperCase(), n4);
                return n4;
            }
        }
        if (!bl) {
            Logger.error("'" + string + "' is not a recognized symbol");
        }
        return 0;
    }

    public static final String elementSymbolFromNumber(int n) {
        int n2 = 0;
        if (n >= elementNumberMax) {
            int n3 = altElementMax;
            while (--n3 >= 0) {
                if (n != altElementNumbers[n3]) continue;
                return altElementSymbols[n3];
            }
            n2 = Elements.getIsotopeNumber(n);
            return n2 + Elements.getElementSymbol(n %= 128);
        }
        return Elements.getElementSymbol(n);
    }

    private static String getElementSymbol(int n) {
        if (n < 0 || n >= elementNumberMax) {
            n = 0;
        }
        return elementSymbols[n];
    }

    public static final String elementNameFromNumber(int n) {
        if (n >= elementNumberMax) {
            int n2 = altElementMax;
            while (--n2 >= 0) {
                if (n != altElementNumbers[n2]) continue;
                return altElementNames[n2];
            }
            n %= 128;
        }
        if (n < 0 || n >= elementNumberMax) {
            n = 0;
        }
        return elementNames[n];
    }

    public static final int elementNumberFromName(String string) {
        int n = 1;
        while (n < elementNumberMax) {
            if (elementNames[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static final String altElementNameFromIndex(int n) {
        return altElementNames[n];
    }

    public static final int altElementNumberFromIndex(int n) {
        return altElementNumbers[n];
    }

    public static final String altElementSymbolFromIndex(int n) {
        return altElementSymbols[n];
    }

    public static final String altIsotopeSymbolFromIndex(int n) {
        int n2 = altElementNumbers[n];
        return String.valueOf(n2 >> 7) + Elements.elementSymbolFromNumber(n2 & 0x7F);
    }

    public static final String altIsotopeSymbolFromIndex2(int n) {
        int n2 = altElementNumbers[n];
        return String.valueOf(Elements.elementSymbolFromNumber(n2 & 0x7F)) + (n2 >> 7);
    }

    public static final int getElementNumber(int n) {
        return n & 0x7F;
    }

    public static final int getIsotopeNumber(int n) {
        return n >> 7;
    }

    public static final int getAtomicAndIsotopeNumber(int n, int n2) {
        return (n < 0 ? 0 : n) + (n2 <= 0 ? 0 : n2 << 7);
    }

    public static final int altElementIndexFromNumber(int n) {
        int n2 = 0;
        while (n2 < altElementMax) {
            if (altElementNumbers[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    public static final boolean isNaturalIsotope(String string) {
        return naturalIsotopes.indexOf(String.valueOf(string) + ",") >= 0;
    }

    public static float getBondingRadius(int n, int n2) {
        int n3 = n & 0x7F;
        return n2 > 0 && bsCations.get(n3) ? Elements.getBondingRadFromTable(n3, n2, cationLookupTable) : (n2 < 0 && bsAnions.get(n3) ? Elements.getBondingRadFromTable(n3, n2, anionLookupTable) : (float)defaultBondingMars[(n3 << 1) + bondingVersion] / 1000.0f);
    }

    public static float getCovalentRadius(int n) {
        return (float)defaultBondingMars[((n & 0x7F) << 1) + covalentVersion] / 1000.0f;
    }

    public static float getBondingRadFromTable(int n, int n2, short[] sArray) {
        int n3 = (n << 4) + (n2 + 4);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = sArray.length / 2;
        while (n6 != n7) {
            n5 = (n6 + n7) / 2;
            n4 = sArray[n5 << 1];
            if (n4 > n3) {
                n7 = n5;
                continue;
            }
            if (n4 < n3) {
                n6 = n5 + 1;
                continue;
            }
            return (float)sArray[(n5 << 1) + 1] / 1000.0f;
        }
        if (n4 > n3) {
            --n5;
        }
        if (n != (n4 = sArray[n5 << 1]) >> 4) {
            ++n5;
        }
        return (float)sArray[(n5 << 1) + 1] / 1000.0f;
    }

    public static int getVanderwaalsMar(int n, VDW vDW) {
        return vanderwaalsMars[((n & 0x7F) << 2) + vDW.pt % 4];
    }

    public static float getHydrophobicity(int n) {
        return n < 1 || n >= hydrophobicities.length ? 0.0f : hydrophobicities[n];
    }

    public static float getAllredRochowElectroNeg(int n) {
        return n > 0 && n < electroNegativities.length ? electroNegativities[n] : 0.0f;
    }

    public static boolean isElement(int n, int n2) {
        return (n & 0x7F) == n2;
    }
}

