/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.ivy.util.CopyProgressEvent;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.URLHandlerRegistry;

public final class FileUtil {
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private static final Pattern ALLOWED_PATH_PATTERN = Pattern.compile("[\\w-./\\\\:~ %\\(\\)]+");

    public static boolean prepareCopy(File src, File dest, boolean overwrite) throws IOException {
        if (src.isDirectory()) {
            if (dest.exists()) {
                if (!dest.isDirectory()) {
                    throw new IOException("impossible to copy: destination is not a directory: " + dest);
                }
            } else {
                dest.mkdirs();
            }
            return true;
        }
        if (dest.exists()) {
            if (!dest.isFile()) {
                throw new IOException("impossible to copy: destination is not a file: " + dest);
            }
            if (overwrite) {
                if (!dest.canWrite()) {
                    dest.delete();
                }
            } else {
                Message.verbose(dest + " already exists, nothing done");
                return false;
            }
        }
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        return true;
    }

    public static boolean copy(File src, File dest, CopyProgressListener l, boolean overwrite) throws IOException {
        if (!FileUtil.prepareCopy(src, dest, overwrite)) {
            return false;
        }
        if (src.isDirectory()) {
            return FileUtil.deepCopy(src, dest, l, overwrite);
        }
        FileUtil.copy((InputStream)new FileInputStream(src), dest, l);
        long srcLen = src.length();
        long destLen = dest.length();
        if (srcLen != destLen) {
            dest.delete();
            throw new IOException("size of source file " + src.toString() + "(" + srcLen + ") differs from size of dest file " + dest.toString() + "(" + destLen + ") - please retry");
        }
        dest.setLastModified(src.lastModified());
        return true;
    }

    public static boolean deepCopy(File src, File dest, CopyProgressListener l, boolean overwrite) throws IOException {
        int i;
        List<File> existingChild = Collections.EMPTY_LIST;
        if (dest.exists()) {
            if (!dest.isDirectory()) {
                dest.delete();
                dest.mkdirs();
                dest.setLastModified(src.lastModified());
            } else {
                File[] children = dest.listFiles();
                if (children != null) {
                    existingChild = Arrays.asList(children);
                }
            }
        } else {
            dest.mkdirs();
            dest.setLastModified(src.lastModified());
        }
        File[] toCopy = src.listFiles();
        if (toCopy != null) {
            for (i = 0; i < toCopy.length; ++i) {
                File childDest = new File(dest, toCopy[i].getName());
                existingChild.remove(childDest);
                if (toCopy[i].isDirectory()) {
                    FileUtil.deepCopy(toCopy[i], childDest, l, overwrite);
                    continue;
                }
                FileUtil.copy(toCopy[i], childDest, l, overwrite);
            }
        }
        for (i = 0; i < existingChild.size(); ++i) {
            FileUtil.forceDelete(existingChild.get(i));
        }
        return true;
    }

    public static void copy(URL src, File dest, CopyProgressListener l) throws IOException {
        URLHandlerRegistry.getDefault().download(src, dest, l);
    }

    public static void copy(File src, URL dest, CopyProgressListener l) throws IOException {
        URLHandlerRegistry.getDefault().upload(src, dest, l);
    }

    public static void copy(InputStream src, File dest, CopyProgressListener l) throws IOException {
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        FileUtil.copy(src, new FileOutputStream(dest), l);
    }

    public static void copy(InputStream src, OutputStream dest, CopyProgressListener l) throws IOException {
        FileUtil.copy(src, dest, l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream src, OutputStream dest, CopyProgressListener l, boolean autoClose) throws IOException {
        CopyProgressEvent evt = null;
        if (l != null) {
            evt = new CopyProgressEvent();
        }
        try {
            int c;
            byte[] buffer = new byte[65536];
            long total = 0L;
            if (l != null) {
                l.start(evt);
            }
            while ((c = src.read(buffer)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("transfer interrupted");
                }
                dest.write(buffer, 0, c);
                total += (long)c;
                if (l == null) continue;
                l.progress(evt.update(buffer, c, total));
            }
            if (l != null) {
                evt.update(EMPTY_BUFFER, 0, total);
            }
            try {
                dest.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (autoClose) {
                src.close();
                dest.close();
            }
        }
        finally {
            if (autoClose) {
                try {
                    src.close();
                }
                catch (IOException iOException) {}
                try {
                    dest.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (l != null) {
            l.end(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntirely(BufferedReader in) throws IOException {
        try {
            StringBuffer buf = new StringBuffer();
            String line = in.readLine();
            while (line != null) {
                buf.append(line + "\n");
                line = in.readLine();
            }
            String string = buf.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    public static boolean forceDelete(File file) {
        File[] files;
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                if (FileUtil.forceDelete(files[i])) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static File resolveFile(File file, String filename) {
        File result = new File(filename);
        if (!result.isAbsolute()) {
            result = new File(file, filename);
        }
        return FileUtil.normalize(result.getPath());
    }

    public static File normalize(String path) {
        Stack<String> s = new Stack<String>();
        String[] dissect = FileUtil.dissect(path);
        s.push(dissect[0]);
        StringTokenizer tok = new StringTokenizer(dissect[1], File.separator);
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken();
            if (".".equals(thisToken)) continue;
            if ("..".equals(thisToken)) {
                if (s.size() < 2) {
                    return new File(path);
                }
                s.pop();
                continue;
            }
            s.push(thisToken);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.size(); ++i) {
            if (i > 1) {
                sb.append(File.separatorChar);
            }
            sb.append(s.elementAt(i));
        }
        return new File(sb.toString());
    }

    private static String[] dissect(String path) {
        char sep = File.separatorChar;
        path = path.replace('/', sep).replace('\\', sep);
        String root = null;
        int colon = path.indexOf(58);
        if (colon > 0) {
            int next = colon + 1;
            root = path.substring(0, next);
            char[] ca = path.toCharArray();
            root = root + sep;
            next = ca[next] == sep ? next + 1 : next;
            StringBuffer sbPath = new StringBuffer();
            for (int i = next; i < ca.length; ++i) {
                if (ca[i] == sep && ca[i - 1] == sep) continue;
                sbPath.append(ca[i]);
            }
            path = sbPath.toString();
        } else if (path.length() > 1 && path.charAt(1) == sep) {
            int nextsep = path.indexOf(sep, 2);
            root = (nextsep = path.indexOf(sep, nextsep + 1)) > 2 ? path.substring(0, nextsep + 1) : path;
            path = path.substring(root.length());
        } else {
            root = File.separator;
            path = path.substring(1);
        }
        return new String[]{root, path};
    }

    public static InputStream unwrapPack200(InputStream packed) throws IOException {
        BufferedInputStream buffered = new BufferedInputStream(packed);
        buffered.mark(4);
        byte[] magic = new byte[4];
        buffered.read(magic, 0, 4);
        buffered.reset();
        FilterInputStream in = buffered;
        if (magic[0] == 31 && magic[1] == -117 && magic[2] == 8) {
            in = new GZIPInputStream(in);
        }
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream jar = new JarOutputStream(baos);
        unpacker.unpack((InputStream)new UncloseInputStream(in), jar);
        jar.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private static final class UncloseInputStream
    extends InputStream {
        private InputStream wrapped;

        public UncloseInputStream(InputStream wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read() throws IOException {
            return this.wrapped.read();
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.wrapped.read(b);
        }

        public boolean equals(Object obj) {
            return this.wrapped.equals(obj);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.wrapped.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.wrapped.skip(n);
        }

        public String toString() {
            return this.wrapped.toString();
        }

        @Override
        public int available() throws IOException {
            return this.wrapped.available();
        }

        @Override
        public void mark(int readlimit) {
            this.wrapped.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.wrapped.reset();
        }

        @Override
        public boolean markSupported() {
            return this.wrapped.markSupported();
        }
    }
}

