/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtForExpression
extends KtLoopExpression {
    public KtForExpression(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitForExpression(this, data);
    }

    @IfNotParsed
    @Nullable
    public KtParameter getLoopParameter() {
        return (KtParameter)this.findChildByType(KtNodeTypes.VALUE_PARAMETER);
    }

    @Nullable
    public KtDestructuringDeclaration getDestructuringDeclaration() {
        KtParameter loopParameter = this.getLoopParameter();
        if (loopParameter == null) {
            return null;
        }
        return loopParameter.getDestructuringDeclaration();
    }

    @IfNotParsed
    @Nullable
    public KtExpression getLoopRange() {
        return this.findExpressionUnder(KtNodeTypes.LOOP_RANGE);
    }

    @IfNotParsed
    @Nullable
    public PsiElement getInKeyword() {
        return this.findChildByType(KtTokens.IN_KEYWORD);
    }

    @NotNull
    public PsiElement getForKeyword() {
        return this.findChildByType(KtTokens.FOR_KEYWORD);
    }
}

