/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.session.scope.internal;

import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.util.Providers;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class SessionScope
implements Scope {
    private static final Provider<Object> SEEDED_KEY_PROVIDER = new Provider<Object>(){

        public Object get() {
            throw new IllegalStateException();
        }
    };
    private final ThreadLocal<LinkedList<ScopeState>> values = new ThreadLocal();

    public void enter() {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null) {
            stack = new LinkedList();
            this.values.set(stack);
        }
        stack.addFirst(new ScopeState());
    }

    public void enter(Memento memento) {
        this.enter();
        this.getScopeState().seeded.putAll(memento.seeded);
    }

    private ScopeState getScopeState() {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null || stack.isEmpty()) {
            throw new IllegalStateException();
        }
        return stack.getFirst();
    }

    public void exit() {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null || stack.isEmpty()) {
            throw new IllegalStateException();
        }
        stack.removeFirst();
        if (stack.isEmpty()) {
            this.values.remove();
        }
    }

    public Memento memento() {
        LinkedList<ScopeState> stack = this.values.get();
        return new Memento(stack != null ? stack.getFirst().seeded : Collections.emptyMap());
    }

    public <T> void seed(Class<T> clazz, Provider<T> value) {
        this.getScopeState().seeded.put(Key.get(clazz), value);
    }

    public <T> void seed(Class<T> clazz, T value) {
        this.getScopeState().seeded.put(Key.get(clazz), Providers.of(value));
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            public T get() {
                LinkedList stack = (LinkedList)SessionScope.this.values.get();
                if (stack == null || stack.isEmpty()) {
                    throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block");
                }
                ScopeState state = (ScopeState)stack.getFirst();
                Provider seeded = (Provider)state.seeded.get(key);
                if (seeded != null) {
                    return seeded.get();
                }
                Object provided = state.provided.get(key);
                if (provided == null && unscoped != null) {
                    provided = unscoped.get();
                    state.provided.put(key, provided);
                }
                return provided;
            }
        };
    }

    public static <T> Provider<T> seededKeyProvider() {
        return SEEDED_KEY_PROVIDER;
    }

    private static final class ScopeState {
        private final Map<Key<?>, Provider<?>> seeded = new HashMap();
        private final Map<Key<?>, Object> provided = new HashMap();

        private ScopeState() {
        }
    }

    public static class Memento {
        final Map<Key<?>, Provider<?>> seeded;

        Memento(Map<Key<?>, Provider<?>> seeded) {
            this.seeded = Collections.unmodifiableMap(new HashMap(seeded));
        }
    }
}

