/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.render.OsmandRenderer;
import net.sourceforge.offroad.ui.OffRoadUIThread;
import net.sourceforge.offroad.ui.OsmBitmapPanel;

class GenerationThread
extends OffRoadUIThread
implements OsmBitmapPanel.IntermediateImageListener {
    protected final RotatedTileBox mTileCopy;
    protected BufferedImage mNewBitmap;
    protected OsmandRenderer.RenderingResult mResult;

    GenerationThread(OsmBitmapPanel pOsmBitmapPanel, RotatedTileBox pTileCopy) {
        super(pOsmBitmapPanel);
        this.mTileCopy = pTileCopy.copy();
    }

    @Override
    public void runInBackground() {
        this.mNewBitmap = this.mOsmBitmapPanel.createImage();
        this.mResult = this.mOsmBitmapPanel.drawImage(this.mNewBitmap, this.mTileCopy, this);
    }

    @Override
    public void runAfterThreadsBeforeHaveFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GenerationThread.this.mOsmBitmapPanel.setImage(GenerationThread.this.mNewBitmap, GenerationThread.this.mTileCopy, GenerationThread.this.mResult);
            }
        });
    }

    @Override
    public void propagateImage() {
        this.runAfterThreadsBeforeHaveFinished();
    }
}

