/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.nntp;

import gnu.inet.nntp.FileNewsrc;
import gnu.inet.nntp.NNTPConnection;
import gnu.inet.nntp.Newsrc;
import gnu.mail.providers.nntp.NNTPRootFolder;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;

public class NNTPStore
extends Store {
    static final Logger logger = Logger.getLogger("gnu.mail.providers.nntp");
    static final Level NNTP_TRACE = NNTPConnection.NNTP_TRACE;
    NNTPConnection connection;
    Newsrc newsrc;
    Folder root;
    Flags permanentFlags = new Flags();

    public NNTPStore(Session session, URLName url) {
        super(session, url);
        this.permanentFlags.add(Flags.Flag.RECENT);
        this.permanentFlags.add(Flags.Flag.SEEN);
        String tn = this.getProperty("newsrc");
        if (tn != null) {
            try {
                ClassLoader l = Thread.currentThread().getContextClassLoader();
                Class<?> t = l.loadClass(tn);
                this.newsrc = (Newsrc)t.newInstance();
            }
            catch (Exception e) {
                logger.log(NNTP_TRACE, "ERROR: unable to instantiate newsrc", e);
            }
        } else {
            File file = null;
            String filename = this.getProperty("newsrc.file");
            if (filename == null) {
                String home = System.getProperty("user.home");
                String baseFilename = ".newsrc";
                StringBuffer buffer = new StringBuffer(baseFilename);
                if (url != null) {
                    buffer.append('-');
                    buffer.append(url.getHost());
                }
                if (!(file = new File(home, buffer.toString())).exists()) {
                    file = new File(home, baseFilename);
                }
            } else {
                file = new File(filename);
            }
            this.newsrc = new FileNewsrc(file, session.getDebug());
        }
    }

    protected boolean protocolConnect(String host, int port, String username, String password) throws MessagingException {
        if (this.connection != null) {
            return true;
        }
        if (host == null) {
            host = this.getProperty("host");
        }
        if (username == null) {
            username = this.getProperty("user");
        }
        if (port < 0) {
            port = this.getIntProperty("port");
        }
        if (host == null) {
            return false;
        }
        try {
            int connectionTimeout = this.getIntProperty("connectiontimeout");
            int timeout = this.getIntProperty("timeout");
            if (port < 0) {
                port = 119;
            }
            if (this.session.getDebug()) {
                NNTPConnection.logger.setLevel(NNTPConnection.NNTP_TRACE);
            }
            this.connection = new NNTPConnection(host, port, connectionTimeout, timeout);
            if (username != null && password != null) {
                return this.connection.authinfo(username, password);
            }
            return true;
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MessagingException {
        try {
            this.newsrc.close();
            NNTPConnection nNTPConnection = this.connection;
            synchronized (nNTPConnection) {
                this.connection.quit();
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        super.close();
    }

    public Folder getDefaultFolder() throws MessagingException {
        if (this.root == null) {
            this.root = new NNTPRootFolder(this);
        }
        return this.root;
    }

    public Folder getFolder(String name) throws MessagingException {
        return this.getDefaultFolder().getFolder(name);
    }

    public Folder getFolder(URLName url) throws MessagingException {
        return this.getDefaultFolder().getFolder(url.getFile());
    }

    boolean isListAll() {
        return this.propertyIsTrue("listall");
    }

    private int getIntProperty(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return -1;
    }

    private boolean propertyIsFalse(String key) {
        return "false".equals(this.getProperty(key));
    }

    private boolean propertyIsTrue(String key) {
        return "true".equals(this.getProperty(key));
    }

    private String getProperty(String key) {
        String value = this.session.getProperty("mail.nntp." + key);
        if (value == null) {
            value = this.session.getProperty("mail." + key);
        }
        return value;
    }
}

