/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_gd extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u00c0m Meadhan Afraga",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Bun-\u00e0m Mhosgo",
               "MSK",
               "T\u00ecde samhraidh Mhosgo",
               "MSD",
               "\u00c0m Mhosgo",
               "MT",
            };
        final String[] Japan = new String[] {
               "Bun-\u00e0m na Seapaine",
               "JST",
               "T\u00ecde samhraidh na Seapaine",
               "JDT",
               "\u00c0m na Seapaine",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Bun-\u00e0m Pagast\u00e0in",
               "PKT",
               "T\u00ecde samhraidh Pagast\u00e0in",
               "PKST",
               "\u00c0m Pagast\u00e0in",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Bun-\u00e0m Taipei",
               "CST",
               "T\u00ecde samhraidh Taipei",
               "CDT",
               "\u00c0m Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Bun-\u00e0m Hovd",
               "HOVT",
               "T\u00ecde samhraidh Hovd",
               "HOVST",
               "\u00c0m Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Bun-\u00e0m Magadan",
               "MAGT",
               "T\u00ecde Samhraidh Magadan",
               "MAGST",
               "\u00c0m Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Bun-\u00e0m Meadhan Astr\u00e0ilia an Iar",
               "ACWST",
               "T\u00ecde samhraidh Meadhan Astr\u00e0ilia an Iar",
               "ACWDT",
               "\u00c0m Meadhan Astr\u00e0ilia an Iar",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Bun-\u00e0m Meadhan na Roinn-E\u00f2rpa",
               "CET",
               "T\u00ecde samhraidh Meadhan na Roinn-E\u00f2rpa",
               "CEST",
               "\u00c0m Meadhan na Roinn-E\u00f2rpa",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Bun-\u00e0m Sakhalin",
               "SAKT",
               "T\u00ecde samhraidh Sakhalin",
               "SAKST",
               "\u00c0m Sakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Bun-\u00e0m Paraguaidh",
               "PYT",
               "T\u00ecde samhraidh Paraguaidh",
               "PYST",
               "\u00c0m Paraguaidh",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Bun-\u00e0m Acre",
               "ACT",
               "T\u00ecde samhraidh Acre",
               "ACST",
               "\u00c0m Acre",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "\u00c0m Mhalaidhsea",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Bun-\u00e0m Aimeireaga a Tuath an Ear",
               "EST",
               "T\u00ecde samhraidh Aimeireaga a Tuath an Ear",
               "EDT",
               "\u00c0m Aimeireaga a Tuath an Ear",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Bun-\u00e0m Lord Howe",
               "LHST",
               "T\u00ecde samhraidh Lord Howe",
               "LHDT",
               "\u00c0m Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Bun-\u00e0m Shealainn Nuaidh",
               "NZST",
               "T\u00ecde samhraidh Shealainn Nuaidh",
               "NZDT",
               "\u00c0m Shealainn Nuaidh",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u00c0m Cuan nan Innseachan",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Bun-\u00e0m Yakutsk",
               "YAKT",
               "T\u00ecde samhraidh Yakutsk",
               "YAKST",
               "\u00c0m Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Bun-\u00e0m nan Eileanan Mhoiriseas",
               "MUT",
               "T\u00ecde samhraidh nan Eileanan Mhoiriseas",
               "MUST",
               "\u00c0m nan Eileanan Mhoiriseas",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u00c0m Afraga an Ear",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u00c0m Th\u00ecomor an Ear",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "\u00c0m Eileanan Sholaimh",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "\u00c0m Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "\u00c0m Eileanan Mharshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Bun-\u00e0m na Roinn-E\u00f2rpa an Ear",
               "EET",
               "T\u00ecde samhraidh na Roinn-E\u00f2rpa an Ear",
               "EEST",
               "\u00c0m na Roinn-E\u00f2rpa an Ear",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Bun-\u00e0m Talamh an \u00c8isg",
               "NST",
               "T\u00ecde samhraidh Talamh an \u00c8isg",
               "NDT",
               "\u00c0m Talamh an \u00c8isg",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "\u00c0m Afghanast\u00e0in",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Bun-\u00e0m Hong Kong",
               "HKT",
               "T\u00ecde samhraidh Hong Kong",
               "HKST",
               "\u00c0m Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Bun-\u00e0m na h-Argantaine Siaraich",
               "ART",
               "T\u00ecde samhraidh na h-Argantaine Siaraich",
               "ARST",
               "\u00c0m na h-Argantaine Siaraich",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Bun-\u00e0m a\u2019 Chuain Siar",
               "AST",
               "T\u00ecde samhraidh a\u2019 Chuain Siar",
               "ADT",
               "\u00c0m a\u2019 Chuain Siar",
               "AT",
            };
        final String[] Ponape = new String[] {
               "\u00c0m Pohnpei",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "\u00c0m Boilibhia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Bun-\u00e0m Saint Pierre agus Miquelon",
               "PMST",
               "T\u00ecde Samhraidh Saint Pierre agus Miquelon",
               "PMDT",
               "\u00c0m Saint Pierre agus Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "\u00c0m S\u00ecn-Innseanach",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Bun-\u00e0m Yekaterinburg",
               "YEKT",
               "T\u00ecde samhraidh Yekaterinburg",
               "YEKST",
               "\u00c0m Yekaterinburg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "\u00c0m nan Eileanan Mhaladaibh",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "\u00c0m Tahiti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Bun-\u00e0m Iosrael",
               "IST",
               "T\u00ecde samhraidh Iosrael",
               "IDT",
               "\u00c0m Iosrael",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u00c0m Meadhan nan Innd-Innse",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "\u00c0m Uallas agus Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "\u00c0m Afraga a Deas",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u00c0m Shyowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "\u00c0m Eileanan Teraina",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Bun-\u00e0m Usbagast\u00e0n",
               "UZT",
               "T\u00ecde samhraidh Usbagast\u00e0n",
               "UZST",
               "\u00c0m Usbagast\u00e0n",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Bun-\u00e0m Omsk",
               "OMST",
               "T\u00ecde samhraidh Omsk",
               "OMSST",
               "\u00c0m Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "\u00c0m nan Eileanan Sheiseall",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Bun-\u00e0m Uruguaidh",
               "UYT",
               "T\u00ecde samhraidh Uruguaidh",
               "UYST",
               "\u00c0m Uruguaidh",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "\u00c0m Neap\u00e0l",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Bun-\u00e0m Ulan Bator",
               "ULAT",
               "T\u00ecde samhraidh Ulan Bator",
               "ULAST",
               "\u00c0m Ulan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Bun-\u00e0m Meadhan Aimeireaga a Tuath",
               "CST",
               "T\u00ecde samhraidh Meadhan Aimeireaga a Tuath",
               "CDT",
               "\u00c0m Meadhan Aimeireaga a Tuath",
               "CT",
            };
        final String[] Truk = new String[] {
               "\u00c0m Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "\u00c0m Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "\u00c0m Eilean Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Bun-\u00e0m nan Eileanan F\u00e0clannach",
               "FKT",
               "T\u00ecde samhraidh nan Eileanan F\u00e0clannach",
               "FKST",
               "\u00c0m nan Eileanan F\u00e0clannach",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Bun-\u00e0m Vanuatu",
               "VUT",
               "T\u00ecde samhraidh Vanuatu",
               "VUST",
               "\u00c0m Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Bun-\u00e0m Novosibirsk",
               "NOVT",
               "T\u00ecde samhraidh Novosibirsk",
               "NOVST",
               "\u00c0m Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "\u00c0m Singeap\u00f2r",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Bun-\u00e0m nan Eileanan Asorach",
               "AZOT",
               "T\u00ecde samhraidh nan Eileanan Asorach",
               "AZOST",
               "\u00c0m nan Eileanan Asorach",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Bun-\u00e0m Apia",
               "WSST",
               "T\u00ecde samhraidh Apia",
               "WSDT",
               "\u00c0m Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "\u00c0m But\u00e0in",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "\u00c0m Suranaim",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "\u00c0m Nabhru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Bun-\u00e0m Krasnoyarsk",
               "KRAT",
               "T\u00ecde samhraidh Krasnoyarsk",
               "KRAST",
               "\u00c0m Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u00c0m Casachst\u00e0in an Iar",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "\u00c0m Mi\u00e0nmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "\u00c0m Eilean na Nollaig",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Bun-\u00e0m Amasoin",
               "AMT",
               "T\u00ecde samhraidh Amasoin",
               "AMST",
               "\u00c0m Amasoin",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u00c0m Casachst\u00e0in an Ear",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Bun-\u00e0m F\u00ecdi",
               "FJT",
               "T\u00ecde samhraidh F\u00ecdi",
               "FJST",
               "\u00c0m F\u00ecdi",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "\u00c0m Reunion",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "\u00c0m Eileanan Chocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Bun-\u00e0m Chatham",
               "CHAST",
               "T\u00ecde samhraidh Chatham",
               "CHADT",
               "\u00c0m Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "\u00c0m Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Bun-\u00e0m na h-Argantaine",
               "ART",
               "T\u00ecde samhraidh na h-Argantaine",
               "ARST",
               "\u00c0m na h-Argantaine",
               "ART",
            };
        final String[] Gambier = new String[] {
               "\u00c0m Ghambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Bun-\u00e0m Petropavlovsk-Kamchatsky",
               "PETT",
               "T\u00ecde samhraidh Petropavlovsk-Kamchatsky",
               "PETST",
               "\u00c0m Petropavlovsk-Kamchatsky",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "\u00c0m Tubhalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "\u00c0m Ghalapagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "\u00c0m Eilein MhicGuaire",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "\u00c0m na Bheiniseala",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Bun-\u00e0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
               "HAST",
               "T\u00ecde Samhraidh nan Eileanan Hawai\u2019i \u2019s Aleutach",
               "HADT",
               "\u00c0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Bun-\u00e0m Meadhan Astr\u00e0ilia",
               "ACST",
               "T\u00ecde samhraidh Meadhan Astr\u00e0ilia",
               "ACDT",
               "\u00c0m Meadhan Astr\u00e0ilia",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Bun-\u00e0m a\u2019 Chuain S\u00e8imh",
               "PST",
               "T\u00ecde samhraidh a\u2019 Chuain S\u00e8imh",
               "PDT",
               "\u00c0m a\u2019 Chuain S\u00e8imh",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u00c0m Eileanan Phoenix",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Bun-\u00e0m Turcmanast\u00e0in",
               "TMT",
               "T\u00ecde samhraidh Turcmanast\u00e0in",
               "TMST",
               "\u00c0m Turcmanast\u00e0in",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Bun-\u00e0m na Roinn-E\u00f2rpa an Iar",
               "WET",
               "T\u00ecde samhraidh na Roinn-E\u00f2rpa an Iar",
               "WEST",
               "\u00c0m na Roinn-E\u00f2rpa an Iar",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Bun-\u00e0m a\u2019 Chip Uaine",
               "CVT",
               "T\u00ecde samhraidh a\u2019 Chip Uaine",
               "CVST",
               "\u00c0m a\u2019 Chip Uaine",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "\u00c0m Eilein Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "\u00c0m Guidhe\u00e0na",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "\u00c0m Peit a\u2019 Ch\u00e0irn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "\u00c0m Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Bun-\u00e0m Samotha",
               "SST",
               "T\u00ecde samhraidh Samotha",
               "SDT",
               "\u00c0m Samotha",
               "ST",
            };
        final String[] Palau = new String[] {
               "\u00c0m Palabh",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "\u00c0m na Roinn-E\u00f2rpa nas fhaide ear",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Bun-\u00e0m Asarbaide\u00e0in",
               "AZT",
               "T\u00ecde samhraidh Asarbaide\u00e0in",
               "AZST",
               "\u00c0m Asarbaide\u00e0in",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "\u00c0m Mhawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Bun-\u00e0m a\u2019 Chuain S\u00e8imh Mheagsago",
               "MST",
               "T\u00ecde samhraidh a\u2019 Chuain S\u00e8imh Mheagsago",
               "MDT",
               "\u00c0m a\u2019 Chuain S\u00e8imh Mheagsago",
               "MT",
            };
        final String[] Davis = new String[] {
               "\u00c0m Dhavis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Bun-\u00e0m C\u00f9ba",
               "CST",
               "T\u00ecde samhraidh C\u00f9ba",
               "CDT",
               "\u00c0m C\u00f9ba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Bun-\u00e0m Afraga an Iar",
               "CAT",
               "T\u00ecde Samhraidh Afraga an Iar",
               "CAST",
               "\u00c0m Afraga an Iar",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Bun-\u00e0m nan Eilean Filipineach",
               "PHT",
               "T\u00ecde samhraidh nan Eilean Filipineach",
               "PHST",
               "\u00c0m nan Eilean Filipineach",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "\u00c0m Deasach agus Antartaigeach na Frainge",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "\u00c0m Se\u00f2rsea a Deas",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Bun-\u00e0m Chailleann Nuaidh",
               "NCT",
               "T\u00ecde samhraidh Chailleann Nuaidh",
               "NCST",
               "\u00c0m Chailleann Nuaidh",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "\u00c0m Bhr\u00f9naigh D\u00e0r as-Sal\u00e0m",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Bun-\u00e0m Ior\u00e0in",
               "IRST",
               "T\u00ecde samhraidh Ior\u00e0in",
               "IRDT",
               "\u00c0m Ior\u00e0in",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Bun-\u00e0m Eilean na C\u00e0isge",
               "EAST",
               "T\u00ecde samhraidh Eilean na C\u00e0isge",
               "EASST",
               "\u00c0m Eilean na C\u00e0isge",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Bun-\u00e0m Mheagsago an Iar-thuath",
               "PST",
               "T\u00ecde samhraidh Mheagsago an Iar-thuath",
               "PDT",
               "\u00c0m Mheagsago an Iar-thuath",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "\u00c0m Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "\u00c0m Taidigeast\u00e0in",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Bun-\u00e0m Tonga",
               "TOT",
               "T\u00ecde samhraidh Tonga",
               "TOST",
               "\u00c0m Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Bun-\u00e0m Bangladais",
               "BDT",
               "T\u00ecde samhraidh Bangladais",
               "BDST",
               "\u00c0m Bangladais",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Bun-\u00e0m Pear\u00f9",
               "PET",
               "T\u00ecde samhraidh Pear\u00f9",
               "PEST",
               "\u00c0m Pear\u00f9",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Bun-\u00e0m na Graonlainn an Iar",
               "WGT",
               "T\u00ecde samhraidh na Graonlainn an Iar",
               "WGST",
               "\u00c0m na Graonlainn an Iar",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\u00c0m Eacuadoir",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Bun-\u00e0m na Graonlainn an Ear",
               "EGT",
               "T\u00ecde samhraidh na Graonlainn an Ear",
               "EGST",
               "\u00c0m na Graonlainn an Ear",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u00c0m a\u2019 Chamais",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u00c0m nan Innd-Innse an Ear",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Bun-\u00e0m Choir\u00e8a",
               "KST",
               "T\u00ecde samhraidh Choir\u00e8a",
               "KDT",
               "\u00c0m Choir\u00e8a",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Bun-\u00e0m Astr\u00e0ilia an Iar",
               "AWST",
               "T\u00ecde samhraidh Astr\u00e0ilia an Iar",
               "AWDT",
               "\u00c0m Astr\u00e0ilia an Iar",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "\u00c0m C\u00ecorgastain",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u00c0m nan Innd-Innse an Iar",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Bun-\u00e0m Astr\u00e0ilia an Ear",
               "AEST",
               "T\u00ecde samhraidh Astr\u00e0ilia an Ear",
               "AEDT",
               "\u00c0m Astr\u00e0ilia an Ear",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "\u00c0m Guidhe\u00e0na na Frainge",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Bun-\u00e0m Coloimbia",
               "COT",
               "T\u00ecde samhraidh Coloimbia",
               "COST",
               "\u00c0m Coloimbia",
               "COT",
            };
        final String[] Chile = new String[] {
               "Bun-\u00e0m na Sile",
               "CLT",
               "T\u00ecde samhraidh na Sile",
               "CLST",
               "\u00c0m na Sile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u00c0m Eileanan Ghileabairt",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Bun-\u00e0m Monadh Aimeireaga a Tuath",
               "MST",
               "T\u00ecde samhraidh Monadh Aimeireaga a Tuath",
               "MDT",
               "\u00c0m Monadh Aimeireaga a Tuath",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "\u00c0m Eileanan a\u2019 Mharcais",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Bun-\u00e0m Arabach",
               "AST",
               "T\u00ecde samhraidh Arabach",
               "ADT",
               "\u00c0m Arabach",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Bun-\u00e0m Alaska",
               "AKST",
               "T\u00ecde samhraidh Alaska",
               "AKDT",
               "\u00c0m Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Bun-\u00e0m Vladivostok",
               "VLAT",
               "T\u00ecde Samhraidh Vladivostok",
               "VLAST",
               "\u00c0m Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "\u00c0m Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Bun-\u00e0m Irkutsk",
               "IRKT",
               "T\u00ecde Samhraidh Irkutsk",
               "IRKST",
               "\u00c0m Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Bun-\u00e0m na Cairtbheile",
               "GET",
               "T\u00ecde samhraidh na Cairtbheile",
               "GEST",
               "\u00c0m na Cairtbheile",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "\u00c0m Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u00c0m Gini Nuaidh Paputhaiche",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Bun-\u00e0m Fernando de Noronha",
               "FNT",
               "T\u00ecde Samhraidh Fernando de Noronha",
               "FNST",
               "\u00c0m Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Bun-\u00e0m Choibalsan",
               "CHOT",
               "T\u00ecde samhraidh Choibalsan",
               "CHOST",
               "\u00c0m Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Bun-\u00e0m Bhrasilia",
               "BRT",
               "T\u00ecde samhraidh Bhrasilia",
               "BRST",
               "\u00c0m Bhrasilia",
               "BRT",
            };
        final String[] China = new String[] {
               "Bun-\u00e0m na S\u00ecne",
               "CST",
               "T\u00ecde samhraidh na S\u00ecne",
               "CDT",
               "\u00c0m na S\u00ecne",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Bun-\u00e0m Airmeinia",
               "AMT",
               "T\u00ecde samhraidh Airmeinia",
               "AMST",
               "\u00c0m Airmeinia",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Bun-\u00e0m Samara",
               "SAMT",
               "T\u00ecde samhraidh Samara",
               "SAMST",
               "\u00c0m Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "\u00c0m nan Innseachan",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Bun-\u00e0m Eileanan Cook",
               "CKT",
               "Leth-th\u00ecde samhraidh Eileanan Cook",
               "CKHST",
               "\u00c0m Eileanan Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Bun-\u00e0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HST",
                    "T\u00ecde Samhraidh nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HDT",
                    "\u00c0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "T\u00ecde samhraidh Bhreatainn",
                    "TSB",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Bun-\u00e0m na h-\u00c8ireann",
                    "TS\u00c8 (\u00c8irinn)",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
