/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS_POSIX;
import org.eclipse.jgit.util.FS_Win32;
import org.eclipse.jgit.util.FS_Win32_Cygwin;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FS {
    private static final Logger LOG = LoggerFactory.getLogger(FS.class);
    public static final FS DETECTED = FS.detect();
    private static volatile FSFactory factory;
    private volatile Holder<File> userHome;
    private volatile Holder<File> gitSystemConfig;

    public static FS detect() {
        return FS.detect(null);
    }

    public static FS detect(Boolean cygwinUsed) {
        if (factory == null) {
            factory = new FSFactory();
        }
        return factory.detect(cygwinUsed);
    }

    protected FS() {
    }

    protected FS(FS src) {
        this.userHome = src.userHome;
        this.gitSystemConfig = src.gitSystemConfig;
    }

    public abstract FS newInstance();

    public abstract boolean supportsExecute();

    public boolean supportsAtomicCreateNewFile() {
        return true;
    }

    public boolean supportsSymlinks() {
        return false;
    }

    public abstract boolean isCaseSensitive();

    public abstract boolean canExecute(File var1);

    public abstract boolean setExecute(File var1, boolean var2);

    public long lastModified(File f) throws IOException {
        return FileUtils.lastModified(f);
    }

    public void setLastModified(File f, long time2) throws IOException {
        FileUtils.setLastModified(f, time2);
    }

    public long length(File path2) throws IOException {
        return FileUtils.getLength(path2);
    }

    public void delete(File f) throws IOException {
        FileUtils.delete(f);
    }

    public File resolve(File dir2, String name2) {
        File abspn = new File(name2);
        if (abspn.isAbsolute()) {
            return abspn;
        }
        return new File(dir2, name2);
    }

    public File userHome() {
        Holder<File> p = this.userHome;
        if (p == null) {
            this.userHome = p = new Holder<File>(this.userHomeImpl());
        }
        return (File)p.value;
    }

    public FS setUserHome(File path2) {
        this.userHome = new Holder<File>(path2);
        return this;
    }

    public abstract boolean retryFailedLockFileCommit();

    protected File userHomeImpl() {
        String home = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.home");
            }
        });
        if (home == null || home.length() == 0) {
            return null;
        }
        return new File(home).getAbsoluteFile();
    }

    protected static File searchPath(String path2, String ... lookFor) {
        if (path2 == null) {
            return null;
        }
        for (String p : path2.split(File.pathSeparator)) {
            for (String command : lookFor) {
                File e2 = new File(p, command);
                if (!e2.isFile()) continue;
                return e2.getAbsoluteFile();
            }
        }
        return null;
    }

    @Nullable
    protected static String readPipe(File dir2, String[] command, String encoding2) throws CommandFailedException {
        return FS.readPipe(dir2, command, encoding2, null);
    }

    @Nullable
    protected static String readPipe(File dir2, String[] command, String encoding2, Map<String, String> env) throws CommandFailedException {
        boolean debug = LOG.isDebugEnabled();
        try {
            Process p;
            if (debug) {
                LOG.debug("readpipe " + Arrays.asList(command) + "," + dir2);
            }
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(dir2);
            if (env != null) {
                pb.environment().putAll(env);
            }
            try {
                p = pb.start();
            }
            catch (IOException e2) {
                throw new CommandFailedException(-1, e2.getMessage(), e2);
            }
            p.getOutputStream().close();
            GobblerThread gobbler = new GobblerThread(p, command, dir2);
            gobbler.start();
            String r = null;
            try (BufferedReader lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), encoding2));){
                r = lineRead.readLine();
                if (debug) {
                    String l;
                    LOG.debug("readpipe may return '" + r + "'");
                    LOG.debug("remaining output:\n");
                    while ((l = lineRead.readLine()) != null) {
                        LOG.debug(l);
                    }
                }
            }
            while (true) {
                try {
                    int rc = p.waitFor();
                    gobbler.join();
                    if (rc == 0 && !gobbler.fail.get()) {
                        return r;
                    }
                    if (debug) {
                        LOG.debug("readpipe rc=" + rc);
                    }
                    throw new CommandFailedException(rc, gobbler.errorMessage.get(), gobbler.exception.get());
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e3) {
            LOG.error("Caught exception in FS.readPipe()", e3);
            if (debug) {
                LOG.debug("readpipe returns null");
            }
            return null;
        }
    }

    protected abstract File discoverGitExe();

    protected File discoverGitSystemConfig() {
        String w;
        String v;
        File gitExe = this.discoverGitExe();
        if (gitExe == null) {
            return null;
        }
        try {
            v = FS.readPipe(gitExe.getParentFile(), new String[]{"git", "--version"}, Charset.defaultCharset().name());
        }
        catch (CommandFailedException e2) {
            LOG.warn(e2.getMessage());
            return null;
        }
        if (StringUtils.isEmptyOrNull(v) || v != null && v.startsWith("jgit")) {
            return null;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("GIT_EDITOR", "echo");
        try {
            w = FS.readPipe(gitExe.getParentFile(), new String[]{"git", "config", "--system", "--edit"}, Charset.defaultCharset().name(), env);
        }
        catch (CommandFailedException e3) {
            LOG.warn(e3.getMessage());
            return null;
        }
        if (StringUtils.isEmptyOrNull(w)) {
            return null;
        }
        return new File(w);
    }

    public File getGitSystemConfig() {
        if (this.gitSystemConfig == null) {
            this.gitSystemConfig = new Holder<File>(this.discoverGitSystemConfig());
        }
        return (File)this.gitSystemConfig.value;
    }

    public FS setGitSystemConfig(File configFile) {
        this.gitSystemConfig = new Holder<File>(configFile);
        return this;
    }

    protected static File resolveGrandparentFile(File grandchild) {
        File parent;
        if (grandchild != null && (parent = grandchild.getParentFile()) != null) {
            return parent.getParentFile();
        }
        return null;
    }

    public String readSymLink(File path2) throws IOException {
        return FileUtils.readSymLink(path2);
    }

    public boolean isSymLink(File path2) throws IOException {
        return FileUtils.isSymlink(path2);
    }

    public boolean exists(File path2) {
        return FileUtils.exists(path2);
    }

    public boolean isDirectory(File path2) {
        return FileUtils.isDirectory(path2);
    }

    public boolean isFile(File path2) {
        return FileUtils.isFile(path2);
    }

    public boolean isHidden(File path2) throws IOException {
        return FileUtils.isHidden(path2);
    }

    public void setHidden(File path2, boolean hidden) throws IOException {
        FileUtils.setHidden(path2, hidden);
    }

    public void createSymLink(File path2, String target) throws IOException {
        FileUtils.createSymLink(path2, target);
    }

    public boolean createNewFile(File path2) throws IOException {
        return path2.createNewFile();
    }

    public String relativize(String base, String other) {
        return FileUtils.relativizePath(base, other, File.separator, this.isCaseSensitive());
    }

    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args) throws JGitInternalException {
        return this.runHookIfPresent(repository, hookName, args, System.out, System.err, null);
    }

    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args, PrintStream outRedirect, PrintStream errRedirect, String stdinArgs) throws JGitInternalException {
        return new ProcessResult(ProcessResult.Status.NOT_SUPPORTED);
    }

    protected ProcessResult internalRunHookIfPresent(Repository repository, String hookName, String[] args, PrintStream outRedirect, PrintStream errRedirect, String stdinArgs) throws JGitInternalException {
        File hookFile = this.findHook(repository, hookName);
        if (hookFile == null) {
            return new ProcessResult(ProcessResult.Status.NOT_PRESENT);
        }
        String hookPath = hookFile.getAbsolutePath();
        File runDirectory = repository.isBare() ? repository.getDirectory() : repository.getWorkTree();
        String cmd = this.relativize(runDirectory.getAbsolutePath(), hookPath);
        ProcessBuilder hookProcess = this.runInShell(cmd, args);
        hookProcess.directory(runDirectory);
        try {
            return new ProcessResult(this.runProcess(hookProcess, (OutputStream)outRedirect, (OutputStream)errRedirect, stdinArgs), ProcessResult.Status.OK);
        }
        catch (IOException e2) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfHook, hookName), e2);
        }
        catch (InterruptedException e3) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionHookExecutionInterrupted, hookName), e3);
        }
    }

    public File findHook(Repository repository, String hookName) {
        File gitDir = repository.getDirectory();
        if (gitDir == null) {
            return null;
        }
        File hookFile = new File(new File(gitDir, "hooks"), hookName);
        return hookFile.isFile() ? hookFile : null;
    }

    public int runProcess(ProcessBuilder processBuilder, OutputStream outRedirect, OutputStream errRedirect, String stdinArgs) throws IOException, InterruptedException {
        ByteArrayInputStream in = stdinArgs == null ? null : new ByteArrayInputStream(stdinArgs.getBytes("UTF-8"));
        return this.runProcess(processBuilder, outRedirect, errRedirect, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runProcess(ProcessBuilder processBuilder, OutputStream outRedirect, OutputStream errRedirect, InputStream inRedirect) throws IOException, InterruptedException {
        IOException ioException;
        block36: {
            int n;
            ExecutorService executor = Executors.newFixedThreadPool(2);
            Process process = null;
            ioException = null;
            try {
                process = processBuilder.start();
                executor.execute(new StreamGobbler(process.getErrorStream(), errRedirect));
                executor.execute(new StreamGobbler(process.getInputStream(), outRedirect));
                OutputStream outputStream = process.getOutputStream();
                if (inRedirect != null) {
                    new StreamGobbler(inRedirect, outputStream).copy();
                }
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                n = process.waitFor();
            }
            catch (IOException e2) {
                try {
                    ioException = e2;
                }
                catch (Throwable throwable) {
                    FS.shutdownAndAwaitTermination(executor);
                    if (process != null) {
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException e3) {
                            Thread.interrupted();
                        }
                        if (inRedirect != null) {
                            inRedirect.close();
                        }
                        try {
                            process.getErrorStream().close();
                        }
                        catch (IOException e4) {
                            ioException = ioException != null ? ioException : e4;
                        }
                        try {
                            process.getInputStream().close();
                        }
                        catch (IOException e5) {
                            ioException = ioException != null ? ioException : e5;
                        }
                        try {
                            process.getOutputStream().close();
                        }
                        catch (IOException e6) {
                            ioException = ioException != null ? ioException : e6;
                        }
                        process.destroy();
                    }
                    throw throwable;
                }
                FS.shutdownAndAwaitTermination(executor);
                if (process == null) break block36;
                try {
                    process.waitFor();
                }
                catch (InterruptedException e7) {
                    Thread.interrupted();
                }
                if (inRedirect != null) {
                    inRedirect.close();
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException e8) {
                    ioException = ioException != null ? ioException : e8;
                }
                try {
                    process.getInputStream().close();
                }
                catch (IOException e9) {
                    ioException = ioException != null ? ioException : e9;
                }
                try {
                    process.getOutputStream().close();
                }
                catch (IOException e10) {
                    ioException = ioException != null ? ioException : e10;
                }
                process.destroy();
            }
            FS.shutdownAndAwaitTermination(executor);
            if (process != null) {
                try {
                    process.waitFor();
                }
                catch (InterruptedException e11) {
                    Thread.interrupted();
                }
                if (inRedirect != null) {
                    inRedirect.close();
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException e12) {
                    ioException = ioException != null ? ioException : e12;
                }
                try {
                    process.getInputStream().close();
                }
                catch (IOException e13) {
                    ioException = ioException != null ? ioException : e13;
                }
                try {
                    process.getOutputStream().close();
                }
                catch (IOException e14) {
                    ioException = ioException != null ? ioException : e14;
                }
                process.destroy();
            }
            return n;
        }
        throw ioException;
    }

    private static boolean shutdownAndAwaitTermination(ExecutorService pool) {
        boolean hasShutdown = true;
        pool.shutdown();
        try {
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    hasShutdown = false;
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
            hasShutdown = false;
        }
        return hasShutdown;
    }

    public abstract ProcessBuilder runInShell(String var1, String[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult execute(ProcessBuilder pb, InputStream in) throws IOException, InterruptedException {
        TemporaryBuffer.LocalFile stdout = new TemporaryBuffer.LocalFile(null);
        TemporaryBuffer.Heap stderr = new TemporaryBuffer.Heap(1024, 0x100000);
        try {
            int rc = this.runProcess(pb, (OutputStream)stdout, (OutputStream)stderr, in);
            ExecutionResult executionResult = new ExecutionResult(stdout, stderr, rc);
            return executionResult;
        }
        finally {
            stdout.close();
            stderr.close();
        }
    }

    public Attributes getAttributes(File path2) {
        boolean isFile;
        boolean isDirectory = this.isDirectory(path2);
        boolean bl = isFile = !isDirectory && path2.isFile();
        assert (path2.exists() == isDirectory || isFile);
        boolean exists = isDirectory || isFile;
        boolean canExecute = exists && !isDirectory && this.canExecute(path2);
        boolean isSymlink = false;
        long lastModified = exists ? path2.lastModified() : 0L;
        long createTime = 0L;
        return new Attributes(this, path2, exists, isDirectory, canExecute, isSymlink, isFile, createTime, lastModified, -1L);
    }

    public File normalize(File file2) {
        return file2;
    }

    public String normalize(String name2) {
        return name2;
    }

    public static class Attributes {
        private final boolean isDirectory;
        private final boolean isSymbolicLink;
        private final boolean isRegularFile;
        private final long creationTime;
        private final long lastModifiedTime;
        private final boolean isExecutable;
        private final File file;
        private final boolean exists;
        protected long length = -1L;
        final FS fs;

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public boolean isExecutable() {
            return this.isExecutable;
        }

        public boolean isSymbolicLink() {
            return this.isSymbolicLink;
        }

        public boolean isRegularFile() {
            return this.isRegularFile;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        Attributes(FS fs, File file2, boolean exists, boolean isDirectory, boolean isExecutable, boolean isSymbolicLink, boolean isRegularFile, long creationTime, long lastModifiedTime, long length) {
            this.fs = fs;
            this.file = file2;
            this.exists = exists;
            this.isDirectory = isDirectory;
            this.isExecutable = isExecutable;
            this.isSymbolicLink = isSymbolicLink;
            this.isRegularFile = isRegularFile;
            this.creationTime = creationTime;
            this.lastModifiedTime = lastModifiedTime;
            this.length = length;
        }

        public Attributes(File path2, FS fs) {
            this(fs, path2, false, false, false, false, false, 0L, 0L, 0L);
        }

        public long getLength() {
            if (this.length == -1L) {
                this.length = this.file.length();
                return this.length;
            }
            return this.length;
        }

        public String getName() {
            return this.file.getName();
        }

        public File getFile() {
            return this.file;
        }

        boolean exists() {
            return this.exists;
        }
    }

    public static class ExecutionResult {
        private TemporaryBuffer stdout;
        private TemporaryBuffer stderr;
        private int rc;

        public ExecutionResult(TemporaryBuffer stdout, TemporaryBuffer stderr, int rc) {
            this.stdout = stdout;
            this.stderr = stderr;
            this.rc = rc;
        }

        public TemporaryBuffer getStdout() {
            return this.stdout;
        }

        public TemporaryBuffer getStderr() {
            return this.stderr;
        }

        public int getRc() {
            return this.rc;
        }
    }

    public static class FSFactory {
        protected FSFactory() {
        }

        public FS detect(Boolean cygwinUsed) {
            if (SystemReader.getInstance().isWindows()) {
                if (cygwinUsed == null) {
                    cygwinUsed = FS_Win32_Cygwin.isCygwin();
                }
                if (cygwinUsed.booleanValue()) {
                    return new FS_Win32_Cygwin();
                }
                return new FS_Win32();
            }
            return new FS_POSIX();
        }
    }

    private static class GobblerThread
    extends Thread {
        private static final int PROCESS_EXIT_TIMEOUT = 5;
        private final Process p;
        private final String desc;
        private final String dir;
        final AtomicBoolean fail = new AtomicBoolean();
        final AtomicReference<String> errorMessage = new AtomicReference();
        final AtomicReference<Throwable> exception = new AtomicReference();

        GobblerThread(Process p, String[] command, File dir2) {
            this.p = p;
            this.desc = Arrays.toString(command);
            this.dir = Objects.toString(dir2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuilder err = new StringBuilder();
            try (InputStream is2 = this.p.getErrorStream();){
                int ch;
                while ((ch = is2.read()) != -1) {
                    err.append((char)ch);
                }
            }
            catch (IOException e2) {
                if (this.waitForProcessCompletion(e2) && this.p.exitValue() != 0) {
                    this.setError(e2, e2.getMessage(), this.p.exitValue());
                    this.fail.set(true);
                }
            }
            finally {
                if (this.waitForProcessCompletion(null) && err.length() > 0) {
                    this.setError(null, err.toString(), this.p.exitValue());
                    if (this.p.exitValue() != 0) {
                        this.fail.set(true);
                    }
                }
            }
        }

        private boolean waitForProcessCompletion(IOException originalError) {
            try {
                if (!this.p.waitFor(5L, TimeUnit.SECONDS)) {
                    this.setError(originalError, MessageFormat.format(JGitText.get().commandClosedStderrButDidntExit, this.desc, 5), -1);
                    this.fail.set(true);
                }
            }
            catch (InterruptedException e2) {
                LOG.error(MessageFormat.format(JGitText.get().threadInterruptedWhileRunning, this.desc), e2);
            }
            return false;
        }

        private void setError(IOException e2, String message, int exitCode) {
            this.exception.set(e2);
            this.errorMessage.set(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfCommand, this.desc, this.dir, exitCode, message));
        }
    }

    private static class Holder<V> {
        final V value;

        Holder(V value) {
            this.value = value;
        }
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream in;
        private OutputStream out;

        public StreamGobbler(InputStream stream, OutputStream output) {
            this.in = stream;
            this.out = output;
        }

        @Override
        public void run() {
            try {
                this.copy();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void copy() throws IOException {
            int readBytes;
            boolean writeFailure = false;
            byte[] buffer = new byte[4096];
            while ((readBytes = this.in.read(buffer)) != -1) {
                if (writeFailure || this.out == null) continue;
                try {
                    this.out.write(buffer, 0, readBytes);
                    this.out.flush();
                }
                catch (IOException e2) {
                    writeFailure = true;
                }
            }
        }
    }
}

