/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;

final class GeoLatitudeValueSource
extends ValueSource {
    final IndexFieldData<?> fieldData;

    GeoLatitudeValueSource(IndexFieldData<?> fieldData) {
        this.fieldData = Objects.requireNonNull(fieldData);
    }

    public FunctionValues getValues(Map context, LeafReaderContext leaf) throws IOException {
        AtomicGeoPointFieldData leafData = (AtomicGeoPointFieldData)this.fieldData.load(leaf);
        final MultiGeoPointValues values = leafData.getGeoPointValues();
        return new DoubleDocValues(this){

            public double doubleVal(int doc) throws IOException {
                if (values.advanceExact(doc)) {
                    return values.nextValue().getLat();
                }
                return 0.0;
            }
        };
    }

    public int hashCode() {
        return 31 * ((Object)((Object)this)).getClass().hashCode() + this.fieldData.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GeoLatitudeValueSource other = (GeoLatitudeValueSource)((Object)obj);
        return this.fieldData.equals(other.fieldData);
    }

    public String description() {
        return "lat: field(" + this.fieldData.getFieldName() + ")";
    }
}

