/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tribe;

import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.single.SingleNodeDiscovery;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.tribe.TribeService;

public class TribeDiscovery
extends SingleNodeDiscovery
implements Discovery {
    private final Settings settings;

    @Inject
    public TribeDiscovery(Settings settings, TransportService transportService, MasterService masterService, ClusterApplier clusterApplier) {
        super(settings, transportService, masterService, clusterApplier);
        this.settings = settings;
    }

    protected ClusterState createInitialState(DiscoveryNode localNode) {
        ClusterBlocks.Builder clusterBlocks = ClusterBlocks.builder();
        if (((Boolean)TribeService.BLOCKS_WRITE_SETTING.get(this.settings)).booleanValue()) {
            clusterBlocks.addGlobalBlock(TribeService.TRIBE_WRITE_BLOCK);
        }
        if (((Boolean)TribeService.BLOCKS_METADATA_SETTING.get(this.settings)).booleanValue()) {
            clusterBlocks.addGlobalBlock(TribeService.TRIBE_METADATA_BLOCK);
        }
        return ClusterState.builder((ClusterName)((ClusterName)ClusterName.CLUSTER_NAME_SETTING.get(this.settings))).nodes(DiscoveryNodes.builder().add(localNode).localNodeId(localNode.getId()).build()).blocks(clusterBlocks).build();
    }

    public synchronized void startInitialJoin() {
    }
}

