/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

abstract class AbstractStringProcessor<T>
extends AbstractProcessor {
    private final String field;
    private final boolean ignoreMissing;
    private final String targetField;

    AbstractStringProcessor(String tag, String field, boolean ignoreMissing, String targetField) {
        super(tag);
        this.field = field;
        this.ignoreMissing = ignoreMissing;
        this.targetField = targetField;
    }

    public String getField() {
        return this.field;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    String getTargetField() {
        return this.targetField;
    }

    public final IngestDocument execute(IngestDocument document) {
        String val = (String)document.getFieldValue(this.field, String.class, this.ignoreMissing);
        if (val == null && this.ignoreMissing) {
            return document;
        }
        if (val == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot process it.");
        }
        document.setFieldValue(this.targetField, this.process(val));
        return document;
    }

    protected abstract T process(String var1);

    static abstract class Factory
    implements Processor.Factory {
        final String processorType;

        protected Factory(String processorType) {
            this.processorType = processorType;
        }

        public AbstractStringProcessor create(Map<String, Processor.Factory> registry, String tag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)this.processorType, (String)tag, config, (String)"field");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)this.processorType, (String)tag, config, (String)"ignore_missing", (boolean)false);
            String targetField = ConfigurationUtils.readStringProperty((String)this.processorType, (String)tag, config, (String)"target_field", (String)field);
            return this.newProcessor(tag, config, field, ignoreMissing, targetField);
        }

        protected abstract AbstractStringProcessor newProcessor(String var1, Map<String, Object> var2, String var3, boolean var4, String var5);
    }
}

